/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.api.kv.impl.options;

import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import org.apache.bookkeeper.api.kv.impl.options.RangeOptionImpl;
import org.apache.bookkeeper.api.kv.options.RangeOption;
import org.apache.bookkeeper.api.kv.options.RangeOptionBuilder;

class RangeOptionBuilderImpl<K>
implements RangeOptionBuilder<K> {
    private final Recycler.Handle<RangeOptionBuilderImpl<K>> handle;
    private final Recycler<RangeOptionImpl<K>> optionRecycler;
    private long limit = -1L;
    private long minModRev = Long.MIN_VALUE;
    private long maxModRev = Long.MAX_VALUE;
    private long minCreateRev = Long.MIN_VALUE;
    private long maxCreateRev = Long.MAX_VALUE;
    private boolean keysOnly;
    private boolean countOnly;
    private K endKey;

    static <K> RangeOptionBuilderImpl<K> create(Recycler<RangeOptionBuilderImpl<K>> buildRecyler) {
        return (RangeOptionBuilderImpl)buildRecyler.get();
    }

    RangeOptionBuilderImpl(Recycler.Handle<RangeOptionBuilderImpl<K>> handle, Recycler<RangeOptionImpl<K>> optionRecycler) {
        this.handle = handle;
        this.optionRecycler = optionRecycler;
    }

    @Override
    public RangeOptionBuilderImpl<K> endKey(K endKey) {
        ReferenceCountUtil.release(this.endKey);
        this.endKey = ReferenceCountUtil.retain(endKey);
        return this;
    }

    @Override
    public RangeOption<K> build() {
        try {
            RangeOptionImpl<K> option = RangeOptionImpl.create(this.optionRecycler);
            option.set(this);
            RangeOptionImpl<K> rangeOptionImpl = option;
            return rangeOptionImpl;
        }
        finally {
            this.recycle();
        }
    }

    private void recycle() {
        this.limit = -1L;
        this.minCreateRev = Long.MIN_VALUE;
        this.minModRev = Long.MIN_VALUE;
        this.maxCreateRev = Long.MAX_VALUE;
        this.maxModRev = Long.MAX_VALUE;
        this.keysOnly = false;
        this.countOnly = false;
        ReferenceCountUtil.release(this.endKey);
        this.endKey = null;
        this.handle.recycle((Object)this);
    }

    @Override
    public RangeOptionBuilderImpl<K> limit(long limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public RangeOptionBuilderImpl<K> minModRev(long minModRev) {
        this.minModRev = minModRev;
        return this;
    }

    @Override
    public RangeOptionBuilderImpl<K> maxModRev(long maxModRev) {
        this.maxModRev = maxModRev;
        return this;
    }

    @Override
    public RangeOptionBuilderImpl<K> minCreateRev(long minCreateRev) {
        this.minCreateRev = minCreateRev;
        return this;
    }

    @Override
    public RangeOptionBuilderImpl<K> maxCreateRev(long maxCreateRev) {
        this.maxCreateRev = maxCreateRev;
        return this;
    }

    @Override
    public RangeOptionBuilderImpl<K> keysOnly(boolean keysOnly) {
        this.keysOnly = keysOnly;
        return this;
    }

    @Override
    public RangeOptionBuilderImpl<K> countOnly(boolean countOnly) {
        this.countOnly = countOnly;
        return this;
    }

    Recycler.Handle<RangeOptionBuilderImpl<K>> handle() {
        return this.handle;
    }

    Recycler<RangeOptionImpl<K>> optionRecycler() {
        return this.optionRecycler;
    }

    long limit() {
        return this.limit;
    }

    long minModRev() {
        return this.minModRev;
    }

    long maxModRev() {
        return this.maxModRev;
    }

    long minCreateRev() {
        return this.minCreateRev;
    }

    long maxCreateRev() {
        return this.maxCreateRev;
    }

    boolean keysOnly() {
        return this.keysOnly;
    }

    boolean countOnly() {
        return this.countOnly;
    }

    K endKey() {
        return this.endKey;
    }
}

