/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.V1APIGroup;
import io.kubernetes.client.openapi.models.V1APIGroupFluent;
import io.kubernetes.client.openapi.models.V1GroupVersionForDiscovery;
import io.kubernetes.client.openapi.models.V1GroupVersionForDiscoveryBuilder;
import io.kubernetes.client.openapi.models.V1GroupVersionForDiscoveryFluentImpl;
import io.kubernetes.client.openapi.models.V1ServerAddressByClientCIDR;
import io.kubernetes.client.openapi.models.V1ServerAddressByClientCIDRBuilder;
import io.kubernetes.client.openapi.models.V1ServerAddressByClientCIDRFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class V1APIGroupFluentImpl<A extends V1APIGroupFluent<A>>
extends BaseFluent<A>
implements V1APIGroupFluent<A> {
    private String apiVersion;
    private String kind;
    private String name;
    private V1GroupVersionForDiscoveryBuilder preferredVersion;
    private List<V1ServerAddressByClientCIDRBuilder> serverAddressByClientCIDRs;
    private List<V1GroupVersionForDiscoveryBuilder> versions;

    public V1APIGroupFluentImpl() {
    }

    public V1APIGroupFluentImpl(V1APIGroup instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withPreferredVersion(instance.getPreferredVersion());
        this.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
        this.withVersions(instance.getVersions());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    @Deprecated
    public V1GroupVersionForDiscovery getPreferredVersion() {
        return this.preferredVersion != null ? this.preferredVersion.build() : null;
    }

    @Override
    public V1GroupVersionForDiscovery buildPreferredVersion() {
        return this.preferredVersion != null ? this.preferredVersion.build() : null;
    }

    @Override
    public A withPreferredVersion(V1GroupVersionForDiscovery preferredVersion) {
        this._visitables.get("preferredVersion").remove(this.preferredVersion);
        if (preferredVersion != null) {
            this.preferredVersion = new V1GroupVersionForDiscoveryBuilder(preferredVersion);
            this._visitables.get("preferredVersion").add(this.preferredVersion);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPreferredVersion() {
        return this.preferredVersion != null;
    }

    @Override
    public V1APIGroupFluent.PreferredVersionNested<A> withNewPreferredVersion() {
        return new PreferredVersionNestedImpl();
    }

    @Override
    public V1APIGroupFluent.PreferredVersionNested<A> withNewPreferredVersionLike(V1GroupVersionForDiscovery item) {
        return new PreferredVersionNestedImpl(item);
    }

    @Override
    public V1APIGroupFluent.PreferredVersionNested<A> editPreferredVersion() {
        return this.withNewPreferredVersionLike(this.getPreferredVersion());
    }

    @Override
    public V1APIGroupFluent.PreferredVersionNested<A> editOrNewPreferredVersion() {
        return this.withNewPreferredVersionLike(this.getPreferredVersion() != null ? this.getPreferredVersion() : new V1GroupVersionForDiscoveryBuilder().build());
    }

    @Override
    public V1APIGroupFluent.PreferredVersionNested<A> editOrNewPreferredVersionLike(V1GroupVersionForDiscovery item) {
        return this.withNewPreferredVersionLike(this.getPreferredVersion() != null ? this.getPreferredVersion() : item);
    }

    @Override
    public A addToServerAddressByClientCIDRs(int index, V1ServerAddressByClientCIDR item) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList<V1ServerAddressByClientCIDRBuilder>();
        }
        V1ServerAddressByClientCIDRBuilder builder = new V1ServerAddressByClientCIDRBuilder(item);
        this._visitables.get("serverAddressByClientCIDRs").add(index >= 0 ? index : this._visitables.get("serverAddressByClientCIDRs").size(), builder);
        this.serverAddressByClientCIDRs.add(index >= 0 ? index : this.serverAddressByClientCIDRs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToServerAddressByClientCIDRs(int index, V1ServerAddressByClientCIDR item) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList<V1ServerAddressByClientCIDRBuilder>();
        }
        V1ServerAddressByClientCIDRBuilder builder = new V1ServerAddressByClientCIDRBuilder(item);
        if (index < 0 || index >= this._visitables.get("serverAddressByClientCIDRs").size()) {
            this._visitables.get("serverAddressByClientCIDRs").add(builder);
        } else {
            this._visitables.get("serverAddressByClientCIDRs").set(index, builder);
        }
        if (index < 0 || index >= this.serverAddressByClientCIDRs.size()) {
            this.serverAddressByClientCIDRs.add(builder);
        } else {
            this.serverAddressByClientCIDRs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToServerAddressByClientCIDRs(V1ServerAddressByClientCIDR ... items) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList<V1ServerAddressByClientCIDRBuilder>();
        }
        for (V1ServerAddressByClientCIDR item : items) {
            V1ServerAddressByClientCIDRBuilder builder = new V1ServerAddressByClientCIDRBuilder(item);
            this._visitables.get("serverAddressByClientCIDRs").add(builder);
            this.serverAddressByClientCIDRs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToServerAddressByClientCIDRs(Collection<V1ServerAddressByClientCIDR> items) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList<V1ServerAddressByClientCIDRBuilder>();
        }
        for (V1ServerAddressByClientCIDR item : items) {
            V1ServerAddressByClientCIDRBuilder builder = new V1ServerAddressByClientCIDRBuilder(item);
            this._visitables.get("serverAddressByClientCIDRs").add(builder);
            this.serverAddressByClientCIDRs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromServerAddressByClientCIDRs(V1ServerAddressByClientCIDR ... items) {
        for (V1ServerAddressByClientCIDR item : items) {
            V1ServerAddressByClientCIDRBuilder builder = new V1ServerAddressByClientCIDRBuilder(item);
            this._visitables.get("serverAddressByClientCIDRs").remove(builder);
            if (this.serverAddressByClientCIDRs == null) continue;
            this.serverAddressByClientCIDRs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServerAddressByClientCIDRs(Collection<V1ServerAddressByClientCIDR> items) {
        for (V1ServerAddressByClientCIDR item : items) {
            V1ServerAddressByClientCIDRBuilder builder = new V1ServerAddressByClientCIDRBuilder(item);
            this._visitables.get("serverAddressByClientCIDRs").remove(builder);
            if (this.serverAddressByClientCIDRs == null) continue;
            this.serverAddressByClientCIDRs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromServerAddressByClientCIDRs(Predicate<V1ServerAddressByClientCIDRBuilder> predicate) {
        if (this.serverAddressByClientCIDRs == null) {
            return (A)this;
        }
        Iterator<V1ServerAddressByClientCIDRBuilder> each = this.serverAddressByClientCIDRs.iterator();
        Object visitables = this._visitables.get("serverAddressByClientCIDRs");
        while (each.hasNext()) {
            V1ServerAddressByClientCIDRBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1ServerAddressByClientCIDR> getServerAddressByClientCIDRs() {
        return V1APIGroupFluentImpl.build(this.serverAddressByClientCIDRs);
    }

    @Override
    public List<V1ServerAddressByClientCIDR> buildServerAddressByClientCIDRs() {
        return V1APIGroupFluentImpl.build(this.serverAddressByClientCIDRs);
    }

    @Override
    public V1ServerAddressByClientCIDR buildServerAddressByClientCIDR(int index) {
        return this.serverAddressByClientCIDRs.get(index).build();
    }

    @Override
    public V1ServerAddressByClientCIDR buildFirstServerAddressByClientCIDR() {
        return this.serverAddressByClientCIDRs.get(0).build();
    }

    @Override
    public V1ServerAddressByClientCIDR buildLastServerAddressByClientCIDR() {
        return this.serverAddressByClientCIDRs.get(this.serverAddressByClientCIDRs.size() - 1).build();
    }

    @Override
    public V1ServerAddressByClientCIDR buildMatchingServerAddressByClientCIDR(Predicate<V1ServerAddressByClientCIDRBuilder> predicate) {
        for (V1ServerAddressByClientCIDRBuilder item : this.serverAddressByClientCIDRs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingServerAddressByClientCIDR(Predicate<V1ServerAddressByClientCIDRBuilder> predicate) {
        for (V1ServerAddressByClientCIDRBuilder item : this.serverAddressByClientCIDRs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServerAddressByClientCIDRs(List<V1ServerAddressByClientCIDR> serverAddressByClientCIDRs) {
        if (this.serverAddressByClientCIDRs != null) {
            this._visitables.get("serverAddressByClientCIDRs").removeAll(this.serverAddressByClientCIDRs);
        }
        if (serverAddressByClientCIDRs != null) {
            this.serverAddressByClientCIDRs = new ArrayList<V1ServerAddressByClientCIDRBuilder>();
            for (V1ServerAddressByClientCIDR item : serverAddressByClientCIDRs) {
                this.addToServerAddressByClientCIDRs(item);
            }
        } else {
            this.serverAddressByClientCIDRs = null;
        }
        return (A)this;
    }

    @Override
    public A withServerAddressByClientCIDRs(V1ServerAddressByClientCIDR ... serverAddressByClientCIDRs) {
        if (this.serverAddressByClientCIDRs != null) {
            this.serverAddressByClientCIDRs.clear();
        }
        if (serverAddressByClientCIDRs != null) {
            for (V1ServerAddressByClientCIDR item : serverAddressByClientCIDRs) {
                this.addToServerAddressByClientCIDRs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServerAddressByClientCIDRs() {
        return this.serverAddressByClientCIDRs != null && !this.serverAddressByClientCIDRs.isEmpty();
    }

    @Override
    public V1APIGroupFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDR() {
        return new ServerAddressByClientCIDRsNestedImpl();
    }

    @Override
    public V1APIGroupFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDRLike(V1ServerAddressByClientCIDR item) {
        return new ServerAddressByClientCIDRsNestedImpl(-1, item);
    }

    @Override
    public V1APIGroupFluent.ServerAddressByClientCIDRsNested<A> setNewServerAddressByClientCIDRLike(int index, V1ServerAddressByClientCIDR item) {
        return new ServerAddressByClientCIDRsNestedImpl(index, item);
    }

    @Override
    public V1APIGroupFluent.ServerAddressByClientCIDRsNested<A> editServerAddressByClientCIDR(int index) {
        if (this.serverAddressByClientCIDRs.size() <= index) {
            throw new RuntimeException("Can't edit serverAddressByClientCIDRs. Index exceeds size.");
        }
        return this.setNewServerAddressByClientCIDRLike(index, this.buildServerAddressByClientCIDR(index));
    }

    @Override
    public V1APIGroupFluent.ServerAddressByClientCIDRsNested<A> editFirstServerAddressByClientCIDR() {
        if (this.serverAddressByClientCIDRs.size() == 0) {
            throw new RuntimeException("Can't edit first serverAddressByClientCIDRs. The list is empty.");
        }
        return this.setNewServerAddressByClientCIDRLike(0, this.buildServerAddressByClientCIDR(0));
    }

    @Override
    public V1APIGroupFluent.ServerAddressByClientCIDRsNested<A> editLastServerAddressByClientCIDR() {
        int index = this.serverAddressByClientCIDRs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last serverAddressByClientCIDRs. The list is empty.");
        }
        return this.setNewServerAddressByClientCIDRLike(index, this.buildServerAddressByClientCIDR(index));
    }

    @Override
    public V1APIGroupFluent.ServerAddressByClientCIDRsNested<A> editMatchingServerAddressByClientCIDR(Predicate<V1ServerAddressByClientCIDRBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serverAddressByClientCIDRs.size(); ++i) {
            if (!predicate.apply(this.serverAddressByClientCIDRs.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching serverAddressByClientCIDRs. No match found.");
        }
        return this.setNewServerAddressByClientCIDRLike(index, this.buildServerAddressByClientCIDR(index));
    }

    @Override
    public A addToVersions(int index, V1GroupVersionForDiscovery item) {
        if (this.versions == null) {
            this.versions = new ArrayList<V1GroupVersionForDiscoveryBuilder>();
        }
        V1GroupVersionForDiscoveryBuilder builder = new V1GroupVersionForDiscoveryBuilder(item);
        this._visitables.get("versions").add(index >= 0 ? index : this._visitables.get("versions").size(), builder);
        this.versions.add(index >= 0 ? index : this.versions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVersions(int index, V1GroupVersionForDiscovery item) {
        if (this.versions == null) {
            this.versions = new ArrayList<V1GroupVersionForDiscoveryBuilder>();
        }
        V1GroupVersionForDiscoveryBuilder builder = new V1GroupVersionForDiscoveryBuilder(item);
        if (index < 0 || index >= this._visitables.get("versions").size()) {
            this._visitables.get("versions").add(builder);
        } else {
            this._visitables.get("versions").set(index, builder);
        }
        if (index < 0 || index >= this.versions.size()) {
            this.versions.add(builder);
        } else {
            this.versions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVersions(V1GroupVersionForDiscovery ... items) {
        if (this.versions == null) {
            this.versions = new ArrayList<V1GroupVersionForDiscoveryBuilder>();
        }
        for (V1GroupVersionForDiscovery item : items) {
            V1GroupVersionForDiscoveryBuilder builder = new V1GroupVersionForDiscoveryBuilder(item);
            this._visitables.get("versions").add(builder);
            this.versions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVersions(Collection<V1GroupVersionForDiscovery> items) {
        if (this.versions == null) {
            this.versions = new ArrayList<V1GroupVersionForDiscoveryBuilder>();
        }
        for (V1GroupVersionForDiscovery item : items) {
            V1GroupVersionForDiscoveryBuilder builder = new V1GroupVersionForDiscoveryBuilder(item);
            this._visitables.get("versions").add(builder);
            this.versions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVersions(V1GroupVersionForDiscovery ... items) {
        for (V1GroupVersionForDiscovery item : items) {
            V1GroupVersionForDiscoveryBuilder builder = new V1GroupVersionForDiscoveryBuilder(item);
            this._visitables.get("versions").remove(builder);
            if (this.versions == null) continue;
            this.versions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVersions(Collection<V1GroupVersionForDiscovery> items) {
        for (V1GroupVersionForDiscovery item : items) {
            V1GroupVersionForDiscoveryBuilder builder = new V1GroupVersionForDiscoveryBuilder(item);
            this._visitables.get("versions").remove(builder);
            if (this.versions == null) continue;
            this.versions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVersions(Predicate<V1GroupVersionForDiscoveryBuilder> predicate) {
        if (this.versions == null) {
            return (A)this;
        }
        Iterator<V1GroupVersionForDiscoveryBuilder> each = this.versions.iterator();
        Object visitables = this._visitables.get("versions");
        while (each.hasNext()) {
            V1GroupVersionForDiscoveryBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1GroupVersionForDiscovery> getVersions() {
        return V1APIGroupFluentImpl.build(this.versions);
    }

    @Override
    public List<V1GroupVersionForDiscovery> buildVersions() {
        return V1APIGroupFluentImpl.build(this.versions);
    }

    @Override
    public V1GroupVersionForDiscovery buildVersion(int index) {
        return this.versions.get(index).build();
    }

    @Override
    public V1GroupVersionForDiscovery buildFirstVersion() {
        return this.versions.get(0).build();
    }

    @Override
    public V1GroupVersionForDiscovery buildLastVersion() {
        return this.versions.get(this.versions.size() - 1).build();
    }

    @Override
    public V1GroupVersionForDiscovery buildMatchingVersion(Predicate<V1GroupVersionForDiscoveryBuilder> predicate) {
        for (V1GroupVersionForDiscoveryBuilder item : this.versions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVersion(Predicate<V1GroupVersionForDiscoveryBuilder> predicate) {
        for (V1GroupVersionForDiscoveryBuilder item : this.versions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVersions(List<V1GroupVersionForDiscovery> versions) {
        if (this.versions != null) {
            this._visitables.get("versions").removeAll(this.versions);
        }
        if (versions != null) {
            this.versions = new ArrayList<V1GroupVersionForDiscoveryBuilder>();
            for (V1GroupVersionForDiscovery item : versions) {
                this.addToVersions(item);
            }
        } else {
            this.versions = null;
        }
        return (A)this;
    }

    @Override
    public A withVersions(V1GroupVersionForDiscovery ... versions) {
        if (this.versions != null) {
            this.versions.clear();
        }
        if (versions != null) {
            for (V1GroupVersionForDiscovery item : versions) {
                this.addToVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVersions() {
        return this.versions != null && !this.versions.isEmpty();
    }

    @Override
    public V1APIGroupFluent.VersionsNested<A> addNewVersion() {
        return new VersionsNestedImpl();
    }

    @Override
    public V1APIGroupFluent.VersionsNested<A> addNewVersionLike(V1GroupVersionForDiscovery item) {
        return new VersionsNestedImpl(-1, item);
    }

    @Override
    public V1APIGroupFluent.VersionsNested<A> setNewVersionLike(int index, V1GroupVersionForDiscovery item) {
        return new VersionsNestedImpl(index, item);
    }

    @Override
    public V1APIGroupFluent.VersionsNested<A> editVersion(int index) {
        if (this.versions.size() <= index) {
            throw new RuntimeException("Can't edit versions. Index exceeds size.");
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    @Override
    public V1APIGroupFluent.VersionsNested<A> editFirstVersion() {
        if (this.versions.size() == 0) {
            throw new RuntimeException("Can't edit first versions. The list is empty.");
        }
        return this.setNewVersionLike(0, this.buildVersion(0));
    }

    @Override
    public V1APIGroupFluent.VersionsNested<A> editLastVersion() {
        int index = this.versions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last versions. The list is empty.");
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    @Override
    public V1APIGroupFluent.VersionsNested<A> editMatchingVersion(Predicate<V1GroupVersionForDiscoveryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.versions.size(); ++i) {
            if (!predicate.apply(this.versions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching versions. No match found.");
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIGroupFluentImpl that = (V1APIGroupFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.preferredVersion != null ? !this.preferredVersion.equals(that.preferredVersion) : that.preferredVersion != null) {
            return false;
        }
        if (this.serverAddressByClientCIDRs != null ? !this.serverAddressByClientCIDRs.equals(that.serverAddressByClientCIDRs) : that.serverAddressByClientCIDRs != null) {
            return false;
        }
        return !(this.versions != null ? !this.versions.equals(that.versions) : that.versions != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.name, this.preferredVersion, this.serverAddressByClientCIDRs, this.versions, super.hashCode());
    }

    public class VersionsNestedImpl<N>
    extends V1GroupVersionForDiscoveryFluentImpl<V1APIGroupFluent.VersionsNested<N>>
    implements V1APIGroupFluent.VersionsNested<N>,
    Nested<N> {
        private final V1GroupVersionForDiscoveryBuilder builder;
        private final int index;

        VersionsNestedImpl(int index, V1GroupVersionForDiscovery item) {
            this.index = index;
            this.builder = new V1GroupVersionForDiscoveryBuilder(this, item);
        }

        VersionsNestedImpl() {
            this.index = -1;
            this.builder = new V1GroupVersionForDiscoveryBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1APIGroupFluentImpl.this.setToVersions(this.index, this.builder.build());
        }

        @Override
        public N endVersion() {
            return this.and();
        }
    }

    public class ServerAddressByClientCIDRsNestedImpl<N>
    extends V1ServerAddressByClientCIDRFluentImpl<V1APIGroupFluent.ServerAddressByClientCIDRsNested<N>>
    implements V1APIGroupFluent.ServerAddressByClientCIDRsNested<N>,
    Nested<N> {
        private final V1ServerAddressByClientCIDRBuilder builder;
        private final int index;

        ServerAddressByClientCIDRsNestedImpl(int index, V1ServerAddressByClientCIDR item) {
            this.index = index;
            this.builder = new V1ServerAddressByClientCIDRBuilder(this, item);
        }

        ServerAddressByClientCIDRsNestedImpl() {
            this.index = -1;
            this.builder = new V1ServerAddressByClientCIDRBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1APIGroupFluentImpl.this.setToServerAddressByClientCIDRs(this.index, this.builder.build());
        }

        @Override
        public N endServerAddressByClientCIDR() {
            return this.and();
        }
    }

    public class PreferredVersionNestedImpl<N>
    extends V1GroupVersionForDiscoveryFluentImpl<V1APIGroupFluent.PreferredVersionNested<N>>
    implements V1APIGroupFluent.PreferredVersionNested<N>,
    Nested<N> {
        private final V1GroupVersionForDiscoveryBuilder builder;

        PreferredVersionNestedImpl(V1GroupVersionForDiscovery item) {
            this.builder = new V1GroupVersionForDiscoveryBuilder(this, item);
        }

        PreferredVersionNestedImpl() {
            this.builder = new V1GroupVersionForDiscoveryBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1APIGroupFluentImpl.this.withPreferredVersion(this.builder.build());
        }

        @Override
        public N endPreferredVersion() {
            return this.and();
        }
    }
}

