/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.array;

import io.airlift.slice.SizeOf;
import io.prestosql.array.BigArrays;
import java.util.Arrays;
import org.openjdk.jol.info.ClassLayout;

public final class ByteBigArray {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ByteBigArray.class).instanceSize();
    private static final long SIZE_OF_SEGMENT = SizeOf.sizeOfByteArray((int)1024);
    private final byte initialValue;
    private byte[][] array;
    private int capacity;
    private int segments;

    public ByteBigArray() {
        this(0);
    }

    public ByteBigArray(byte initialValue) {
        this.initialValue = initialValue;
        this.array = new byte[1024][];
        this.allocateNewSegment();
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.array) + (long)this.segments * SIZE_OF_SEGMENT;
    }

    public byte get(long index) {
        return this.array[BigArrays.segment(index)][BigArrays.offset(index)];
    }

    public void set(long index, byte value) {
        this.array[BigArrays.segment((long)index)][BigArrays.offset((long)index)] = value;
    }

    public void ensureCapacity(long length) {
        if ((long)this.capacity > length) {
            return;
        }
        this.grow(length);
    }

    private void grow(long length) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (byte[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment();
        }
    }

    private void allocateNewSegment() {
        byte[] newSegment = new byte[1024];
        if (this.initialValue != 0) {
            Arrays.fill(newSegment, this.initialValue);
        }
        this.array[this.segments] = newSegment;
        this.capacity += 1024;
        ++this.segments;
    }
}

