/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.mledger.MetadataCompressionConfig;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public class ManagedLedgerFactoryConfig {
    private static final long MB = 0x100000L;
    private long maxCacheSize = 0x8000000L;
    private double cacheEvictionWatermark = 0.9;
    private int numManagedLedgerSchedulerThreads = Runtime.getRuntime().availableProcessors();
    private long cacheEvictionIntervalMs = 10L;
    private long cacheEvictionTimeThresholdMillis = 1000L;
    private boolean copyEntriesInCache = false;
    private long managedLedgerMaxReadsInFlightSize = 0L;
    private boolean traceTaskExecution = true;
    private int prometheusStatsLatencyRolloverSeconds = 60;
    private int cursorPositionFlushSeconds = 60;
    private int statsPeriodSeconds = 60;
    private String clusterName;
    private String managedLedgerInfoCompressionType = MLDataFormats.CompressionType.NONE.name();
    private long managedLedgerInfoCompressionThresholdInBytes = 0L;
    private String managedCursorInfoCompressionType = MLDataFormats.CompressionType.NONE.name();
    private long managedCursorInfoCompressionThresholdInBytes = 0L;

    public MetadataCompressionConfig getCompressionConfigForManagedLedgerInfo() {
        return new MetadataCompressionConfig(this.managedLedgerInfoCompressionType, this.managedLedgerInfoCompressionThresholdInBytes);
    }

    public MetadataCompressionConfig getCompressionConfigForManagedCursorInfo() {
        return new MetadataCompressionConfig(this.managedCursorInfoCompressionType, this.managedCursorInfoCompressionThresholdInBytes);
    }

    public long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public double getCacheEvictionWatermark() {
        return this.cacheEvictionWatermark;
    }

    public int getNumManagedLedgerSchedulerThreads() {
        return this.numManagedLedgerSchedulerThreads;
    }

    public long getCacheEvictionIntervalMs() {
        return this.cacheEvictionIntervalMs;
    }

    public long getCacheEvictionTimeThresholdMillis() {
        return this.cacheEvictionTimeThresholdMillis;
    }

    public boolean isCopyEntriesInCache() {
        return this.copyEntriesInCache;
    }

    public long getManagedLedgerMaxReadsInFlightSize() {
        return this.managedLedgerMaxReadsInFlightSize;
    }

    public boolean isTraceTaskExecution() {
        return this.traceTaskExecution;
    }

    public int getPrometheusStatsLatencyRolloverSeconds() {
        return this.prometheusStatsLatencyRolloverSeconds;
    }

    public int getCursorPositionFlushSeconds() {
        return this.cursorPositionFlushSeconds;
    }

    public int getStatsPeriodSeconds() {
        return this.statsPeriodSeconds;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getManagedLedgerInfoCompressionType() {
        return this.managedLedgerInfoCompressionType;
    }

    public long getManagedLedgerInfoCompressionThresholdInBytes() {
        return this.managedLedgerInfoCompressionThresholdInBytes;
    }

    public String getManagedCursorInfoCompressionType() {
        return this.managedCursorInfoCompressionType;
    }

    public long getManagedCursorInfoCompressionThresholdInBytes() {
        return this.managedCursorInfoCompressionThresholdInBytes;
    }

    public void setMaxCacheSize(long maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public void setCacheEvictionWatermark(double cacheEvictionWatermark) {
        this.cacheEvictionWatermark = cacheEvictionWatermark;
    }

    public void setNumManagedLedgerSchedulerThreads(int numManagedLedgerSchedulerThreads) {
        this.numManagedLedgerSchedulerThreads = numManagedLedgerSchedulerThreads;
    }

    public void setCacheEvictionIntervalMs(long cacheEvictionIntervalMs) {
        this.cacheEvictionIntervalMs = cacheEvictionIntervalMs;
    }

    public void setCacheEvictionTimeThresholdMillis(long cacheEvictionTimeThresholdMillis) {
        this.cacheEvictionTimeThresholdMillis = cacheEvictionTimeThresholdMillis;
    }

    public void setCopyEntriesInCache(boolean copyEntriesInCache) {
        this.copyEntriesInCache = copyEntriesInCache;
    }

    public void setManagedLedgerMaxReadsInFlightSize(long managedLedgerMaxReadsInFlightSize) {
        this.managedLedgerMaxReadsInFlightSize = managedLedgerMaxReadsInFlightSize;
    }

    public void setTraceTaskExecution(boolean traceTaskExecution) {
        this.traceTaskExecution = traceTaskExecution;
    }

    public void setPrometheusStatsLatencyRolloverSeconds(int prometheusStatsLatencyRolloverSeconds) {
        this.prometheusStatsLatencyRolloverSeconds = prometheusStatsLatencyRolloverSeconds;
    }

    public void setCursorPositionFlushSeconds(int cursorPositionFlushSeconds) {
        this.cursorPositionFlushSeconds = cursorPositionFlushSeconds;
    }

    public void setStatsPeriodSeconds(int statsPeriodSeconds) {
        this.statsPeriodSeconds = statsPeriodSeconds;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setManagedLedgerInfoCompressionType(String managedLedgerInfoCompressionType) {
        this.managedLedgerInfoCompressionType = managedLedgerInfoCompressionType;
    }

    public void setManagedLedgerInfoCompressionThresholdInBytes(long managedLedgerInfoCompressionThresholdInBytes) {
        this.managedLedgerInfoCompressionThresholdInBytes = managedLedgerInfoCompressionThresholdInBytes;
    }

    public void setManagedCursorInfoCompressionType(String managedCursorInfoCompressionType) {
        this.managedCursorInfoCompressionType = managedCursorInfoCompressionType;
    }

    public void setManagedCursorInfoCompressionThresholdInBytes(long managedCursorInfoCompressionThresholdInBytes) {
        this.managedCursorInfoCompressionThresholdInBytes = managedCursorInfoCompressionThresholdInBytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManagedLedgerFactoryConfig)) {
            return false;
        }
        ManagedLedgerFactoryConfig other = (ManagedLedgerFactoryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxCacheSize() != other.getMaxCacheSize()) {
            return false;
        }
        if (Double.compare(this.getCacheEvictionWatermark(), other.getCacheEvictionWatermark()) != 0) {
            return false;
        }
        if (this.getNumManagedLedgerSchedulerThreads() != other.getNumManagedLedgerSchedulerThreads()) {
            return false;
        }
        if (this.getCacheEvictionIntervalMs() != other.getCacheEvictionIntervalMs()) {
            return false;
        }
        if (this.getCacheEvictionTimeThresholdMillis() != other.getCacheEvictionTimeThresholdMillis()) {
            return false;
        }
        if (this.isCopyEntriesInCache() != other.isCopyEntriesInCache()) {
            return false;
        }
        if (this.getManagedLedgerMaxReadsInFlightSize() != other.getManagedLedgerMaxReadsInFlightSize()) {
            return false;
        }
        if (this.isTraceTaskExecution() != other.isTraceTaskExecution()) {
            return false;
        }
        if (this.getPrometheusStatsLatencyRolloverSeconds() != other.getPrometheusStatsLatencyRolloverSeconds()) {
            return false;
        }
        if (this.getCursorPositionFlushSeconds() != other.getCursorPositionFlushSeconds()) {
            return false;
        }
        if (this.getStatsPeriodSeconds() != other.getStatsPeriodSeconds()) {
            return false;
        }
        if (this.getManagedLedgerInfoCompressionThresholdInBytes() != other.getManagedLedgerInfoCompressionThresholdInBytes()) {
            return false;
        }
        if (this.getManagedCursorInfoCompressionThresholdInBytes() != other.getManagedCursorInfoCompressionThresholdInBytes()) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$managedLedgerInfoCompressionType = this.getManagedLedgerInfoCompressionType();
        String other$managedLedgerInfoCompressionType = other.getManagedLedgerInfoCompressionType();
        if (this$managedLedgerInfoCompressionType == null ? other$managedLedgerInfoCompressionType != null : !this$managedLedgerInfoCompressionType.equals(other$managedLedgerInfoCompressionType)) {
            return false;
        }
        String this$managedCursorInfoCompressionType = this.getManagedCursorInfoCompressionType();
        String other$managedCursorInfoCompressionType = other.getManagedCursorInfoCompressionType();
        return !(this$managedCursorInfoCompressionType == null ? other$managedCursorInfoCompressionType != null : !this$managedCursorInfoCompressionType.equals(other$managedCursorInfoCompressionType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ManagedLedgerFactoryConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxCacheSize = this.getMaxCacheSize();
        result = result * 59 + (int)($maxCacheSize >>> 32 ^ $maxCacheSize);
        long $cacheEvictionWatermark = Double.doubleToLongBits(this.getCacheEvictionWatermark());
        result = result * 59 + (int)($cacheEvictionWatermark >>> 32 ^ $cacheEvictionWatermark);
        result = result * 59 + this.getNumManagedLedgerSchedulerThreads();
        long $cacheEvictionIntervalMs = this.getCacheEvictionIntervalMs();
        result = result * 59 + (int)($cacheEvictionIntervalMs >>> 32 ^ $cacheEvictionIntervalMs);
        long $cacheEvictionTimeThresholdMillis = this.getCacheEvictionTimeThresholdMillis();
        result = result * 59 + (int)($cacheEvictionTimeThresholdMillis >>> 32 ^ $cacheEvictionTimeThresholdMillis);
        result = result * 59 + (this.isCopyEntriesInCache() ? 79 : 97);
        long $managedLedgerMaxReadsInFlightSize = this.getManagedLedgerMaxReadsInFlightSize();
        result = result * 59 + (int)($managedLedgerMaxReadsInFlightSize >>> 32 ^ $managedLedgerMaxReadsInFlightSize);
        result = result * 59 + (this.isTraceTaskExecution() ? 79 : 97);
        result = result * 59 + this.getPrometheusStatsLatencyRolloverSeconds();
        result = result * 59 + this.getCursorPositionFlushSeconds();
        result = result * 59 + this.getStatsPeriodSeconds();
        long $managedLedgerInfoCompressionThresholdInBytes = this.getManagedLedgerInfoCompressionThresholdInBytes();
        result = result * 59 + (int)($managedLedgerInfoCompressionThresholdInBytes >>> 32 ^ $managedLedgerInfoCompressionThresholdInBytes);
        long $managedCursorInfoCompressionThresholdInBytes = this.getManagedCursorInfoCompressionThresholdInBytes();
        result = result * 59 + (int)($managedCursorInfoCompressionThresholdInBytes >>> 32 ^ $managedCursorInfoCompressionThresholdInBytes);
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $managedLedgerInfoCompressionType = this.getManagedLedgerInfoCompressionType();
        result = result * 59 + ($managedLedgerInfoCompressionType == null ? 43 : $managedLedgerInfoCompressionType.hashCode());
        String $managedCursorInfoCompressionType = this.getManagedCursorInfoCompressionType();
        result = result * 59 + ($managedCursorInfoCompressionType == null ? 43 : $managedCursorInfoCompressionType.hashCode());
        return result;
    }

    public String toString() {
        return "ManagedLedgerFactoryConfig(maxCacheSize=" + this.getMaxCacheSize() + ", cacheEvictionWatermark=" + this.getCacheEvictionWatermark() + ", numManagedLedgerSchedulerThreads=" + this.getNumManagedLedgerSchedulerThreads() + ", cacheEvictionIntervalMs=" + this.getCacheEvictionIntervalMs() + ", cacheEvictionTimeThresholdMillis=" + this.getCacheEvictionTimeThresholdMillis() + ", copyEntriesInCache=" + this.isCopyEntriesInCache() + ", managedLedgerMaxReadsInFlightSize=" + this.getManagedLedgerMaxReadsInFlightSize() + ", traceTaskExecution=" + this.isTraceTaskExecution() + ", prometheusStatsLatencyRolloverSeconds=" + this.getPrometheusStatsLatencyRolloverSeconds() + ", cursorPositionFlushSeconds=" + this.getCursorPositionFlushSeconds() + ", statsPeriodSeconds=" + this.getStatsPeriodSeconds() + ", clusterName=" + this.getClusterName() + ", managedLedgerInfoCompressionType=" + this.getManagedLedgerInfoCompressionType() + ", managedLedgerInfoCompressionThresholdInBytes=" + this.getManagedLedgerInfoCompressionThresholdInBytes() + ", managedCursorInfoCompressionType=" + this.getManagedCursorInfoCompressionType() + ", managedCursorInfoCompressionThresholdInBytes=" + this.getManagedCursorInfoCompressionThresholdInBytes() + ")";
    }
}

