/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl.cache;

import com.google.common.annotations.VisibleForTesting;
import io.prometheus.client.Gauge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InflightReadsLimiter {
    private static final Logger log = LoggerFactory.getLogger(InflightReadsLimiter.class);
    private static final Gauge PULSAR_ML_READS_BUFFER_SIZE = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_ml_reads_inflight_bytes")).help("Estimated number of bytes retained by data read from storage or cache")).register();
    private static final Gauge PULSAR_ML_READS_AVAILABLE_BUFFER_SIZE = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_ml_reads_available_inflight_bytes")).help("Available space for inflight data read from storage or cache")).register();
    private final long maxReadsInFlightSize;
    private long remainingBytes;
    private static final Handle DISABLED = new Handle(0L, true, 0, -1L);

    public InflightReadsLimiter(long maxReadsInFlightSize) {
        if (maxReadsInFlightSize <= 0L) {
            PULSAR_ML_READS_BUFFER_SIZE.set(-1.0);
            PULSAR_ML_READS_AVAILABLE_BUFFER_SIZE.set(-1.0);
        }
        this.maxReadsInFlightSize = maxReadsInFlightSize;
        this.remainingBytes = maxReadsInFlightSize;
    }

    @VisibleForTesting
    public synchronized long getRemainingBytes() {
        return this.remainingBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Handle acquire(long permits, Handle current) {
        if (this.maxReadsInFlightSize <= 0L) {
            return DISABLED;
        }
        InflightReadsLimiter inflightReadsLimiter = this;
        synchronized (inflightReadsLimiter) {
            try {
                if (current == null) {
                    if (this.remainingBytes == 0L) {
                        Handle handle = new Handle(0L, false, 1, System.currentTimeMillis());
                        return handle;
                    }
                    if (this.remainingBytes >= permits) {
                        this.remainingBytes -= permits;
                        Handle handle = new Handle(permits, true, 1, System.currentTimeMillis());
                        return handle;
                    }
                    long possible = this.remainingBytes;
                    this.remainingBytes = 0L;
                    Handle handle = new Handle(possible, false, 1, System.currentTimeMillis());
                    return handle;
                }
                if (current.trials >= 4 && current.acquiredPermits > 0L) {
                    this.remainingBytes += current.acquiredPermits;
                    Handle possible = new Handle(0L, false, 1, current.creationTime);
                    return possible;
                }
                if (this.remainingBytes == 0L) {
                    Handle possible = new Handle(current.acquiredPermits, false, current.trials + 1, current.creationTime);
                    return possible;
                }
                long needed = permits - current.acquiredPermits;
                if (this.remainingBytes >= needed) {
                    this.remainingBytes -= needed;
                    Handle handle = new Handle(permits, true, current.trials + 1, current.creationTime);
                    return handle;
                }
                long possible = this.remainingBytes;
                this.remainingBytes = 0L;
                Handle handle = new Handle(current.acquiredPermits + possible, false, current.trials + 1, current.creationTime);
                return handle;
            }
            finally {
                this.updateMetrics();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(Handle handle) {
        if (handle == DISABLED) {
            return;
        }
        InflightReadsLimiter inflightReadsLimiter = this;
        synchronized (inflightReadsLimiter) {
            this.remainingBytes += handle.acquiredPermits;
            this.updateMetrics();
        }
    }

    private synchronized void updateMetrics() {
        PULSAR_ML_READS_BUFFER_SIZE.set((double)(this.maxReadsInFlightSize - this.remainingBytes));
        PULSAR_ML_READS_AVAILABLE_BUFFER_SIZE.set((double)this.remainingBytes);
    }

    public boolean isDisabled() {
        return this.maxReadsInFlightSize <= 0L;
    }

    static class Handle {
        final long acquiredPermits;
        final boolean success;
        final int trials;
        final long creationTime;

        public Handle(long acquiredPermits, boolean success, int trials, long creationTime) {
            this.acquiredPermits = acquiredPermits;
            this.success = success;
            this.trials = trials;
            this.creationTime = creationTime;
        }

        public String toString() {
            return "InflightReadsLimiter.Handle(acquiredPermits=" + this.acquiredPermits + ", success=" + this.success + ", trials=" + this.trials + ", creationTime=" + this.creationTime + ")";
        }
    }
}

