/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.util;

import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.common.util.collections.BitSetRecyclable;

public class PositionAckSetUtil {
    public static boolean isAckSetOverlap(long[] currentAckSet, long[] otherAckSet) {
        if (currentAckSet == null || otherAckSet == null) {
            return false;
        }
        BitSetRecyclable currentBitSet = BitSetRecyclable.valueOf((long[])currentAckSet);
        BitSetRecyclable otherBitSet = BitSetRecyclable.valueOf((long[])otherAckSet);
        currentBitSet.flip(0, currentBitSet.size());
        otherBitSet.flip(0, otherBitSet.size());
        currentBitSet.and(otherBitSet);
        boolean isAckSetRepeated = !currentBitSet.isEmpty();
        currentBitSet.recycle();
        otherBitSet.recycle();
        return isAckSetRepeated;
    }

    public static void andAckSet(PositionImpl currentPosition, PositionImpl otherPosition) {
        if (currentPosition == null || otherPosition == null) {
            return;
        }
        currentPosition.setAckSet(PositionAckSetUtil.andAckSet(currentPosition.getAckSet(), otherPosition.getAckSet()));
    }

    public static long[] andAckSet(long[] firstAckSet, long[] secondAckSet) {
        BitSetRecyclable thisAckSet = BitSetRecyclable.valueOf((long[])firstAckSet);
        BitSetRecyclable otherAckSet = BitSetRecyclable.valueOf((long[])secondAckSet);
        thisAckSet.and(otherAckSet);
        long[] ackSet = thisAckSet.toLongArray();
        thisAckSet.recycle();
        otherAckSet.recycle();
        return ackSet;
    }

    public static boolean isAckSetEmpty(long[] ackSet) {
        BitSetRecyclable bitSet = BitSetRecyclable.create().resetWords(ackSet);
        boolean isEmpty = bitSet.isEmpty();
        bitSet.recycle();
        return isEmpty;
    }

    public static int compareToWithAckSet(PositionImpl currentPosition, PositionImpl otherPosition) {
        if (currentPosition == null || otherPosition == null) {
            throw new IllegalArgumentException("Two positions can't be null! current position : [" + currentPosition + "] other position : [" + otherPosition + "]");
        }
        int result = currentPosition.compareTo(otherPosition);
        if (result == 0) {
            BitSetRecyclable otherAckSet = otherPosition.getAckSet() == null ? BitSetRecyclable.create() : BitSetRecyclable.valueOf((long[])otherPosition.getAckSet());
            BitSetRecyclable currentAckSet = currentPosition.getAckSet() == null ? BitSetRecyclable.create() : BitSetRecyclable.valueOf((long[])currentPosition.getAckSet());
            result = currentAckSet.isEmpty() || otherAckSet.isEmpty() ? -(currentAckSet.nextSetBit(0) - otherAckSet.nextSetBit(0)) : currentAckSet.nextSetBit(0) - otherAckSet.nextSetBit(0);
            currentAckSet.recycle();
            otherAckSet.recycle();
        }
        return result;
    }
}

