/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import org.apache.pulsar.broker.ShutdownService;
import org.apache.pulsar.functions.worker.ErrorNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorNotifierShutdownServiceImpl
implements ErrorNotifier {
    private static final Logger log = LoggerFactory.getLogger(ErrorNotifierShutdownServiceImpl.class);
    private static final long serialVersionUID = 1L;
    private final ShutdownService shutdownService;

    public ErrorNotifierShutdownServiceImpl(ShutdownService shutdownService) {
        this.shutdownService = shutdownService;
    }

    @Override
    public void triggerError(Throwable th) {
        log.error("Encountered fatal error. Shutting down.", th);
        this.shutdownService.shutdownNow();
    }

    @Override
    public void waitForError() throws Exception {
        throw new IllegalArgumentException("Invalid operation for implementation");
    }

    @Override
    public void close() {
    }
}

