/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.api.examples;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.EncryptionKeyInfo;

public class RawFileKeyReader
implements CryptoKeyReader {
    private final String publicKeyFile;
    private final String privateKeyFile;

    public RawFileKeyReader(String pubKeyFile, String privKeyFile) {
        this.publicKeyFile = pubKeyFile;
        this.privateKeyFile = privKeyFile;
    }

    public RawFileKeyReader(Map<String, Object> conf) {
        this.publicKeyFile = (String)conf.get("PUBLIC");
        this.privateKeyFile = (String)conf.get("PRIVATE");
    }

    public EncryptionKeyInfo getPublicKey(String keyName, Map<String, String> keyMeta) {
        EncryptionKeyInfo keyInfo = new EncryptionKeyInfo();
        try {
            keyInfo.setKey(Files.readAllBytes(Paths.get(this.publicKeyFile, new String[0])));
        }
        catch (IOException e) {
            System.out.println("ERROR: Failed to read public key from file " + this.publicKeyFile);
            e.printStackTrace();
        }
        return keyInfo;
    }

    public EncryptionKeyInfo getPrivateKey(String keyName, Map<String, String> keyMeta) {
        EncryptionKeyInfo keyInfo = new EncryptionKeyInfo();
        try {
            keyInfo.setKey(Files.readAllBytes(Paths.get(this.privateKeyFile, new String[0])));
        }
        catch (IOException e) {
            System.out.println("ERROR: Failed to read private key from file " + this.privateKeyFile);
            e.printStackTrace();
        }
        return keyInfo;
    }

    public String getPublicKeyFile() {
        return this.publicKeyFile;
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawFileKeyReader)) {
            return false;
        }
        RawFileKeyReader other = (RawFileKeyReader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$publicKeyFile = this.getPublicKeyFile();
        String other$publicKeyFile = other.getPublicKeyFile();
        if (this$publicKeyFile == null ? other$publicKeyFile != null : !this$publicKeyFile.equals(other$publicKeyFile)) {
            return false;
        }
        String this$privateKeyFile = this.getPrivateKeyFile();
        String other$privateKeyFile = other.getPrivateKeyFile();
        return !(this$privateKeyFile == null ? other$privateKeyFile != null : !this$privateKeyFile.equals(other$privateKeyFile));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawFileKeyReader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $publicKeyFile = this.getPublicKeyFile();
        result = result * 59 + ($publicKeyFile == null ? 43 : $publicKeyFile.hashCode());
        String $privateKeyFile = this.getPrivateKeyFile();
        result = result * 59 + ($privateKeyFile == null ? 43 : $privateKeyFile.hashCode());
        return result;
    }

    public String toString() {
        return "RawFileKeyReader(publicKeyFile=" + this.getPublicKeyFile() + ", privateKeyFile=" + this.getPrivateKeyFile() + ")";
    }
}

