/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resourcegroup;

import com.google.common.annotations.VisibleForTesting;
import io.prometheus.client.Counter;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.pulsar.broker.resourcegroup.ResourceGroupPublishLimiter;
import org.apache.pulsar.broker.resourcegroup.ResourceGroupService;
import org.apache.pulsar.broker.resourcegroup.ResourceUsageConsumer;
import org.apache.pulsar.broker.resourcegroup.ResourceUsagePublisher;
import org.apache.pulsar.broker.resourcegroup.ResourceUsageTransportManager;
import org.apache.pulsar.broker.service.resource.usage.NetworkUsage;
import org.apache.pulsar.broker.service.resource.usage.ResourceUsage;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceGroup {
    public final String resourceGroupName;
    public PerMonitoringClassFields[] monitoringClassFields = new PerMonitoringClassFields[ResourceGroupMonitoringClass.values().length];
    private static final Logger log = LoggerFactory.getLogger(ResourceGroupService.class);
    private Set<String> resourceGroupTenantRefs = ConcurrentHashMap.newKeySet();
    private Set<String> resourceGroupNamespaceRefs = ConcurrentHashMap.newKeySet();
    ResourceUsageConsumer ruConsumer;
    ResourceUsagePublisher ruPublisher;
    ResourceGroupService rgs;
    private static final String[] resourceGroupMontoringclassLabels = new String[]{"ResourceGroup", "MonitoringClass"};
    private static final String[] resourceGroupMontoringclassRemotebrokerLabels = new String[]{"ResourceGroup", "MonitoringClass", "RemoteBroker"};
    private static final Counter rgRemoteUsageReportsBytes = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_resource_group_remote_usage_bytes_used")).help("Bytes used reported about this <RG, monitoring class> from a remote broker")).labelNames(resourceGroupMontoringclassRemotebrokerLabels)).register();
    private static final Counter rgRemoteUsageReportsMessages = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_resource_group_remote_usage_messages_used")).help("Messages used reported about this <RG, monitoring class> from a remote broker")).labelNames(resourceGroupMontoringclassRemotebrokerLabels)).register();
    private static final Counter rgLocalUsageReportCount = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_resource_group_local_usage_reported")).help("Number of times local usage was reported (vs. suppressed due to negligible change)")).labelNames(resourceGroupMontoringclassLabels)).register();
    protected ResourceGroupPublishLimiter resourceGroupPublishLimiter;

    protected ResourceGroup(ResourceGroupService rgs, String name, org.apache.pulsar.common.policies.data.ResourceGroup rgConfig) {
        this.rgs = rgs;
        this.resourceGroupName = name;
        this.setResourceGroupMonitoringClassFields();
        this.setResourceGroupConfigParameters(rgConfig);
        this.setDefaultResourceUsageTransportHandlers();
        this.resourceGroupPublishLimiter = new ResourceGroupPublishLimiter(rgConfig, rgs.getPulsar().getMonotonicSnapshotClock());
        log.info("attaching publish rate limiter {} to {} get {}", new Object[]{this.resourceGroupPublishLimiter, name, this.getResourceGroupPublishLimiter()});
    }

    protected ResourceGroup(ResourceGroupService rgs, String rgName, org.apache.pulsar.common.policies.data.ResourceGroup rgConfig, ResourceUsagePublisher rgPublisher, ResourceUsageConsumer rgConsumer) {
        this.rgs = rgs;
        this.resourceGroupName = rgName;
        this.setResourceGroupMonitoringClassFields();
        this.setResourceGroupConfigParameters(rgConfig);
        this.resourceGroupPublishLimiter = new ResourceGroupPublishLimiter(rgConfig, rgs.getPulsar().getMonotonicSnapshotClock());
        this.ruPublisher = rgPublisher;
        this.ruConsumer = rgConsumer;
    }

    public ResourceGroup(ResourceGroup other) {
        this.resourceGroupName = other.resourceGroupName;
        this.rgs = other.rgs;
        this.resourceGroupPublishLimiter = other.resourceGroupPublishLimiter;
        this.setResourceGroupMonitoringClassFields();
        this.resourceGroupNamespaceRefs = other.resourceGroupNamespaceRefs;
        this.resourceGroupTenantRefs = other.resourceGroupTenantRefs;
        for (int idx = 0; idx < ResourceGroupMonitoringClass.values().length; ++idx) {
            PerMonitoringClassFields thisFields = this.monitoringClassFields[idx];
            PerMonitoringClassFields otherFields = other.monitoringClassFields[idx];
            thisFields.configValuesPerPeriod.bytes = otherFields.configValuesPerPeriod.bytes;
            thisFields.configValuesPerPeriod.messages = otherFields.configValuesPerPeriod.messages;
            thisFields.quotaForNextPeriod.bytes = otherFields.quotaForNextPeriod.bytes;
            thisFields.quotaForNextPeriod.messages = otherFields.quotaForNextPeriod.messages;
            thisFields.usedLocallySinceLastReport.bytes = otherFields.usedLocallySinceLastReport.bytes;
            thisFields.usedLocallySinceLastReport.messages = otherFields.usedLocallySinceLastReport.messages;
            thisFields.lastResourceUsageFillTimeMSecsSinceEpoch = otherFields.lastResourceUsageFillTimeMSecsSinceEpoch;
            thisFields.numSuppressedUsageReports = otherFields.numSuppressedUsageReports;
            thisFields.totalUsedLocally.bytes = otherFields.totalUsedLocally.bytes;
            thisFields.totalUsedLocally.messages = otherFields.totalUsedLocally.messages;
            thisFields.usageFromOtherBrokers = otherFields.usageFromOtherBrokers;
        }
    }

    protected void updateResourceGroup(org.apache.pulsar.common.policies.data.ResourceGroup rgConfig) {
        this.setResourceGroupConfigParameters(rgConfig);
        BytesAndMessagesCount pubBmc = new BytesAndMessagesCount();
        pubBmc.messages = rgConfig.getPublishRateInMsgs().intValue();
        pubBmc.bytes = rgConfig.getPublishRateInBytes();
        this.resourceGroupPublishLimiter.update(pubBmc);
    }

    protected long getResourceGroupNumOfNSRefs() {
        return this.resourceGroupNamespaceRefs.size();
    }

    protected long getResourceGroupNumOfTenantRefs() {
        return this.resourceGroupTenantRefs.size();
    }

    protected ResourceGroupService.ResourceGroupOpStatus registerUsage(String name, ResourceGroupRefTypes refType, boolean ref, ResourceUsageTransportManager transportManager) {
        Set<String> set;
        switch (refType) {
            default: {
                return ResourceGroupService.ResourceGroupOpStatus.NotSupported;
            }
            case Tenants: {
                set = this.resourceGroupTenantRefs;
                break;
            }
            case Namespaces: {
                set = this.resourceGroupNamespaceRefs;
            }
        }
        if (ref) {
            if (set.contains(name)) {
                return ResourceGroupService.ResourceGroupOpStatus.Exists;
            }
            set.add(name);
            if (this.resourceGroupTenantRefs.size() + this.resourceGroupNamespaceRefs.size() == 1) {
                if (log.isDebugEnabled()) {
                    log.debug("registerUsage for RG={}: registering with transport-mgr", (Object)this.resourceGroupName);
                }
                transportManager.registerResourceUsagePublisher(this.ruPublisher);
                transportManager.registerResourceUsageConsumer(this.ruConsumer);
            }
        } else {
            if (!set.contains(name)) {
                return ResourceGroupService.ResourceGroupOpStatus.DoesNotExist;
            }
            set.remove(name);
            if (this.resourceGroupTenantRefs.size() + this.resourceGroupNamespaceRefs.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("unRegisterUsage for RG={}: un-registering from transport-mgr", (Object)this.resourceGroupName);
                }
                transportManager.unregisterResourceUsageConsumer(this.ruConsumer);
                transportManager.unregisterResourceUsagePublisher(this.ruPublisher);
            }
        }
        return ResourceGroupService.ResourceGroupOpStatus.OK;
    }

    public String getID() {
        return this.resourceGroupName;
    }

    public void rgFillResourceUsage(ResourceUsage resourceUsage) {
        resourceUsage.setOwner(this.getID());
        NetworkUsage p = resourceUsage.setPublish();
        if (!this.setUsageInMonitoredEntity(ResourceGroupMonitoringClass.Publish, p)) {
            resourceUsage.clearPublish();
        }
        if (!this.setUsageInMonitoredEntity(ResourceGroupMonitoringClass.Dispatch, p = resourceUsage.setDispatch())) {
            resourceUsage.clearDispatch();
        }
    }

    public void rgResourceUsageListener(String broker, ResourceUsage resourceUsage) {
        if (resourceUsage.hasPublish()) {
            this.getUsageFromMonitoredEntity(ResourceGroupMonitoringClass.Publish, resourceUsage.getPublish(), broker);
        }
        if (resourceUsage.hasDispatch()) {
            this.getUsageFromMonitoredEntity(ResourceGroupMonitoringClass.Dispatch, resourceUsage.getDispatch(), broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BytesAndMessagesCount getConfLimits(ResourceGroupMonitoringClass monClass) throws PulsarAdminException {
        this.checkMonitoringClass(monClass);
        BytesAndMessagesCount retval = new BytesAndMessagesCount();
        PerMonitoringClassFields monEntity = this.monitoringClassFields[monClass.ordinal()];
        monEntity.localUsageStatsLock.lock();
        try {
            retval.bytes = monEntity.configValuesPerPeriod.bytes;
            retval.messages = monEntity.configValuesPerPeriod.messages;
        }
        finally {
            monEntity.localUsageStatsLock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementLocalUsageStats(ResourceGroupMonitoringClass monClass, BytesAndMessagesCount stats) throws PulsarAdminException {
        this.checkMonitoringClass(monClass);
        PerMonitoringClassFields monEntity = this.monitoringClassFields[monClass.ordinal()];
        monEntity.localUsageStatsLock.lock();
        try {
            monEntity.usedLocallySinceLastReport.bytes += stats.bytes;
            monEntity.usedLocallySinceLastReport.messages += stats.messages;
        }
        finally {
            monEntity.localUsageStatsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BytesAndMessagesCount getLocalUsageStats(ResourceGroupMonitoringClass monClass) throws PulsarAdminException {
        this.checkMonitoringClass(monClass);
        BytesAndMessagesCount retval = new BytesAndMessagesCount();
        PerMonitoringClassFields monEntity = this.monitoringClassFields[monClass.ordinal()];
        monEntity.localUsageStatsLock.lock();
        try {
            retval.bytes = monEntity.usedLocallySinceLastReport.bytes;
            retval.messages = monEntity.usedLocallySinceLastReport.messages;
        }
        finally {
            monEntity.localUsageStatsLock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BytesAndMessagesCount getLocalUsageStatsCumulative(ResourceGroupMonitoringClass monClass) throws PulsarAdminException {
        this.checkMonitoringClass(monClass);
        BytesAndMessagesCount retval = new BytesAndMessagesCount();
        PerMonitoringClassFields monEntity = this.monitoringClassFields[monClass.ordinal()];
        monEntity.localUsageStatsLock.lock();
        try {
            if (monEntity.totalUsedLocally.messages == 0L) {
                retval.bytes = monEntity.usedLocallySinceLastReport.bytes;
                retval.messages = monEntity.usedLocallySinceLastReport.messages;
            } else {
                retval.bytes = monEntity.totalUsedLocally.bytes;
                retval.messages = monEntity.totalUsedLocally.messages;
            }
        }
        finally {
            monEntity.localUsageStatsLock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BytesAndMessagesCount getLocalUsageStatsFromBrokerReports(ResourceGroupMonitoringClass monClass) throws PulsarAdminException {
        PerBrokerUsageStats pbus;
        this.checkMonitoringClass(monClass);
        BytesAndMessagesCount retval = new BytesAndMessagesCount();
        PerMonitoringClassFields monEntity = this.monitoringClassFields[monClass.ordinal()];
        String myBrokerId = this.rgs.getPulsar().getBrokerServiceUrl();
        monEntity.usageFromOtherBrokersLock.lock();
        try {
            pbus = monEntity.usageFromOtherBrokers.get(myBrokerId);
        }
        finally {
            monEntity.usageFromOtherBrokersLock.unlock();
        }
        if (pbus != null) {
            retval.bytes = pbus.usedValues.bytes;
            retval.messages = pbus.usedValues.messages;
        } else {
            log.info("getLocalUsageStatsFromBrokerReports: no usage report found for broker={} and monClass={}", (Object)myBrokerId, (Object)monClass);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BytesAndMessagesCount getGlobalUsageStats(ResourceGroupMonitoringClass monClass) throws PulsarAdminException {
        this.checkMonitoringClass(monClass);
        PerMonitoringClassFields monEntity = this.monitoringClassFields[monClass.ordinal()];
        monEntity.usageFromOtherBrokersLock.lock();
        BytesAndMessagesCount retStats = new BytesAndMessagesCount();
        try {
            monEntity.usageFromOtherBrokers.forEach((broker, brokerUsage) -> {
                retStats.bytes += brokerUsage.usedValues.bytes;
                retStats.messages += brokerUsage.usedValues.messages;
            });
        }
        finally {
            monEntity.usageFromOtherBrokersLock.unlock();
        }
        return retStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BytesAndMessagesCount updateLocalQuota(ResourceGroupMonitoringClass monClass, BytesAndMessagesCount newQuota) throws PulsarAdminException {
        if (!ResourceGroupMonitoringClass.Publish.equals((Object)monClass)) {
            if (log.isDebugEnabled()) {
                log.debug("Doing nothing for monClass={}; only Publish is functional", (Object)monClass);
            }
            return null;
        }
        this.checkMonitoringClass(monClass);
        PerMonitoringClassFields monEntity = this.monitoringClassFields[monClass.ordinal()];
        monEntity.localUsageStatsLock.lock();
        BytesAndMessagesCount oldBMCount = monEntity.quotaForNextPeriod;
        try {
            monEntity.quotaForNextPeriod = newQuota;
            this.resourceGroupPublishLimiter.update(newQuota);
        }
        finally {
            monEntity.localUsageStatsLock.unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("updateLocalQuota for RG={}: set local {} quota to bytes={}, messages={}", new Object[]{this.resourceGroupName, monClass, newQuota.bytes, newQuota.messages});
        }
        return oldBMCount;
    }

    protected BytesAndMessagesCount getRgPublishRateLimiterValues() {
        BytesAndMessagesCount retVal;
        PerMonitoringClassFields monEntity = this.monitoringClassFields[ResourceGroupMonitoringClass.Publish.ordinal()];
        monEntity.localUsageStatsLock.lock();
        try {
            retVal = this.resourceGroupPublishLimiter.getResourceGroupPublishValues();
        }
        finally {
            monEntity.localUsageStatsLock.unlock();
        }
        return retVal;
    }

    protected static double getRgRemoteUsageByteCount(String rgName, String monClassName, String brokerName) {
        return ((Counter.Child)rgRemoteUsageReportsBytes.labels(new String[]{rgName, monClassName, brokerName})).get();
    }

    protected static double getRgRemoteUsageMessageCount(String rgName, String monClassName, String brokerName) {
        return ((Counter.Child)rgRemoteUsageReportsMessages.labels(new String[]{rgName, monClassName, brokerName})).get();
    }

    protected static double getRgUsageReportedCount(String rgName, String monClassName) {
        return ((Counter.Child)rgLocalUsageReportCount.labels(new String[]{rgName, monClassName})).get();
    }

    protected static BytesAndMessagesCount accumulateBMCount(BytesAndMessagesCount ... bmCounts) {
        BytesAndMessagesCount retBMCount = new BytesAndMessagesCount();
        for (int ix = 0; ix < bmCounts.length; ++ix) {
            retBMCount.messages += bmCounts[ix].messages;
            retBMCount.bytes += bmCounts[ix].bytes;
        }
        return retBMCount;
    }

    private void checkMonitoringClass(ResourceGroupMonitoringClass monClass) throws PulsarAdminException {
        if (monClass != ResourceGroupMonitoringClass.Publish && monClass != ResourceGroupMonitoringClass.Dispatch) {
            String errMesg = "Unexpected monitoring class: " + monClass;
            throw new PulsarAdminException(errMesg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setUsageInMonitoredEntity(ResourceGroupMonitoringClass monClass, NetworkUsage p) {
        long messagesUsed;
        long bytesUsed;
        boolean sendReport;
        int numSuppressions = 0;
        int idx = monClass.ordinal();
        PerMonitoringClassFields monEntity = this.monitoringClassFields[idx];
        monEntity.localUsageStatsLock.lock();
        try {
            sendReport = this.rgs.quotaCalculator.needToReportLocalUsage(monEntity.usedLocallySinceLastReport.bytes, monEntity.lastReportedValues.bytes, monEntity.usedLocallySinceLastReport.messages, monEntity.lastReportedValues.messages, monEntity.lastResourceUsageFillTimeMSecsSinceEpoch);
            bytesUsed = monEntity.usedLocallySinceLastReport.bytes;
            messagesUsed = monEntity.usedLocallySinceLastReport.messages;
            monEntity.usedLocallySinceLastReport.messages = 0L;
            monEntity.usedLocallySinceLastReport.bytes = 0L;
            if (sendReport) {
                p.setBytesPerPeriod(bytesUsed);
                p.setMessagesPerPeriod(messagesUsed);
                monEntity.lastReportedValues.bytes = bytesUsed;
                monEntity.lastReportedValues.messages = messagesUsed;
                monEntity.numSuppressedUsageReports = 0;
                monEntity.totalUsedLocally.bytes += bytesUsed;
                monEntity.totalUsedLocally.messages += messagesUsed;
                monEntity.lastResourceUsageFillTimeMSecsSinceEpoch = System.currentTimeMillis();
            } else {
                numSuppressions = monEntity.numSuppressedUsageReports++;
            }
        }
        finally {
            monEntity.localUsageStatsLock.unlock();
        }
        String rgName = this.ruPublisher != null ? this.ruPublisher.getID() : this.resourceGroupName;
        double sentCount = sendReport ? 1.0 : 0.0;
        ((Counter.Child)rgLocalUsageReportCount.labels(new String[]{rgName, monClass.name()})).inc(sentCount);
        if (sendReport) {
            if (log.isDebugEnabled()) {
                log.debug("fillResourceUsage for RG={}: filled a {} update; bytes={}, messages={}", new Object[]{rgName, monClass, bytesUsed, messagesUsed});
            }
        } else if (log.isDebugEnabled()) {
            log.debug("fillResourceUsage for RG={}: report for {} suppressed (suppressions={} since last sent report)", new Object[]{rgName, monClass, numSuppressions});
        }
        return sendReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getUsageFromMonitoredEntity(ResourceGroupMonitoringClass monClass, NetworkUsage p, String broker) {
        PerBrokerUsageStats oldUsageStats;
        long newMessageCount;
        long newByteCount;
        int idx = monClass.ordinal();
        PerMonitoringClassFields monEntity = this.monitoringClassFields[idx];
        PerBrokerUsageStats usageStats = monEntity.usageFromOtherBrokers.get(broker);
        if (usageStats == null) {
            usageStats = new PerBrokerUsageStats();
            usageStats.usedValues = new BytesAndMessagesCount();
        }
        monEntity.usageFromOtherBrokersLock.lock();
        try {
            usageStats.usedValues.bytes = newByteCount = p.getBytesPerPeriod();
            usageStats.usedValues.messages = newMessageCount = p.getMessagesPerPeriod();
            usageStats.lastResourceUsageReadTimeMSecsSinceEpoch = System.currentTimeMillis();
            oldUsageStats = monEntity.usageFromOtherBrokers.put(broker, usageStats);
        }
        finally {
            monEntity.usageFromOtherBrokersLock.unlock();
        }
        ((Counter.Child)rgRemoteUsageReportsBytes.labels(new String[]{this.ruConsumer.getID(), monClass.name(), broker})).inc((double)newByteCount);
        ((Counter.Child)rgRemoteUsageReportsMessages.labels(new String[]{this.ruConsumer.getID(), monClass.name(), broker})).inc((double)newMessageCount);
        long oldMessageCount = -1L;
        long oldByteCount = -1L;
        if (oldUsageStats != null) {
            oldByteCount = oldUsageStats.usedValues.bytes;
            oldMessageCount = oldUsageStats.usedValues.messages;
        }
        if (log.isDebugEnabled()) {
            log.debug("resourceUsageListener for RG={}: updated {} stats for broker={} with bytes={} (old ={}), messages={} (old={})", new Object[]{this.resourceGroupName, monClass, broker, newByteCount, oldByteCount, newMessageCount, oldMessageCount});
        }
    }

    private void setResourceGroupMonitoringClassFields() {
        for (int idx = 0; idx < ResourceGroupMonitoringClass.values().length; ++idx) {
            this.monitoringClassFields[idx] = new PerMonitoringClassFields();
            PerMonitoringClassFields monClassFields = this.monitoringClassFields[idx];
            monClassFields.configValuesPerPeriod = new BytesAndMessagesCount();
            monClassFields.usedLocallySinceLastReport = new BytesAndMessagesCount();
            monClassFields.lastReportedValues = new BytesAndMessagesCount();
            monClassFields.quotaForNextPeriod = new BytesAndMessagesCount();
            monClassFields.totalUsedLocally = new BytesAndMessagesCount();
            monClassFields.usageFromOtherBrokers = new HashMap();
            monClassFields.usageFromOtherBrokersLock = new ReentrantLock();
            monClassFields.localUsageStatsLock = new ReentrantLock();
        }
    }

    private void setResourceGroupConfigParameters(org.apache.pulsar.common.policies.data.ResourceGroup rgConfig) {
        int idx = ResourceGroupMonitoringClass.Publish.ordinal();
        this.monitoringClassFields[idx].configValuesPerPeriod.bytes = rgConfig.getPublishRateInBytes() == null ? -1L : rgConfig.getPublishRateInBytes();
        this.monitoringClassFields[idx].configValuesPerPeriod.messages = rgConfig.getPublishRateInMsgs() == null ? -1L : (long)rgConfig.getPublishRateInMsgs().intValue();
        idx = ResourceGroupMonitoringClass.Dispatch.ordinal();
        this.monitoringClassFields[idx].configValuesPerPeriod.bytes = rgConfig.getDispatchRateInBytes() == null ? -1L : rgConfig.getDispatchRateInBytes();
        this.monitoringClassFields[idx].configValuesPerPeriod.messages = rgConfig.getDispatchRateInMsgs() == null ? -1L : (long)rgConfig.getDispatchRateInMsgs().intValue();
    }

    private void setDefaultResourceUsageTransportHandlers() {
        this.ruPublisher = new ResourceUsagePublisher(){

            @Override
            public String getID() {
                return ResourceGroup.this.getID();
            }

            @Override
            public void fillResourceUsage(ResourceUsage resourceUsage) {
                ResourceGroup.this.rgFillResourceUsage(resourceUsage);
            }
        };
        this.ruConsumer = new ResourceUsageConsumer(){

            @Override
            public String getID() {
                return ResourceGroup.this.getID();
            }

            @Override
            public void acceptResourceUsage(String broker, ResourceUsage resourceUsage) {
                ResourceGroup.this.rgResourceUsageListener(broker, resourceUsage);
            }
        };
    }

    @VisibleForTesting
    PerMonitoringClassFields getMonitoredEntity(ResourceGroupMonitoringClass monClass) {
        return this.monitoringClassFields[monClass.ordinal()];
    }

    public ResourceGroupPublishLimiter getResourceGroupPublishLimiter() {
        return this.resourceGroupPublishLimiter;
    }

    public static enum ResourceGroupMonitoringClass {
        Publish,
        Dispatch;

    }

    protected static class PerMonitoringClassFields {
        Lock localUsageStatsLock;
        BytesAndMessagesCount configValuesPerPeriod;
        BytesAndMessagesCount quotaForNextPeriod;
        BytesAndMessagesCount usedLocallySinceLastReport;
        BytesAndMessagesCount lastReportedValues;
        long lastResourceUsageFillTimeMSecsSinceEpoch;
        int numSuppressedUsageReports;
        BytesAndMessagesCount totalUsedLocally;
        Lock usageFromOtherBrokersLock;
        public HashMap<String, PerBrokerUsageStats> usageFromOtherBrokers;

        protected PerMonitoringClassFields() {
        }
    }

    public static class BytesAndMessagesCount {
        public long bytes;
        public long messages;
    }

    public static enum ResourceGroupRefTypes {
        Tenants,
        Namespaces;

    }

    protected static class PerBrokerUsageStats {
        public long lastResourceUsageReadTimeMSecsSinceEpoch;
        BytesAndMessagesCount usedValues;

        protected PerBrokerUsageStats() {
        }
    }
}

