/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.IOException;
import java.util.Map;
import org.apache.pulsar.common.util.SimpleTextOutputStream;
import org.apache.pulsar.functions.runtime.Runtime;
import org.apache.pulsar.functions.runtime.RuntimeSpawner;
import org.apache.pulsar.functions.runtime.kubernetes.KubernetesRuntimeFactory;
import org.apache.pulsar.functions.worker.FunctionRuntimeInfo;
import org.apache.pulsar.functions.worker.PulsarWorkerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsStatsGenerator {
    private static final Logger log = LoggerFactory.getLogger(FunctionsStatsGenerator.class);

    public static void generate(PulsarWorkerService workerService, SimpleTextOutputStream out) {
        if (workerService != null && workerService.isInitialized()) {
            try {
                out.write((CharSequence)workerService.getWorkerStatsManager().getStatsAsString());
            }
            catch (IOException e) {
                log.warn("Encountered error when generating metrics for worker {}", (Object)workerService.getWorkerConfig().getWorkerId(), (Object)e);
            }
            if (workerService.getFunctionRuntimeManager().getRuntimeFactory() instanceof KubernetesRuntimeFactory) {
                return;
            }
            Map<String, FunctionRuntimeInfo> functionRuntimes = workerService.getFunctionRuntimeManager().getFunctionRuntimeInfos();
            for (Map.Entry<String, FunctionRuntimeInfo> entry : functionRuntimes.entrySet()) {
                Runtime functionRuntime;
                String fullyQualifiedInstanceName = entry.getKey();
                FunctionRuntimeInfo functionRuntimeInfo = entry.getValue();
                RuntimeSpawner functionRuntimeSpawner = functionRuntimeInfo.getRuntimeSpawner();
                if (functionRuntimeSpawner == null || (functionRuntime = functionRuntimeSpawner.getRuntime()) == null) continue;
                try {
                    String prometheusMetrics = functionRuntime.getPrometheusMetrics();
                    if (prometheusMetrics == null) continue;
                    out.write((CharSequence)prometheusMetrics);
                }
                catch (IOException e) {
                    log.warn("Failed to collect metrics for function instance {}", (Object)fullyQualifiedInstanceName, (Object)e);
                }
            }
        }
    }
}

