/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.stats;

import io.opentelemetry.api.metrics.Meter;
import java.io.Closeable;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.opentelemetry.OpenTelemetryService;
import org.apache.pulsar.proxy.server.ProxyConfiguration;

public class PulsarProxyOpenTelemetry
implements Closeable {
    public static final String SERVICE_NAME = "pulsar-proxy";
    private final OpenTelemetryService openTelemetryService;
    private final Meter meter;

    public PulsarProxyOpenTelemetry(ProxyConfiguration config) {
        this.openTelemetryService = OpenTelemetryService.builder().clusterName(config.getClusterName()).serviceName(SERVICE_NAME).serviceVersion(PulsarVersion.getVersion()).build();
        this.meter = this.openTelemetryService.getOpenTelemetry().getMeter("org.apache.pulsar.proxy");
    }

    @Override
    public void close() {
        this.openTelemetryService.close();
    }

    public Meter getMeter() {
        return this.meter;
    }
}

