/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.proxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.asynchttpclient.Realm;
import org.asynchttpclient.proxy.ProxyType;
import org.asynchttpclient.util.Assertions;
import org.asynchttpclient.util.MiscUtils;

public class ProxyServer {
    private final String host;
    private final int port;
    private final int securedPort;
    private final Realm realm;
    private final List<String> nonProxyHosts;
    private final ProxyType proxyType;

    public ProxyServer(String host, int port, int securedPort, Realm realm, List<String> nonProxyHosts, ProxyType proxyType) {
        this.host = host;
        this.port = port;
        this.securedPort = securedPort;
        this.realm = realm;
        this.nonProxyHosts = nonProxyHosts;
        this.proxyType = proxyType;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getSecuredPort() {
        return this.securedPort;
    }

    public List<String> getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public boolean isIgnoredForHost(String hostname) {
        Assertions.assertNotNull(hostname, "hostname");
        if (MiscUtils.isNonEmpty(this.nonProxyHosts)) {
            for (String nonProxyHost : this.nonProxyHosts) {
                if (!this.matchNonProxyHost(hostname, nonProxyHost)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchNonProxyHost(String targetHost, String nonProxyHost) {
        if (nonProxyHost.length() > 1) {
            if (nonProxyHost.charAt(0) == '*') {
                return targetHost.regionMatches(true, targetHost.length() - nonProxyHost.length() + 1, nonProxyHost, 1, nonProxyHost.length() - 1);
            }
            if (nonProxyHost.charAt(nonProxyHost.length() - 1) == '*') {
                return targetHost.regionMatches(true, 0, nonProxyHost, 0, nonProxyHost.length() - 1);
            }
        }
        return nonProxyHost.equalsIgnoreCase(targetHost);
    }

    public static class Builder {
        private String host;
        private int port;
        private int securedPort;
        private Realm realm;
        private List<String> nonProxyHosts;
        private ProxyType proxyType;

        public Builder(String host, int port) {
            this.host = host;
            this.port = port;
            this.securedPort = port;
        }

        public Builder setSecuredPort(int securedPort) {
            this.securedPort = securedPort;
            return this;
        }

        public Builder setRealm(Realm realm) {
            this.realm = realm;
            return this;
        }

        public Builder setRealm(Realm.Builder realm) {
            this.realm = realm.build();
            return this;
        }

        public Builder setNonProxyHost(String nonProxyHost) {
            if (this.nonProxyHosts == null) {
                this.nonProxyHosts = new ArrayList<String>(1);
            }
            this.nonProxyHosts.add(nonProxyHost);
            return this;
        }

        public Builder setNonProxyHosts(List<String> nonProxyHosts) {
            this.nonProxyHosts = nonProxyHosts;
            return this;
        }

        public Builder setProxyType(ProxyType proxyType) {
            this.proxyType = proxyType;
            return this;
        }

        public ProxyServer build() {
            List<String> nonProxyHosts = this.nonProxyHosts != null ? Collections.unmodifiableList(this.nonProxyHosts) : Collections.emptyList();
            ProxyType proxyType = this.proxyType != null ? this.proxyType : ProxyType.HTTP;
            return new ProxyServer(this.host, this.port, this.securedPort, this.realm, nonProxyHosts, proxyType);
        }
    }
}

