/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client;

import io.grpc.internal.BackoffPolicy;
import io.grpc.netty.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import io.grpc.stub.StreamObserver;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.streamnative.oxia.client.ClientConfig;
import io.streamnative.oxia.client.CompareWithSlash;
import io.streamnative.oxia.client.OptionsUtils;
import io.streamnative.oxia.client.ProtoUtil;
import io.streamnative.oxia.client.api.AsyncOxiaClient;
import io.streamnative.oxia.client.api.DeleteOption;
import io.streamnative.oxia.client.api.DeleteRangeOption;
import io.streamnative.oxia.client.api.GetOption;
import io.streamnative.oxia.client.api.GetResult;
import io.streamnative.oxia.client.api.ListOption;
import io.streamnative.oxia.client.api.Notification;
import io.streamnative.oxia.client.api.PutOption;
import io.streamnative.oxia.client.api.PutResult;
import io.streamnative.oxia.client.api.RangeScanConsumer;
import io.streamnative.oxia.client.api.RangeScanOption;
import io.streamnative.oxia.client.batch.BatchManager;
import io.streamnative.oxia.client.batch.Operation;
import io.streamnative.oxia.client.grpc.OxiaBackoffProvider;
import io.streamnative.oxia.client.grpc.OxiaStub;
import io.streamnative.oxia.client.grpc.OxiaStubManager;
import io.streamnative.oxia.client.grpc.OxiaStubProvider;
import io.streamnative.oxia.client.metrics.Counter;
import io.streamnative.oxia.client.metrics.InstrumentProvider;
import io.streamnative.oxia.client.metrics.LatencyHistogram;
import io.streamnative.oxia.client.metrics.Unit;
import io.streamnative.oxia.client.metrics.UpDownCounter;
import io.streamnative.oxia.client.notify.NotificationManager;
import io.streamnative.oxia.client.session.SessionManager;
import io.streamnative.oxia.client.shard.ShardManager;
import io.streamnative.oxia.proto.KeyComparisonType;
import io.streamnative.oxia.proto.ListRequest;
import io.streamnative.oxia.proto.ListResponse;
import io.streamnative.oxia.proto.RangeScanRequest;
import io.streamnative.oxia.proto.RangeScanResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncOxiaClientImpl
implements AsyncOxiaClient {
    private static final Logger log = LoggerFactory.getLogger(AsyncOxiaClientImpl.class);
    @NonNull
    private final String clientIdentifier;
    @NonNull
    private final InstrumentProvider instrumentProvider;
    @NonNull
    private final OxiaStubManager stubManager;
    @NonNull
    private final ShardManager shardManager;
    @NonNull
    private final NotificationManager notificationManager;
    @NonNull
    private final BatchManager readBatchManager;
    @NonNull
    private final BatchManager writeBatchManager;
    @NonNull
    private final SessionManager sessionManager;
    private volatile boolean closed;
    private final Counter counterPutBytes;
    private final Counter counterGetBytes;
    private final Counter counterListBytes;
    private final Counter counterRangeScanBytes;
    private final UpDownCounter gaugePendingPutRequests;
    private final UpDownCounter gaugePendingGetRequests;
    private final UpDownCounter gaugePendingListRequests;
    private final UpDownCounter gaugePendingRangeScanRequests;
    private final UpDownCounter gaugePendingDeleteRequests;
    private final UpDownCounter gaugePendingDeleteRangeRequests;
    private final UpDownCounter gaugePendingPutBytes;
    private final LatencyHistogram histogramPutLatency;
    private final LatencyHistogram histogramGetLatency;
    private final LatencyHistogram histogramDeleteLatency;
    private final LatencyHistogram histogramDeleteRangeLatency;
    private final LatencyHistogram histogramListLatency;
    private final LatencyHistogram histogramRangeScanLatency;
    private final ScheduledExecutorService scheduledExecutor;

    @NonNull
    static CompletableFuture<AsyncOxiaClient> newInstance(@NonNull ClientConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("oxia-client"));
        BackoffPolicy.Provider oxiaBackoffProvider = OxiaBackoffProvider.create(config.connectionBackoffMinDelay(), config.connectionBackoffMaxDelay());
        OxiaStubManager stubManager = new OxiaStubManager(config.namespace(), config.authentication(), config.enableTls(), oxiaBackoffProvider);
        InstrumentProvider instrumentProvider = new InstrumentProvider(config.openTelemetry(), config.namespace());
        OxiaStub serviceAddrStub = stubManager.getStub(config.serviceAddress());
        ShardManager shardManager = new ShardManager(executor, serviceAddrStub, instrumentProvider, config.namespace());
        NotificationManager notificationManager = new NotificationManager(executor, stubManager, shardManager, instrumentProvider);
        OxiaStubProvider stubProvider = new OxiaStubProvider(stubManager, shardManager);
        shardManager.addCallback(notificationManager);
        BatchManager readBatchManager = BatchManager.newReadBatchManager(config, stubProvider, instrumentProvider);
        SessionManager sessionManager = new SessionManager(executor, config, stubProvider, instrumentProvider);
        shardManager.addCallback(sessionManager);
        BatchManager writeBatchManager = BatchManager.newWriteBatchManager(config, stubProvider, sessionManager, instrumentProvider);
        AsyncOxiaClientImpl client = new AsyncOxiaClientImpl(config.clientIdentifier(), executor, instrumentProvider, stubManager, shardManager, notificationManager, readBatchManager, writeBatchManager, sessionManager);
        return shardManager.start().thenApply(v -> client);
    }

    AsyncOxiaClientImpl(@NonNull String clientIdentifier, @NonNull ScheduledExecutorService scheduledExecutor, @NonNull InstrumentProvider instrumentProvider, @NonNull OxiaStubManager stubManager, @NonNull ShardManager shardManager, @NonNull NotificationManager notificationManager, @NonNull BatchManager readBatchManager, @NonNull BatchManager writeBatchManager, @NonNull SessionManager sessionManager) {
        if (clientIdentifier == null) {
            throw new NullPointerException("clientIdentifier is marked non-null but is null");
        }
        if (scheduledExecutor == null) {
            throw new NullPointerException("scheduledExecutor is marked non-null but is null");
        }
        if (instrumentProvider == null) {
            throw new NullPointerException("instrumentProvider is marked non-null but is null");
        }
        if (stubManager == null) {
            throw new NullPointerException("stubManager is marked non-null but is null");
        }
        if (shardManager == null) {
            throw new NullPointerException("shardManager is marked non-null but is null");
        }
        if (notificationManager == null) {
            throw new NullPointerException("notificationManager is marked non-null but is null");
        }
        if (readBatchManager == null) {
            throw new NullPointerException("readBatchManager is marked non-null but is null");
        }
        if (writeBatchManager == null) {
            throw new NullPointerException("writeBatchManager is marked non-null but is null");
        }
        if (sessionManager == null) {
            throw new NullPointerException("sessionManager is marked non-null but is null");
        }
        this.clientIdentifier = clientIdentifier;
        this.instrumentProvider = instrumentProvider;
        this.stubManager = stubManager;
        this.shardManager = shardManager;
        this.notificationManager = notificationManager;
        this.readBatchManager = readBatchManager;
        this.writeBatchManager = writeBatchManager;
        this.sessionManager = sessionManager;
        this.scheduledExecutor = scheduledExecutor;
        this.counterPutBytes = instrumentProvider.newCounter("oxia.client.ops.size", Unit.Bytes, "Total number of bytes in operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"put"));
        this.counterGetBytes = instrumentProvider.newCounter("oxia.client.ops.size", Unit.Bytes, "Total number of bytes in operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"get"));
        this.counterListBytes = instrumentProvider.newCounter("oxia.client.ops.size", Unit.Bytes, "Total number of bytes in operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"list"));
        this.counterRangeScanBytes = instrumentProvider.newCounter("oxia.client.ops.size", Unit.Bytes, "Total number of bytes in operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"range-scan"));
        this.gaugePendingPutRequests = instrumentProvider.newUpDownCounter("oxia.client.ops.pending", Unit.Events, "Current number of outstanding requests", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"put"));
        this.gaugePendingGetRequests = instrumentProvider.newUpDownCounter("oxia.client.ops.pending", Unit.Events, "Current number of outstanding requests", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"get"));
        this.gaugePendingListRequests = instrumentProvider.newUpDownCounter("oxia.client.ops.pending", Unit.Events, "Current number of outstanding requests", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"list"));
        this.gaugePendingRangeScanRequests = instrumentProvider.newUpDownCounter("oxia.client.ops.pending", Unit.Events, "Current number of outstanding requests", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"range-scan"));
        this.gaugePendingDeleteRequests = instrumentProvider.newUpDownCounter("oxia.client.ops.pending", Unit.Events, "Current number of outstanding requests", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"delete"));
        this.gaugePendingDeleteRangeRequests = instrumentProvider.newUpDownCounter("oxia.client.ops.pending", Unit.Events, "Current number of outstanding requests", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"delete-range"));
        this.gaugePendingPutBytes = instrumentProvider.newUpDownCounter("oxia.client.ops.outstanding", Unit.Bytes, "Current number of outstanding bytes in put operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"put"));
        this.histogramPutLatency = instrumentProvider.newLatencyHistogram("oxia.client.ops", "Duration of operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"put"));
        this.histogramGetLatency = instrumentProvider.newLatencyHistogram("oxia.client.ops", "Duration of operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"get"));
        this.histogramDeleteLatency = instrumentProvider.newLatencyHistogram("oxia.client.ops", "Duration of operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"delete"));
        this.histogramDeleteRangeLatency = instrumentProvider.newLatencyHistogram("oxia.client.ops", "Duration of operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"delete-range"));
        this.histogramListLatency = instrumentProvider.newLatencyHistogram("oxia.client.ops", "Duration of operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"list"));
        this.histogramRangeScanLatency = instrumentProvider.newLatencyHistogram("oxia.client.ops", "Duration of operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"range-scan"));
    }

    @NonNull
    public CompletableFuture<PutResult> put(String key, byte[] value) {
        return this.put(key, value, Collections.emptySet());
    }

    @NonNull
    public CompletableFuture<PutResult> put(String key, byte[] value, Set<PutOption> options) {
        CompletableFuture<Object> callback;
        long startTime = System.nanoTime();
        try {
            this.checkIfClosed();
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            callback = this.internalPut(key, value, options);
        }
        catch (RuntimeException e) {
            callback = CompletableFuture.failedFuture(e);
        }
        return callback.whenComplete((putResult, throwable) -> {
            this.gaugePendingPutRequests.decrement();
            this.gaugePendingPutBytes.add(-value.length);
            if (throwable == null) {
                this.counterPutBytes.add(value.length);
                this.histogramPutLatency.recordSuccess(System.nanoTime() - startTime);
            } else {
                this.histogramPutLatency.recordFailure(System.nanoTime() - startTime);
            }
        });
    }

    private CompletableFuture<PutResult> internalPut(String key, byte[] value, Set<PutOption> options) {
        this.gaugePendingPutRequests.increment();
        this.gaugePendingPutBytes.add(value.length);
        Optional<String> partitionKey = OptionsUtils.getPartitionKey(options);
        long shardId = this.shardManager.getShardForKey(partitionKey.orElse(key));
        OptionalLong versionId = OptionsUtils.getVersionId(options);
        Optional<List<Long>> sequenceKeysDeltas = OptionsUtils.getSequenceKeysDeltas(options);
        CompletableFuture<PutResult> future = new CompletableFuture<PutResult>();
        if (!OptionsUtils.isEphemeral(options)) {
            Operation.WriteOperation.PutOperation op = new Operation.WriteOperation.PutOperation(future, key, partitionKey, sequenceKeysDeltas, value, versionId, OptionalLong.empty(), Optional.empty());
            this.writeBatchManager.getBatcher(shardId).add(op);
        } else {
            ((CompletableFuture)this.sessionManager.getSession(shardId).thenAccept(session -> {
                Operation.WriteOperation.PutOperation op = new Operation.WriteOperation.PutOperation(future, key, partitionKey, sequenceKeysDeltas, value, versionId, OptionalLong.of(session.getSessionId()), Optional.of(this.clientIdentifier));
                this.writeBatchManager.getBatcher(shardId).add(op);
            })).exceptionally(ex -> {
                future.completeExceptionally((Throwable)ex);
                return null;
            });
        }
        return future;
    }

    @NonNull
    public CompletableFuture<Boolean> delete(String key) {
        return this.delete(key, Collections.emptySet());
    }

    @NonNull
    public CompletableFuture<Boolean> delete(String key, Set<DeleteOption> options) {
        long startTime = System.nanoTime();
        this.gaugePendingDeleteRequests.increment();
        CompletableFuture<Boolean> callback = new CompletableFuture<Boolean>();
        try {
            this.checkIfClosed();
            Objects.requireNonNull(key);
            OptionalLong versionId = OptionsUtils.getVersionId(options);
            Optional<String> partitionKey = OptionsUtils.getPartitionKey(options);
            long shardId = this.shardManager.getShardForKey(partitionKey.orElse(key));
            this.writeBatchManager.getBatcher(shardId).add(new Operation.WriteOperation.DeleteOperation(callback, key, versionId));
        }
        catch (RuntimeException e) {
            callback.completeExceptionally(e);
        }
        return callback.whenComplete((putResult, throwable) -> {
            this.gaugePendingDeleteRequests.decrement();
            if (throwable == null) {
                this.histogramDeleteLatency.recordSuccess(System.nanoTime() - startTime);
            } else {
                this.histogramDeleteLatency.recordFailure(System.nanoTime() - startTime);
            }
        });
    }

    @NonNull
    public CompletableFuture<Void> deleteRange(String startKeyInclusive, String endKeyExclusive) {
        return this.deleteRange(startKeyInclusive, endKeyExclusive, Collections.emptySet());
    }

    @NonNull
    public CompletableFuture<Void> deleteRange(String startKeyInclusive, String endKeyExclusive, Set<DeleteRangeOption> options) {
        CompletableFuture<Void> callback;
        long startTime = System.nanoTime();
        this.gaugePendingDeleteRangeRequests.increment();
        try {
            this.checkIfClosed();
            Objects.requireNonNull(startKeyInclusive);
            Objects.requireNonNull(endKeyExclusive);
            Optional<String> partitionKey = OptionsUtils.getPartitionKey(options);
            if (partitionKey.isPresent()) {
                long shardId = this.shardManager.getShardForKey(partitionKey.get());
                callback = new CompletableFuture();
                this.writeBatchManager.getBatcher(shardId).add(new Operation.WriteOperation.DeleteRangeOperation(callback, startKeyInclusive, endKeyExclusive));
            } else {
                CompletableFuture[] shardDeletes = (CompletableFuture[])this.shardManager.allShardIds().stream().map(this.writeBatchManager::getBatcher).map(b -> {
                    CompletableFuture<Void> shardCallback = new CompletableFuture<Void>();
                    b.add(new Operation.WriteOperation.DeleteRangeOperation(shardCallback, startKeyInclusive, endKeyExclusive));
                    return shardCallback;
                }).toArray(CompletableFuture[]::new);
                callback = CompletableFuture.allOf(shardDeletes);
            }
        }
        catch (RuntimeException e) {
            callback = CompletableFuture.failedFuture(e);
        }
        return callback.whenComplete((putResult, throwable) -> {
            this.gaugePendingDeleteRangeRequests.decrement();
            if (throwable == null) {
                this.histogramDeleteRangeLatency.recordSuccess(System.nanoTime() - startTime);
            } else {
                this.histogramDeleteRangeLatency.recordFailure(System.nanoTime() - startTime);
            }
        });
    }

    @NonNull
    public CompletableFuture<GetResult> get(String key) {
        return this.get(key, Collections.emptySet());
    }

    @NonNull
    public CompletableFuture<GetResult> get(String key, Set<GetOption> options) {
        long startTime = System.nanoTime();
        this.gaugePendingGetRequests.increment();
        CompletableFuture<GetResult> callback = new CompletableFuture<GetResult>();
        try {
            this.checkIfClosed();
            Objects.requireNonNull(key);
            this.internalGet(key, options, callback);
        }
        catch (RuntimeException e) {
            callback.completeExceptionally(e);
        }
        return callback.whenComplete((getResult, throwable) -> {
            this.gaugePendingGetRequests.decrement();
            if (throwable == null) {
                if (getResult != null) {
                    this.counterGetBytes.add(getResult.getValue().length);
                }
                this.histogramGetLatency.recordSuccess(System.nanoTime() - startTime);
            } else {
                this.histogramGetLatency.recordFailure(System.nanoTime() - startTime);
            }
        });
    }

    private void internalGet(String key, Set<GetOption> options, CompletableFuture<GetResult> result) {
        KeyComparisonType comparisonType = OptionsUtils.getComparisonType(options);
        Optional<String> partitionKey = OptionsUtils.getPartitionKey(options);
        if (comparisonType == KeyComparisonType.EQUAL || partitionKey.isPresent()) {
            long shardId = this.shardManager.getShardForKey(partitionKey.orElse(key));
            this.readBatchManager.getBatcher(shardId).add(new Operation.ReadOperation.GetOperation(result, key, comparisonType));
        } else {
            this.internalGetFloorCeiling(key, comparisonType, result);
        }
    }

    private void internalGetFloorCeiling(String key, KeyComparisonType comparisonType, CompletableFuture<GetResult> result) {
        ArrayList<CompletableFuture<GetResult>> futures = new ArrayList<CompletableFuture<GetResult>>();
        for (long shardId : this.shardManager.allShardIds()) {
            CompletableFuture<GetResult> f = new CompletableFuture<GetResult>();
            this.readBatchManager.getBatcher(shardId).add(new Operation.ReadOperation.GetOperation(f, key, comparisonType));
            futures.add(f);
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenComplete((v, ex) -> {
            if (ex != null) {
                result.completeExceptionally((Throwable)ex);
                return;
            }
            try {
                List<GetResult> results = futures.stream().map(CompletableFuture::join).filter(Objects::nonNull).sorted((o1, o2) -> CompareWithSlash.INSTANCE.compare(o1.getKey(), o2.getKey())).toList();
                if (results.isEmpty()) {
                    result.complete(null);
                    return;
                }
                GetResult gr = switch (comparisonType) {
                    default -> throw new IncompatibleClassChangeError();
                    case KeyComparisonType.EQUAL, KeyComparisonType.UNRECOGNIZED -> null;
                    case KeyComparisonType.FLOOR, KeyComparisonType.LOWER -> results.get(results.size() - 1);
                    case KeyComparisonType.CEILING, KeyComparisonType.HIGHER -> results.get(0);
                };
                result.complete(gr);
            }
            catch (Throwable t) {
                result.completeExceptionally(t);
            }
        });
    }

    @NonNull
    public CompletableFuture<List<String>> list(String startKeyInclusive, String endKeyExclusive) {
        return this.list(startKeyInclusive, endKeyExclusive, Collections.emptySet());
    }

    @NonNull
    public CompletableFuture<List<String>> list(String startKeyInclusive, String endKeyExclusive, Set<ListOption> options) {
        CompletableFuture<Object> callback;
        long startTime = System.nanoTime();
        this.gaugePendingListRequests.increment();
        try {
            this.checkIfClosed();
            Objects.requireNonNull(startKeyInclusive);
            Objects.requireNonNull(endKeyExclusive);
            Optional<String> partitionKey = OptionsUtils.getPartitionKey(options);
            if (partitionKey.isPresent()) {
                long shardId = this.shardManager.getShardForKey(partitionKey.get());
                callback = this.internalShardlist(shardId, startKeyInclusive, endKeyExclusive);
            } else {
                callback = this.internalListMultiShards(startKeyInclusive, endKeyExclusive);
            }
        }
        catch (Exception e) {
            callback = CompletableFuture.failedFuture(e);
        }
        return callback.whenComplete((listResult, throwable) -> {
            this.gaugePendingListRequests.decrement();
            if (throwable == null) {
                this.counterListBytes.add(listResult.stream().mapToInt(String::length).sum());
                this.histogramListLatency.recordSuccess(System.nanoTime() - startTime);
            } else {
                this.histogramListLatency.recordFailure(System.nanoTime() - startTime);
            }
        });
    }

    public void notifications(@NonNull Consumer<Notification> notificationCallback) {
        if (notificationCallback == null) {
            throw new NullPointerException("notificationCallback is marked non-null but is null");
        }
        this.checkIfClosed();
        this.notificationManager.registerCallback(notificationCallback);
    }

    private CompletableFuture<List<String>> internalListMultiShards(String startKeyInclusive, String endKeyExclusive) {
        ArrayList<CompletableFuture<List<String>>> futures = new ArrayList<CompletableFuture<List<String>>>();
        for (long shardId : this.shardManager.allShardIds()) {
            futures.add(this.internalShardlist(shardId, startKeyInclusive, endKeyExclusive));
        }
        CompletableFuture<List<String>> result = new CompletableFuture<List<String>>();
        ArrayList list = new ArrayList();
        ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenRun(() -> {
            for (CompletableFuture future : futures) {
                list.addAll((Collection)future.join());
            }
            list.sort(CompareWithSlash.INSTANCE);
            result.complete(list);
        })).exceptionally(ex -> {
            result.completeExceptionally((Throwable)ex);
            return null;
        });
        return result;
    }

    private CompletableFuture<List<String>> internalShardlist(long shardId, String startKeyInclusive, String endKeyExclusive) {
        String leader = this.shardManager.leader(shardId);
        OxiaStub stub = this.stubManager.getStub(leader);
        ListRequest request = ListRequest.newBuilder().setShardId(shardId).setStartInclusive(startKeyInclusive).setEndExclusive(endKeyExclusive).build();
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        final ArrayList result = new ArrayList();
        stub.async().list(request, new StreamObserver<ListResponse>(){

            public void onNext(ListResponse response) {
                for (int i = 0; i < response.getKeysCount(); ++i) {
                    result.add(response.getKeys(i));
                }
            }

            public void onError(Throwable t) {
                future.completeExceptionally(t);
            }

            public void onCompleted() {
                future.complete(result);
            }
        });
        return future;
    }

    public void rangeScan(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive, @NonNull RangeScanConsumer consumer) {
        if (startKeyInclusive == null) {
            throw new NullPointerException("startKeyInclusive is marked non-null but is null");
        }
        if (endKeyExclusive == null) {
            throw new NullPointerException("endKeyExclusive is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        this.rangeScan(startKeyInclusive, endKeyExclusive, consumer, Collections.emptySet());
    }

    public void rangeScan(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive, final @NonNull RangeScanConsumer consumer, @NonNull Set<RangeScanOption> options) {
        if (startKeyInclusive == null) {
            throw new NullPointerException("startKeyInclusive is marked non-null but is null");
        }
        if (endKeyExclusive == null) {
            throw new NullPointerException("endKeyExclusive is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.gaugePendingRangeScanRequests.increment();
        RangeScanConsumerWithShard timedConsumer = new RangeScanConsumerWithShard(){
            final long startTime = System.nanoTime();
            final AtomicLong totalSize = new AtomicLong();

            @Override
            public void onNext(long shardId, GetResult result) {
                this.totalSize.addAndGet(result.getValue().length);
                consumer.onNext(result);
            }

            @Override
            public void onError(Throwable throwable) {
                AsyncOxiaClientImpl.this.gaugePendingListRequests.decrement();
                AsyncOxiaClientImpl.this.histogramRangeScanLatency.recordFailure(System.nanoTime() - this.startTime);
                consumer.onError(throwable);
            }

            @Override
            public void onCompleted(long shardId) {
                AsyncOxiaClientImpl.this.gaugePendingRangeScanRequests.decrement();
                AsyncOxiaClientImpl.this.counterRangeScanBytes.add(this.totalSize.longValue());
                AsyncOxiaClientImpl.this.histogramRangeScanLatency.recordSuccess(System.nanoTime() - this.startTime);
                consumer.onCompleted();
            }
        };
        try {
            this.checkIfClosed();
            Objects.requireNonNull(startKeyInclusive);
            Objects.requireNonNull(endKeyExclusive);
            Optional<String> partitionKey = OptionsUtils.getPartitionKey(options);
            if (partitionKey.isPresent()) {
                long shardId = this.shardManager.getShardForKey(partitionKey.get());
                this.internalShardRangeScan(shardId, startKeyInclusive, endKeyExclusive, timedConsumer);
            } else {
                this.internalRangeScanMultiShards(startKeyInclusive, endKeyExclusive, timedConsumer);
            }
        }
        catch (Exception e) {
            consumer.onError((Throwable)e);
        }
    }

    private void internalShardRangeScan(final long shardId, String startKeyInclusive, String endKeyExclusive, final RangeScanConsumerWithShard consumer) {
        String leader = this.shardManager.leader(shardId);
        OxiaStub stub = this.stubManager.getStub(leader);
        RangeScanRequest request = RangeScanRequest.newBuilder().setShardId(shardId).setStartInclusive(startKeyInclusive).setEndExclusive(endKeyExclusive).build();
        stub.async().rangeScan(request, new StreamObserver<RangeScanResponse>(){

            public void onNext(RangeScanResponse response) {
                for (int i = 0; i < response.getRecordsCount(); ++i) {
                    consumer.onNext(shardId, ProtoUtil.getResultFromProto("", response.getRecords(i)));
                }
            }

            public void onError(Throwable t) {
                consumer.onError(t);
            }

            public void onCompleted() {
                consumer.onCompleted(shardId);
            }
        });
    }

    private void internalRangeScanMultiShards(String startKeyInclusive, String endKeyExclusive, final RangeScanConsumerWithShard consumer) {
        final Set<Long> shardIds = this.shardManager.allShardIds();
        RangeScanConsumerWithShard multiShardConsumer = new RangeScanConsumerWithShard(){
            private final Set<Long> pendingShards;
            private boolean failed;
            {
                this.pendingShards = new HashSet<Long>(shardIds);
                this.failed = false;
            }

            @Override
            public synchronized void onNext(long shardId, GetResult result) {
                if (!this.failed) {
                    consumer.onNext(shardId, result);
                }
            }

            @Override
            public synchronized void onError(Throwable throwable) {
                this.failed = true;
                consumer.onError(throwable);
            }

            @Override
            public synchronized void onCompleted(long shardId) {
                if (!this.failed) {
                    this.pendingShards.remove(shardId);
                    if (this.pendingShards.isEmpty()) {
                        consumer.onCompleted(shardId);
                    }
                }
            }
        };
        for (long shardId : shardIds) {
            this.internalShardRangeScan(shardId, startKeyInclusive, endKeyExclusive, multiShardConsumer);
        }
    }

    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.readBatchManager.close();
        this.writeBatchManager.close();
        this.sessionManager.close();
        this.notificationManager.close();
        this.shardManager.close();
        this.stubManager.close();
        this.scheduledExecutor.shutdownNow();
    }

    private void checkIfClosed() {
        if (this.closed) {
            throw new IllegalStateException("Client has been closed");
        }
    }

    static interface RangeScanConsumerWithShard {
        public void onNext(long var1, GetResult var3);

        public void onError(Throwable var1);

        public void onCompleted(long var1);
    }
}

