/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.grpc;

import io.grpc.internal.BackoffPolicy;
import io.streamnative.oxia.client.api.Authentication;
import io.streamnative.oxia.client.grpc.OxiaStub;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class OxiaStubManager
implements AutoCloseable {
    private final Map<String, OxiaStub> stubs = new ConcurrentHashMap<String, OxiaStub>();
    private final String namespace;
    @Nullable
    private final Authentication authentication;
    private final boolean enableTls;
    @Nullable
    private final BackoffPolicy.Provider backoffProvider;

    public OxiaStubManager(String namespace, @Nullable Authentication authentication, boolean enableTls, @Nullable BackoffPolicy.Provider backoffProvider) {
        this.namespace = namespace;
        this.authentication = authentication;
        this.enableTls = enableTls;
        this.backoffProvider = backoffProvider;
    }

    public OxiaStub getStub(String address) {
        return this.stubs.computeIfAbsent(address, addr -> new OxiaStub((String)addr, this.namespace, this.authentication, this.enableTls, this.backoffProvider));
    }

    @Override
    public void close() throws Exception {
        for (OxiaStub stub : this.stubs.values()) {
            stub.close();
        }
    }
}

