/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shell.config;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;

public interface ConfigStore {
    public static final String DEFAULT_CONFIG = "default";

    public void putConfig(ConfigEntry var1) throws IOException;

    public ConfigEntry getConfig(String var1) throws IOException;

    public void deleteConfig(String var1) throws IOException;

    public List<ConfigEntry> listConfigs() throws IOException;

    public void setLastUsed(String var1) throws IOException;

    public ConfigEntry getLastUsed() throws IOException;

    public static void cleanupValue(ConfigEntry entry) {
        StringBuilder builder = new StringBuilder();
        try (Scanner scanner = new Scanner(entry.getValue());){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (line.isBlank() || line.startsWith("#")) continue;
                builder.append(line);
                builder.append(System.lineSeparator());
            }
        }
        entry.setValue(builder.toString());
    }

    public static void setProperty(ConfigEntry entry, String propertyName, String propertyValue) {
        HashSet<String> keys = new HashSet<String>();
        StringBuilder builder = new StringBuilder();
        try (Scanner scanner = new Scanner(entry.getValue());){
            while (scanner.hasNextLine()) {
                Object line = scanner.nextLine().trim();
                if (((String)line).isBlank() || ((String)line).startsWith("#")) continue;
                String[] split = ((String)line).split("=", 2);
                if (split.length > 0) {
                    String property = split[0];
                    if (!keys.add(property)) continue;
                    if (property.equals(propertyName)) {
                        line = property + "=" + propertyValue;
                    }
                }
                builder.append((String)line);
                builder.append(System.lineSeparator());
            }
            if (!keys.contains(propertyName)) {
                builder.append(propertyName + "=" + propertyValue);
                builder.append(System.lineSeparator());
            }
        }
        entry.setValue(builder.toString());
    }

    public static String getProperty(ConfigEntry entry, String propertyName) {
        try (Scanner scanner = new Scanner(entry.getValue());){
            while (scanner.hasNextLine()) {
                String property;
                String line = scanner.nextLine().trim();
                if (line.isBlank() || line.startsWith("#")) continue;
                String[] split = line.split("=", 2);
                if (split.length <= 0 || !(property = split[0]).equals(propertyName)) continue;
                if (split.length > 1) {
                    String string = split[1];
                    return string;
                }
                String string = null;
                return string;
            }
        }
        return null;
    }

    public static class ConfigEntry {
        String name;
        String value;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigEntry)) {
                return false;
            }
            ConfigEntry other = (ConfigEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConfigEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "ConfigStore.ConfigEntry(name=" + this.getName() + ", value=" + this.getValue() + ")";
        }

        public ConfigEntry(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public ConfigEntry() {
        }
    }
}

