/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.ResourceGroups;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.policies.data.ResourceGroup;

public class ResourceGroupsImpl
extends BaseResource
implements ResourceGroups {
    private final WebTarget adminResourceGroups;

    public ResourceGroupsImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminResourceGroups = web.path("/admin/v2/resourcegroups");
    }

    public List<String> getResourceGroups() throws PulsarAdminException {
        return (List)this.sync(() -> this.getResourceGroupsAsync());
    }

    public CompletableFuture<List<String>> getResourceGroupsAsync() {
        return this.asyncGetRequest(this.adminResourceGroups, new BaseResource.FutureCallback<List<String>>(){});
    }

    public ResourceGroup getResourceGroup(String resourcegroup) throws PulsarAdminException {
        return (ResourceGroup)this.sync(() -> this.getResourceGroupAsync(resourcegroup));
    }

    public CompletableFuture<ResourceGroup> getResourceGroupAsync(String name) {
        WebTarget path = this.adminResourceGroups.path(name);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<ResourceGroup>(){});
    }

    public void createResourceGroup(String name, ResourceGroup resourcegroup) throws PulsarAdminException {
        this.sync(() -> this.createResourceGroupAsync(name, resourcegroup));
    }

    public CompletableFuture<Void> createResourceGroupAsync(String name, ResourceGroup resourcegroup) {
        WebTarget path = this.adminResourceGroups.path(name);
        return this.asyncPutRequest(path, Entity.entity((Object)resourcegroup, (String)"application/json"));
    }

    public void updateResourceGroup(String name, ResourceGroup resourcegroup) throws PulsarAdminException {
        this.sync(() -> this.updateResourceGroupAsync(name, resourcegroup));
    }

    public CompletableFuture<Void> updateResourceGroupAsync(String name, ResourceGroup resourcegroup) {
        WebTarget path = this.adminResourceGroups.path(name);
        return this.asyncPutRequest(path, Entity.entity((Object)resourcegroup, (String)"application/json"));
    }

    public void deleteResourceGroup(String name) throws PulsarAdminException {
        this.sync(() -> this.deleteResourceGroupAsync(name));
    }

    public CompletableFuture<Void> deleteResourceGroupAsync(String name) {
        WebTarget path = this.adminResourceGroups.path(name);
        return this.asyncDeleteRequest(path);
    }
}

