/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.collections;

import io.netty.util.internal.MathUtil;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class GrowableArrayBlockingQueue<T>
extends AbstractQueue<T>
implements BlockingQueue<T> {
    private final ReentrantLock headLock = new ReentrantLock();
    private final PaddedInt headIndex = new PaddedInt();
    private final PaddedInt tailIndex = new PaddedInt();
    private final StampedLock tailLock = new StampedLock();
    private final Condition isNotEmpty = this.headLock.newCondition();
    private T[] data;
    private static final AtomicIntegerFieldUpdater<GrowableArrayBlockingQueue> SIZE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(GrowableArrayBlockingQueue.class, "size");
    private volatile int size = 0;
    private volatile boolean terminated = false;
    private volatile Consumer<T> itemAfterTerminatedHandler;

    public GrowableArrayBlockingQueue() {
        this(64);
    }

    public GrowableArrayBlockingQueue(int initialCapacity) {
        this.headIndex.value = 0;
        this.tailIndex.value = 0;
        int capacity = MathUtil.findNextPositivePowerOfTwo((int)initialCapacity);
        this.data = new Object[capacity];
    }

    @Override
    public T remove() {
        T item = this.poll();
        if (item == null) {
            throw new NoSuchElementException();
        }
        return item;
    }

    @Override
    public T poll() {
        this.headLock.lock();
        try {
            if (SIZE_UPDATER.get(this) > 0) {
                T item = this.data[this.headIndex.value];
                this.data[((PaddedInt)this.headIndex).value] = null;
                this.headIndex.value = this.headIndex.value + 1 & this.data.length - 1;
                SIZE_UPDATER.decrementAndGet(this);
                T t = item;
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            this.headLock.unlock();
        }
    }

    @Override
    public T element() {
        T item = this.peek();
        if (item == null) {
            throw new NoSuchElementException();
        }
        return item;
    }

    @Override
    public T peek() {
        this.headLock.lock();
        try {
            if (SIZE_UPDATER.get(this) > 0) {
                T t = this.data[this.headIndex.value];
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            this.headLock.unlock();
        }
    }

    @Override
    public boolean offer(T e) {
        this.put(e);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T e) {
        long stamp = this.tailLock.writeLock();
        boolean wasEmpty = false;
        try {
            if (this.terminated) {
                if (this.itemAfterTerminatedHandler != null) {
                    this.itemAfterTerminatedHandler.accept(e);
                }
                return;
            }
            if (SIZE_UPDATER.get(this) == this.data.length) {
                this.expandArray();
            }
            this.data[((PaddedInt)this.tailIndex).value] = e;
            this.tailIndex.value = this.tailIndex.value + 1 & this.data.length - 1;
            if (SIZE_UPDATER.getAndIncrement(this) == 0) {
                wasEmpty = true;
            }
        }
        finally {
            this.tailLock.unlockWrite(stamp);
        }
        if (wasEmpty) {
            this.headLock.lock();
            try {
                this.isNotEmpty.signal();
            }
            finally {
                this.headLock.unlock();
            }
        }
    }

    @Override
    public boolean add(T e) {
        this.put(e);
        return true;
    }

    @Override
    public boolean offer(T e, long timeout, TimeUnit unit) {
        this.put(e);
        return true;
    }

    @Override
    public T take() throws InterruptedException {
        this.headLock.lockInterruptibly();
        try {
            while (SIZE_UPDATER.get(this) == 0) {
                this.isNotEmpty.await();
            }
            T item = this.data[this.headIndex.value];
            this.data[((PaddedInt)this.headIndex).value] = null;
            this.headIndex.value = this.headIndex.value + 1 & this.data.length - 1;
            if (SIZE_UPDATER.decrementAndGet(this) > 0) {
                this.isNotEmpty.signal();
            }
            T t = item;
            return t;
        }
        finally {
            this.headLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        this.headLock.lockInterruptibly();
        try {
            long timeoutNanos = unit.toNanos(timeout);
            while (SIZE_UPDATER.get(this) == 0) {
                if (timeoutNanos <= 0L) {
                    T t = null;
                    return t;
                }
                timeoutNanos = this.isNotEmpty.awaitNanos(timeoutNanos);
            }
            T item = this.data[this.headIndex.value];
            this.data[((PaddedInt)this.headIndex).value] = null;
            this.headIndex.value = this.headIndex.value + 1 & this.data.length - 1;
            if (SIZE_UPDATER.decrementAndGet(this) > 0) {
                this.isNotEmpty.signal();
            }
            T t = item;
            return t;
        }
        finally {
            this.headLock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        this.headLock.lock();
        try {
            int drainedItems = 0;
            for (int size = SIZE_UPDATER.get(this); size > 0 && drainedItems < maxElements; --size, ++drainedItems) {
                T item = this.data[this.headIndex.value];
                this.data[((PaddedInt)this.headIndex).value] = null;
                c.add(item);
                this.headIndex.value = this.headIndex.value + 1 & this.data.length - 1;
            }
            if (SIZE_UPDATER.addAndGet(this, -drainedItems) > 0) {
                this.isNotEmpty.signal();
            }
            int n = drainedItems;
            return n;
        }
        finally {
            this.headLock.unlock();
        }
    }

    @Override
    public void clear() {
        this.headLock.lock();
        try {
            int size = SIZE_UPDATER.get(this);
            for (int i = 0; i < size; ++i) {
                this.data[((PaddedInt)this.headIndex).value] = null;
                this.headIndex.value = this.headIndex.value + 1 & this.data.length - 1;
            }
            if (SIZE_UPDATER.addAndGet(this, -size) > 0) {
                this.isNotEmpty.signal();
            }
        }
        finally {
            this.headLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        long stamp = this.tailLock.writeLock();
        this.headLock.lock();
        try {
            int index = this.headIndex.value;
            int size = this.size;
            for (int i = 0; i < size; ++i) {
                T item = this.data[index];
                if (Objects.equals(item, o)) {
                    this.remove(index);
                    boolean bl = true;
                    return bl;
                }
                index = index + 1 & this.data.length - 1;
            }
        }
        finally {
            this.headLock.unlock();
            this.tailLock.unlockWrite(stamp);
        }
        return false;
    }

    private void remove(int index) {
        int tailIndex = this.tailIndex.value;
        if (index < tailIndex) {
            System.arraycopy(this.data, index + 1, this.data, index, tailIndex - index - 1);
            this.tailIndex.value--;
        } else {
            System.arraycopy(this.data, index + 1, this.data, index, this.data.length - index - 1);
            this.data[this.data.length - 1] = this.data[0];
            if (tailIndex > 0) {
                System.arraycopy(this.data, 1, this.data, 0, tailIndex);
                this.tailIndex.value--;
            } else {
                this.tailIndex.value = this.data.length - 1;
            }
        }
        if (tailIndex > 0) {
            this.data[tailIndex - 1] = null;
        } else {
            this.data[this.data.length - 1] = null;
        }
        SIZE_UPDATER.decrementAndGet(this);
    }

    @Override
    public int size() {
        return SIZE_UPDATER.get(this);
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    public List<T> toList() {
        ArrayList list = new ArrayList(this.size());
        this.forEach(list::add);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(Consumer<? super T> action) {
        long stamp = this.tailLock.writeLock();
        this.headLock.lock();
        try {
            int headIndex = this.headIndex.value;
            int size = this.size;
            for (int i = 0; i < size; ++i) {
                T item = this.data[headIndex];
                action.accept(item);
                headIndex = headIndex + 1 & this.data.length - 1;
            }
        }
        finally {
            this.headLock.unlock();
            this.tailLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        long stamp = this.tailLock.writeLock();
        this.headLock.lock();
        try {
            int headIndex = this.headIndex.value;
            int size = SIZE_UPDATER.get(this);
            sb.append('[');
            for (int i = 0; i < size; ++i) {
                T item = this.data[headIndex];
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(item);
                headIndex = headIndex + 1 & this.data.length - 1;
            }
            sb.append(']');
        }
        finally {
            this.headLock.unlock();
            this.tailLock.unlockWrite(stamp);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(@Nullable Consumer<T> itemAfterTerminatedHandler) {
        long stamp = this.tailLock.writeLock();
        try {
            this.terminated = true;
            if (itemAfterTerminatedHandler != null) {
                this.itemAfterTerminatedHandler = itemAfterTerminatedHandler;
            }
        }
        finally {
            this.tailLock.unlockWrite(stamp);
        }
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandArray() {
        this.headLock.lock();
        try {
            int size = SIZE_UPDATER.get(this);
            int newCapacity = this.data.length * 2;
            Object[] newData = new Object[newCapacity];
            int oldHeadIndex = this.headIndex.value;
            int newTailIndex = 0;
            for (int i = 0; i < size; ++i) {
                newData[newTailIndex++] = this.data[oldHeadIndex];
                oldHeadIndex = oldHeadIndex + 1 & this.data.length - 1;
            }
            this.data = newData;
            this.headIndex.value = 0;
            this.tailIndex.value = size;
        }
        finally {
            this.headLock.unlock();
        }
    }

    static final class PaddedInt {
        private int value;
        public volatile int pi1 = 1;
        public volatile long p1 = 1L;
        public volatile long p2 = 2L;
        public volatile long p3 = 3L;
        public volatile long p4 = 4L;
        public volatile long p5 = 5L;
        public volatile long p6 = 6L;

        PaddedInt() {
        }

        public long exposeToAvoidOptimization() {
            return (long)this.pi1 + this.p1 + this.p2 + this.p3 + this.p4 + this.p5 + this.p6;
        }
    }
}

