/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import com.google.gson.Gson;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.admin.Functions;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.admin.internal.ComponentResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.FunctionDefinition;
import org.apache.pulsar.common.functions.FunctionState;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.common.functions.UpdateOptionsImpl;
import org.apache.pulsar.common.functions.WorkerInfo;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.policies.data.FunctionInstanceStatsData;
import org.apache.pulsar.common.policies.data.FunctionInstanceStatsDataImpl;
import org.apache.pulsar.common.policies.data.FunctionStats;
import org.apache.pulsar.common.policies.data.FunctionStatsImpl;
import org.apache.pulsar.common.policies.data.FunctionStatus;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.request.body.multipart.ByteArrayPart;
import org.asynchttpclient.request.body.multipart.FilePart;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.request.body.multipart.StringPart;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsImpl
extends ComponentResource
implements Functions {
    private static final Logger log = LoggerFactory.getLogger(FunctionsImpl.class);
    private final WebTarget functions;
    private final AsyncHttpClient asyncHttpClient;

    public FunctionsImpl(WebTarget web, Authentication auth, AsyncHttpClient asyncHttpClient, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.functions = web.path("/admin/v3/functions");
        this.asyncHttpClient = asyncHttpClient;
    }

    public List<String> getFunctions(String tenant, String namespace) throws PulsarAdminException {
        return (List)this.sync(() -> this.getFunctionsAsync(tenant, namespace));
    }

    public CompletableFuture<List<String>> getFunctionsAsync(String tenant, String namespace) {
        WebTarget path = this.functions.path(tenant).path(namespace);
        return this.asyncGetRequest(path, new GenericType<List<String>>(){});
    }

    public FunctionConfig getFunction(String tenant, String namespace, String function) throws PulsarAdminException {
        return (FunctionConfig)this.sync(() -> this.getFunctionAsync(tenant, namespace, function));
    }

    public CompletableFuture<FunctionConfig> getFunctionAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function);
        return this.asyncGetRequest(path, FunctionConfig.class);
    }

    public FunctionStatus getFunctionStatus(String tenant, String namespace, String function) throws PulsarAdminException {
        return (FunctionStatus)this.sync(() -> this.getFunctionStatusAsync(tenant, namespace, function));
    }

    public CompletableFuture<FunctionStatus> getFunctionStatusAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("status");
        return this.asyncGetRequest(path, FunctionStatus.class);
    }

    public FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData getFunctionStatus(String tenant, String namespace, String function, int id) throws PulsarAdminException {
        return (FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData)this.sync(() -> this.getFunctionStatusAsync(tenant, namespace, function, id));
    }

    public CompletableFuture<FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData> getFunctionStatusAsync(String tenant, String namespace, String function, int id) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path(Integer.toString(id)).path("status");
        return this.asyncGetRequest(path, FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData.class);
    }

    public FunctionInstanceStatsData getFunctionStats(String tenant, String namespace, String function, int id) throws PulsarAdminException {
        return (FunctionInstanceStatsData)this.sync(() -> this.getFunctionStatsAsync(tenant, namespace, function, id));
    }

    public CompletableFuture<FunctionInstanceStatsData> getFunctionStatsAsync(String tenant, String namespace, String function, int id) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path(Integer.toString(id)).path("stats");
        return this.asyncGetRequest(path, FunctionInstanceStatsDataImpl.class);
    }

    public FunctionStats getFunctionStats(String tenant, String namespace, String function) throws PulsarAdminException {
        return (FunctionStats)this.sync(() -> this.getFunctionStatsAsync(tenant, namespace, function));
    }

    public CompletableFuture<FunctionStats> getFunctionStatsAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("stats");
        return this.asyncGetRequest(path, FunctionStatsImpl.class);
    }

    public void createFunction(FunctionConfig functionConfig, String fileName) throws PulsarAdminException {
        this.sync(() -> this.createFunctionAsync(functionConfig, fileName));
    }

    public CompletableFuture<Void> createFunctionAsync(FunctionConfig functionConfig, String fileName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = (RequestBuilder)Dsl.post((String)this.functions.path(functionConfig.getTenant()).path(functionConfig.getNamespace()).path(functionConfig.getName()).getUri().toASCIIString()).addBodyPart((Part)new StringPart("functionConfig", this.objectWriter().writeValueAsString((Object)functionConfig), "application/json"));
            if (fileName != null && !fileName.startsWith("builtin://")) {
                builder.addBodyPart((Part)new FilePart("data", new File(fileName), "application/octet-stream"));
            }
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status((int)response.getStatusCode()).entity((Object)response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(FunctionsImpl.getApiException(throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void createFunctionWithUrl(FunctionConfig functionConfig, String pkgUrl) throws PulsarAdminException {
        this.sync(() -> this.createFunctionWithUrlAsync(functionConfig, pkgUrl));
    }

    public CompletableFuture<Void> createFunctionWithUrlAsync(FunctionConfig functionConfig, String pkgUrl) {
        WebTarget path = this.functions.path(functionConfig.getTenant()).path(functionConfig.getNamespace()).path(functionConfig.getName());
        FormDataMultiPart mp = new FormDataMultiPart();
        mp.bodyPart((BodyPart)new FormDataBodyPart("url", (Object)pkgUrl, MediaType.TEXT_PLAIN_TYPE));
        mp.bodyPart((BodyPart)new FormDataBodyPart("functionConfig", (Object)new Gson().toJson((Object)functionConfig), MediaType.APPLICATION_JSON_TYPE));
        return this.asyncPostRequest(path, Entity.entity((Object)mp, (String)"multipart/form-data"));
    }

    public void deleteFunction(String cluster, String namespace, String function) throws PulsarAdminException {
        this.sync(() -> this.deleteFunctionAsync(cluster, namespace, function));
    }

    public CompletableFuture<Void> deleteFunctionAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function);
        return this.asyncDeleteRequest(path);
    }

    public void updateFunction(FunctionConfig functionConfig, String fileName) throws PulsarAdminException {
        this.updateFunction(functionConfig, fileName, null);
    }

    public CompletableFuture<Void> updateFunctionAsync(FunctionConfig functionConfig, String fileName) {
        return this.updateFunctionAsync(functionConfig, fileName, null);
    }

    public void updateFunction(FunctionConfig functionConfig, String fileName, UpdateOptions updateOptions) throws PulsarAdminException {
        this.sync(() -> this.updateFunctionAsync(functionConfig, fileName, updateOptions));
    }

    public CompletableFuture<Void> updateFunctionAsync(FunctionConfig functionConfig, String fileName, UpdateOptions updateOptions) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = (RequestBuilder)Dsl.put((String)this.functions.path(functionConfig.getTenant()).path(functionConfig.getNamespace()).path(functionConfig.getName()).getUri().toASCIIString()).addBodyPart((Part)new StringPart("functionConfig", this.objectWriter().writeValueAsString((Object)functionConfig), "application/json"));
            UpdateOptionsImpl options = (UpdateOptionsImpl)updateOptions;
            if (options != null) {
                builder.addBodyPart((Part)new StringPart("updateOptions", this.objectWriter().writeValueAsString((Object)options), "application/json"));
            }
            if (fileName != null && !fileName.startsWith("builtin://")) {
                builder.addBodyPart((Part)new FilePart("data", new File(fileName), "application/octet-stream"));
            }
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status((int)response.getStatusCode()).entity((Object)response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(FunctionsImpl.getApiException(throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(FunctionsImpl.getApiException(e));
        }
        return future;
    }

    public void updateFunctionWithUrl(FunctionConfig functionConfig, String pkgUrl, UpdateOptions updateOptions) throws PulsarAdminException {
        this.sync(() -> this.updateFunctionWithUrlAsync(functionConfig, pkgUrl, updateOptions));
    }

    public CompletableFuture<Void> updateFunctionWithUrlAsync(FunctionConfig functionConfig, String pkgUrl, UpdateOptions updateOptions) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.bodyPart((BodyPart)new FormDataBodyPart("url", (Object)pkgUrl, MediaType.TEXT_PLAIN_TYPE));
            mp.bodyPart((BodyPart)new FormDataBodyPart("functionConfig", (Object)this.objectWriter().writeValueAsString((Object)functionConfig), MediaType.APPLICATION_JSON_TYPE));
            UpdateOptionsImpl options = (UpdateOptionsImpl)updateOptions;
            if (options != null) {
                mp.bodyPart((BodyPart)new FormDataBodyPart("updateOptions", (Object)this.objectWriter().writeValueAsString((Object)options), MediaType.APPLICATION_JSON_TYPE));
            }
            WebTarget path = this.functions.path(functionConfig.getTenant()).path(functionConfig.getNamespace()).path(functionConfig.getName());
            return this.asyncPutRequest(path, Entity.entity((Object)mp, (String)"multipart/form-data"));
        }
        catch (Exception e) {
            future.completeExceptionally(FunctionsImpl.getApiException(e));
            return future;
        }
    }

    public void updateFunctionWithUrl(FunctionConfig functionConfig, String pkgUrl) throws PulsarAdminException {
        this.updateFunctionWithUrl(functionConfig, pkgUrl, null);
    }

    public CompletableFuture<Void> updateFunctionWithUrlAsync(FunctionConfig functionConfig, String pkgUrl) {
        return this.updateFunctionWithUrlAsync(functionConfig, pkgUrl, null);
    }

    public String triggerFunction(String tenant, String namespace, String functionName, String topic, String triggerValue, String triggerFile) throws PulsarAdminException {
        return (String)this.sync(() -> this.triggerFunctionAsync(tenant, namespace, functionName, topic, triggerValue, triggerFile));
    }

    public CompletableFuture<String> triggerFunctionAsync(String tenant, String namespace, String function, String topic, String triggerValue, String triggerFile) {
        FormDataMultiPart mp = new FormDataMultiPart();
        if (triggerFile != null) {
            mp.bodyPart((BodyPart)new FileDataBodyPart("dataStream", new File(triggerFile), MediaType.APPLICATION_OCTET_STREAM_TYPE));
        }
        if (triggerValue != null) {
            mp.bodyPart((BodyPart)new FormDataBodyPart("data", (Object)triggerValue, MediaType.TEXT_PLAIN_TYPE));
        }
        if (topic != null && !topic.isEmpty()) {
            mp.bodyPart((BodyPart)new FormDataBodyPart("topic", (Object)topic, MediaType.TEXT_PLAIN_TYPE));
        }
        final WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("trigger");
        final CompletableFuture<String> future = new CompletableFuture<String>();
        try {
            this.request(path).async().post(Entity.entity((Object)mp, (String)"multipart/form-data"), (InvocationCallback)new InvocationCallback<String>(){

                public void completed(String response) {
                    future.complete(response);
                }

                public void failed(Throwable throwable) {
                    log.warn("[{}] Failed to perform http post request: {}", (Object)path.getUri(), (Object)throwable.getMessage());
                    future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public void restartFunction(String tenant, String namespace, String functionName, int instanceId) throws PulsarAdminException {
        this.sync(() -> this.restartFunctionAsync(tenant, namespace, functionName, instanceId));
    }

    public CompletableFuture<Void> restartFunctionAsync(String tenant, String namespace, String function, int instanceId) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path(Integer.toString(instanceId)).path("restart");
        return this.asyncPostRequest(path, Entity.entity((Object)"", (String)"application/json"));
    }

    public void restartFunction(String tenant, String namespace, String functionName) throws PulsarAdminException {
        this.sync(() -> this.restartFunctionAsync(tenant, namespace, functionName));
    }

    public CompletableFuture<Void> restartFunctionAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("restart");
        return this.asyncPostRequest(path, Entity.entity((Object)"", (String)"application/json"));
    }

    public void stopFunction(String tenant, String namespace, String functionName, int instanceId) throws PulsarAdminException {
        this.sync(() -> this.stopFunctionAsync(tenant, namespace, functionName, instanceId));
    }

    public CompletableFuture<Void> stopFunctionAsync(String tenant, String namespace, String function, int instanceId) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path(Integer.toString(instanceId)).path("stop");
        return this.asyncPostRequest(path, Entity.entity((Object)"", (String)"application/json"));
    }

    public void stopFunction(String tenant, String namespace, String functionName) throws PulsarAdminException {
        this.sync(() -> this.stopFunctionAsync(tenant, namespace, functionName));
    }

    public CompletableFuture<Void> stopFunctionAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("stop");
        return this.asyncPostRequest(path, Entity.entity((Object)"", (String)"application/json"));
    }

    public void startFunction(String tenant, String namespace, String functionName, int instanceId) throws PulsarAdminException {
        this.sync(() -> this.startFunctionAsync(tenant, namespace, functionName, instanceId));
    }

    public CompletableFuture<Void> startFunctionAsync(String tenant, String namespace, String function, int instanceId) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path(Integer.toString(instanceId)).path("start");
        return this.asyncPostRequest(path, Entity.entity((Object)"", (String)"application/json"));
    }

    public void startFunction(String tenant, String namespace, String functionName) throws PulsarAdminException {
        this.sync(() -> this.startFunctionAsync(tenant, namespace, functionName));
    }

    public CompletableFuture<Void> startFunctionAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("start");
        return this.asyncPostRequest(path, Entity.entity((Object)"", (String)"application/json"));
    }

    public void uploadFunction(String sourceFile, String path) throws PulsarAdminException {
        this.sync(() -> this.uploadFunctionAsync(sourceFile, path));
    }

    public CompletableFuture<Void> uploadFunctionAsync(String sourceFile, String path) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = (RequestBuilder)((RequestBuilder)Dsl.post((String)this.functions.path("upload").getUri().toASCIIString()).addBodyPart((Part)new FilePart("data", new File(sourceFile), "application/octet-stream"))).addBodyPart((Part)new StringPart("path", path, "text/plain"));
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status((int)response.getStatusCode()).entity((Object)response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(FunctionsImpl.getApiException(throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(FunctionsImpl.getApiException(e));
        }
        return future;
    }

    public void downloadFunction(String destinationPath, String tenant, String namespace, String functionName) throws PulsarAdminException {
        this.downloadFile(destinationPath, this.functions.path(tenant).path(namespace).path(functionName).path("download"));
    }

    public CompletableFuture<Void> downloadFunctionAsync(String destinationPath, String tenant, String namespace, String functionName) {
        return this.downloadFileAsync(destinationPath, this.functions.path(tenant).path(namespace).path(functionName).path("download"));
    }

    public void downloadFunction(String destinationPath, String tenant, String namespace, String functionName, boolean transformFunction) throws PulsarAdminException {
        this.downloadFile(destinationPath, this.functions.path(tenant).path(namespace).path(functionName).path("download").queryParam("transform-function", new Object[]{transformFunction}));
    }

    public CompletableFuture<Void> downloadFunctionAsync(String destinationPath, String tenant, String namespace, String functionName, boolean transformFunction) {
        return this.downloadFileAsync(destinationPath, this.functions.path(tenant).path(namespace).path(functionName).path("download").queryParam("transform-function", new Object[]{transformFunction}));
    }

    public void downloadFunction(String destinationPath, String path) throws PulsarAdminException {
        this.downloadFile(destinationPath, this.functions.path("download").queryParam("path", new Object[]{path}));
    }

    public CompletableFuture<Void> downloadFunctionAsync(String destinationFile, String path) {
        return this.downloadFileAsync(destinationFile, this.functions.path("download").queryParam("path", new Object[]{path}));
    }

    private void downloadFile(String destinationPath, WebTarget target) throws PulsarAdminException {
        this.sync(() -> this.downloadFileAsync(destinationPath, target));
    }

    private CompletableFuture<Void> downloadFileAsync(String destinationPath, WebTarget target) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            File file = new File(destinationPath);
            if (!file.exists()) {
                if (file.getParentFile() != null && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            final FileChannel os = new FileOutputStream(new File(destinationPath)).getChannel();
            RequestBuilder builder = Dsl.get((String)target.getUri().toASCIIString());
            CompletableFuture statusFuture = this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build(), (AsyncHandler)new AsyncHandler<HttpResponseStatus>(){
                private HttpResponseStatus status;

                public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    this.status = responseStatus;
                    if (this.status.getStatusCode() != Response.Status.OK.getStatusCode()) {
                        return AsyncHandler.State.ABORT;
                    }
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    os.write(bodyPart.getBodyByteBuffer());
                    return AsyncHandler.State.CONTINUE;
                }

                public HttpResponseStatus onCompleted() throws Exception {
                    return this.status;
                }

                public void onThrowable(Throwable t) {
                }
            }).toCompletableFuture();
            ((CompletableFuture)((CompletableFuture)statusFuture.whenComplete((status, throwable) -> {
                try {
                    os.close();
                }
                catch (IOException e) {
                    future.completeExceptionally(FunctionsImpl.getApiException(e));
                }
            })).thenAccept(status -> {
                if (status.getStatusCode() < 200 || status.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status((int)status.getStatusCode()).entity((Object)status.getStatusText()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(FunctionsImpl.getApiException(throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(FunctionsImpl.getApiException(e));
        }
        return future;
    }

    public List<ConnectorDefinition> getConnectorsList() throws PulsarAdminException {
        try {
            Response response = this.request(this.functions.path("connectors")).get();
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                throw this.getApiException(response);
            }
            return (List)response.readEntity((GenericType)new GenericType<List<ConnectorDefinition>>(){});
        }
        catch (Exception e) {
            throw FunctionsImpl.getApiException(e);
        }
    }

    public Set<String> getSources() throws PulsarAdminException {
        return this.getConnectorsList().stream().filter(c -> !StringUtils.isEmpty((CharSequence)c.getSourceClass())).map(ConnectorDefinition::getName).collect(Collectors.toSet());
    }

    public Set<String> getSinks() throws PulsarAdminException {
        return this.getConnectorsList().stream().filter(c -> !StringUtils.isEmpty((CharSequence)c.getSinkClass())).map(ConnectorDefinition::getName).collect(Collectors.toSet());
    }

    public List<FunctionDefinition> getBuiltInFunctions() throws PulsarAdminException {
        return (List)this.sync(this::getBuiltInFunctionsAsync);
    }

    public CompletableFuture<List<FunctionDefinition>> getBuiltInFunctionsAsync() {
        WebTarget path = this.functions.path("builtins");
        final CompletableFuture<List<FunctionDefinition>> future = new CompletableFuture<List<FunctionDefinition>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(FunctionsImpl.this.getApiException(response));
                } else {
                    future.complete((List)response.readEntity((GenericType)new GenericType<List<FunctionDefinition>>(){}));
                }
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public List<WorkerInfo> getCluster() throws PulsarAdminException {
        try {
            return (List)this.request(this.functions.path("cluster")).get((GenericType)new GenericType<List<WorkerInfo>>(){});
        }
        catch (Exception e) {
            throw FunctionsImpl.getApiException(e);
        }
    }

    public FunctionState getFunctionState(String tenant, String namespace, String function, String key) throws PulsarAdminException {
        return (FunctionState)this.sync(() -> this.getFunctionStateAsync(tenant, namespace, function, key));
    }

    public CompletableFuture<FunctionState> getFunctionStateAsync(String tenant, String namespace, String function, String key) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("state").path(key);
        return this.asyncGetRequest(path, FunctionState.class);
    }

    public void putFunctionState(String tenant, String namespace, String function, FunctionState state) throws PulsarAdminException {
        this.sync(() -> this.putFunctionStateAsync(tenant, namespace, function, state));
    }

    public CompletableFuture<Void> putFunctionStateAsync(String tenant, String namespace, String function, FunctionState state) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = Dsl.post((String)this.functions.path(tenant).path(namespace).path(function).path("state").path(state.getKey()).getUri().toASCIIString());
            builder.addBodyPart((Part)new StringPart("state", this.objectWriter().writeValueAsString((Object)state), "application/json"));
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status((int)response.getStatusCode()).entity((Object)response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(FunctionsImpl.getApiException(throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void updateOnWorkerLeader(String tenant, String namespace, String function, byte[] functionMetaData, boolean delete) throws PulsarAdminException {
        this.sync(() -> this.updateOnWorkerLeaderAsync(tenant, namespace, function, functionMetaData, delete));
    }

    public CompletableFuture<Void> updateOnWorkerLeaderAsync(String tenant, String namespace, String function, byte[] functionMetaData, boolean delete) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = (RequestBuilder)((RequestBuilder)Dsl.put((String)this.functions.path("leader").path(tenant).path(namespace).path(function).getUri().toASCIIString()).addBodyPart((Part)new ByteArrayPart("functionMetaData", functionMetaData))).addBodyPart((Part)new StringPart("delete", Boolean.toString(delete)));
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status((int)response.getStatusCode()).entity((Object)response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(FunctionsImpl.getApiException(throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void reloadBuiltInFunctions() throws PulsarAdminException {
        this.sync(this::reloadBuiltInFunctionsAsync);
    }

    public CompletableFuture<Void> reloadBuiltInFunctionsAsync() {
        WebTarget path = this.functions.path("builtins/reload");
        return this.asyncPostRequest(path, Entity.entity((Object)"", (String)"application/json"));
    }
}

