/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.pulsar.common.policies.data.AuthPolicies;
import org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import org.apache.pulsar.common.policies.data.AutoTopicCreationOverride;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.EntryFilters;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.SubscriptionAuthMode;
import org.apache.pulsar.common.policies.data.impl.DispatchRateImpl;

public class Policies {
    public final AuthPolicies auth_policies = AuthPolicies.builder().build();
    public Set<String> replication_clusters = new HashSet<String>();
    public BundlesData bundles;
    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> backlog_quota_map = new HashMap<BacklogQuota.BacklogQuotaType, BacklogQuota>();
    @Deprecated
    public Map<String, DispatchRateImpl> clusterDispatchRate = new HashMap<String, DispatchRateImpl>();
    public Map<String, DispatchRateImpl> topicDispatchRate = new HashMap<String, DispatchRateImpl>();
    public Map<String, DispatchRateImpl> subscriptionDispatchRate = new HashMap<String, DispatchRateImpl>();
    public Map<String, DispatchRateImpl> replicatorDispatchRate = new HashMap<String, DispatchRateImpl>();
    public Map<String, SubscribeRate> clusterSubscribeRate = new HashMap<String, SubscribeRate>();
    public PersistencePolicies persistence = null;
    public Boolean deduplicationEnabled = null;
    public AutoTopicCreationOverride autoTopicCreationOverride = null;
    public AutoSubscriptionCreationOverride autoSubscriptionCreationOverride = null;
    public Map<String, PublishRate> publishMaxMessageRate = new HashMap<String, PublishRate>();
    public Map<String, Integer> latency_stats_sample_rate = new HashMap<String, Integer>();
    public Integer message_ttl_in_seconds = null;
    public Integer subscription_expiration_time_minutes = null;
    public RetentionPolicies retention_policies = null;
    public boolean deleted = false;
    public static final String FIRST_BOUNDARY = "0x00000000";
    public static final String LAST_BOUNDARY = "0xffffffff";
    public boolean encryption_required = false;
    public DelayedDeliveryPolicies delayed_delivery_policies = null;
    public InactiveTopicPolicies inactive_topic_policies = null;
    public SubscriptionAuthMode subscription_auth_mode = SubscriptionAuthMode.None;
    public Integer max_producers_per_topic = null;
    public Integer max_consumers_per_topic = null;
    public Integer max_consumers_per_subscription = null;
    public Integer max_unacked_messages_per_consumer = null;
    public Integer max_unacked_messages_per_subscription = null;
    public Integer max_subscriptions_per_topic = null;
    public Long compaction_threshold = null;
    public long offload_threshold = -1L;
    public long offload_threshold_in_seconds = -1L;
    public Long offload_deletion_lag_ms = null;
    public Integer max_topics_per_namespace = null;
    @Deprecated
    public SchemaAutoUpdateCompatibilityStrategy schema_auto_update_compatibility_strategy = null;
    public SchemaCompatibilityStrategy schema_compatibility_strategy = SchemaCompatibilityStrategy.UNDEFINED;
    public Boolean is_allow_auto_update_schema = null;
    public boolean schema_validation_enforced = false;
    public OffloadPolicies offload_policies = null;
    public Integer deduplicationSnapshotIntervalSeconds = null;
    public Set<String> subscription_types_enabled = new HashSet<String>();
    public Map<String, String> properties = new HashMap<String, String>();
    public String resource_group_name = null;
    public boolean migrated;
    public Boolean dispatcherPauseOnAckStatePersistentEnabled;
    public EntryFilters entryFilters = null;

    public int hashCode() {
        return Objects.hash(new Object[]{this.auth_policies, this.replication_clusters, this.backlog_quota_map, this.publishMaxMessageRate, this.clusterDispatchRate, this.topicDispatchRate, this.subscriptionDispatchRate, this.replicatorDispatchRate, this.clusterSubscribeRate, this.deduplicationEnabled, this.autoTopicCreationOverride, this.autoSubscriptionCreationOverride, this.persistence, this.bundles, this.latency_stats_sample_rate, this.message_ttl_in_seconds, this.subscription_expiration_time_minutes, this.retention_policies, this.encryption_required, this.delayed_delivery_policies, this.inactive_topic_policies, this.subscription_auth_mode, this.max_producers_per_topic, this.max_consumers_per_topic, this.max_consumers_per_subscription, this.max_unacked_messages_per_consumer, this.max_unacked_messages_per_subscription, this.compaction_threshold, this.offload_threshold, this.offload_threshold_in_seconds, this.offload_deletion_lag_ms, this.schema_auto_update_compatibility_strategy, this.schema_validation_enforced, this.schema_compatibility_strategy, this.is_allow_auto_update_schema, this.offload_policies, this.subscription_types_enabled, this.properties, this.resource_group_name, this.entryFilters, this.migrated, this.dispatcherPauseOnAckStatePersistentEnabled});
    }

    public boolean equals(Object obj) {
        if (obj instanceof Policies) {
            Policies other = (Policies)obj;
            return Objects.equals(this.auth_policies, other.auth_policies) && Objects.equals(this.replication_clusters, other.replication_clusters) && Objects.equals(this.backlog_quota_map, other.backlog_quota_map) && Objects.equals(this.clusterDispatchRate, other.clusterDispatchRate) && Objects.equals(this.topicDispatchRate, other.topicDispatchRate) && Objects.equals(this.subscriptionDispatchRate, other.subscriptionDispatchRate) && Objects.equals(this.replicatorDispatchRate, other.replicatorDispatchRate) && Objects.equals(this.clusterSubscribeRate, other.clusterSubscribeRate) && Objects.equals(this.publishMaxMessageRate, other.publishMaxMessageRate) && Objects.equals(this.deduplicationEnabled, other.deduplicationEnabled) && Objects.equals(this.autoTopicCreationOverride, other.autoTopicCreationOverride) && Objects.equals(this.autoSubscriptionCreationOverride, other.autoSubscriptionCreationOverride) && Objects.equals(this.persistence, other.persistence) && Objects.equals(this.bundles, other.bundles) && Objects.equals(this.latency_stats_sample_rate, other.latency_stats_sample_rate) && Objects.equals(this.message_ttl_in_seconds, other.message_ttl_in_seconds) && Objects.equals(this.subscription_expiration_time_minutes, other.subscription_expiration_time_minutes) && Objects.equals(this.retention_policies, other.retention_policies) && Objects.equals(this.encryption_required, other.encryption_required) && Objects.equals(this.delayed_delivery_policies, other.delayed_delivery_policies) && Objects.equals(this.inactive_topic_policies, other.inactive_topic_policies) && Objects.equals((Object)this.subscription_auth_mode, (Object)other.subscription_auth_mode) && Objects.equals(this.max_producers_per_topic, other.max_producers_per_topic) && Objects.equals(this.max_consumers_per_topic, other.max_consumers_per_topic) && Objects.equals(this.max_unacked_messages_per_consumer, other.max_unacked_messages_per_consumer) && Objects.equals(this.max_unacked_messages_per_subscription, other.max_unacked_messages_per_subscription) && Objects.equals(this.max_consumers_per_subscription, other.max_consumers_per_subscription) && Objects.equals(this.compaction_threshold, other.compaction_threshold) && this.offload_threshold == other.offload_threshold && this.offload_threshold_in_seconds == other.offload_threshold_in_seconds && Objects.equals(this.offload_deletion_lag_ms, other.offload_deletion_lag_ms) && this.schema_auto_update_compatibility_strategy == other.schema_auto_update_compatibility_strategy && this.schema_validation_enforced == other.schema_validation_enforced && this.schema_compatibility_strategy == other.schema_compatibility_strategy && this.is_allow_auto_update_schema == other.is_allow_auto_update_schema && Objects.equals(this.offload_policies, other.offload_policies) && Objects.equals(this.subscription_types_enabled, other.subscription_types_enabled) && Objects.equals(this.properties, other.properties) && Objects.equals(this.migrated, other.migrated) && Objects.equals(this.resource_group_name, other.resource_group_name) && Objects.equals(this.entryFilters, other.entryFilters) && Objects.equals(this.dispatcherPauseOnAckStatePersistentEnabled, other.dispatcherPauseOnAckStatePersistentEnabled);
        }
        return false;
    }

    public String toString() {
        return "Policies(auth_policies=" + this.auth_policies + ", replication_clusters=" + this.replication_clusters + ", bundles=" + this.bundles + ", backlog_quota_map=" + this.backlog_quota_map + ", clusterDispatchRate=" + this.clusterDispatchRate + ", topicDispatchRate=" + this.topicDispatchRate + ", subscriptionDispatchRate=" + this.subscriptionDispatchRate + ", replicatorDispatchRate=" + this.replicatorDispatchRate + ", clusterSubscribeRate=" + this.clusterSubscribeRate + ", persistence=" + this.persistence + ", deduplicationEnabled=" + this.deduplicationEnabled + ", autoTopicCreationOverride=" + this.autoTopicCreationOverride + ", autoSubscriptionCreationOverride=" + this.autoSubscriptionCreationOverride + ", publishMaxMessageRate=" + this.publishMaxMessageRate + ", latency_stats_sample_rate=" + this.latency_stats_sample_rate + ", message_ttl_in_seconds=" + this.message_ttl_in_seconds + ", subscription_expiration_time_minutes=" + this.subscription_expiration_time_minutes + ", retention_policies=" + this.retention_policies + ", deleted=" + this.deleted + ", encryption_required=" + this.encryption_required + ", delayed_delivery_policies=" + this.delayed_delivery_policies + ", inactive_topic_policies=" + this.inactive_topic_policies + ", subscription_auth_mode=" + (Object)((Object)this.subscription_auth_mode) + ", max_producers_per_topic=" + this.max_producers_per_topic + ", max_consumers_per_topic=" + this.max_consumers_per_topic + ", max_consumers_per_subscription=" + this.max_consumers_per_subscription + ", max_unacked_messages_per_consumer=" + this.max_unacked_messages_per_consumer + ", max_unacked_messages_per_subscription=" + this.max_unacked_messages_per_subscription + ", max_subscriptions_per_topic=" + this.max_subscriptions_per_topic + ", compaction_threshold=" + this.compaction_threshold + ", offload_threshold=" + this.offload_threshold + ", offload_threshold_in_seconds=" + this.offload_threshold_in_seconds + ", offload_deletion_lag_ms=" + this.offload_deletion_lag_ms + ", max_topics_per_namespace=" + this.max_topics_per_namespace + ", schema_auto_update_compatibility_strategy=" + (Object)((Object)this.schema_auto_update_compatibility_strategy) + ", schema_compatibility_strategy=" + (Object)((Object)this.schema_compatibility_strategy) + ", is_allow_auto_update_schema=" + this.is_allow_auto_update_schema + ", schema_validation_enforced=" + this.schema_validation_enforced + ", offload_policies=" + this.offload_policies + ", deduplicationSnapshotIntervalSeconds=" + this.deduplicationSnapshotIntervalSeconds + ", subscription_types_enabled=" + this.subscription_types_enabled + ", properties=" + this.properties + ", resource_group_name=" + this.resource_group_name + ", migrated=" + this.migrated + ", dispatcherPauseOnAckStatePersistentEnabled=" + this.dispatcherPauseOnAckStatePersistentEnabled + ", entryFilters=" + this.entryFilters + ")";
    }

    public static enum BundleType {
        LARGEST,
        HOT;

    }
}

