/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import io.netty.channel.EventLoopGroup;
import io.opentelemetry.api.common.Attributes;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.impl.HttpClient;
import org.apache.pulsar.client.impl.LookupService;
import org.apache.pulsar.client.impl.LookupTopicResult;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.impl.metrics.InstrumentProvider;
import org.apache.pulsar.client.impl.metrics.LatencyHistogram;
import org.apache.pulsar.client.impl.schema.SchemaInfoUtil;
import org.apache.pulsar.client.impl.schema.SchemaUtils;
import org.apache.pulsar.common.api.proto.CommandGetTopicsOfNamespace;
import org.apache.pulsar.common.lookup.GetTopicsResult;
import org.apache.pulsar.common.lookup.data.LookupData;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.protocol.schema.GetSchemaResponse;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpLookupService
implements LookupService {
    private final HttpClient httpClient;
    private final boolean useTls;
    private final String listenerName;
    private static final String BasePathV1 = "lookup/v2/destination/";
    private static final String BasePathV2 = "lookup/v2/topic/";
    private final LatencyHistogram histoGetBroker;
    private final LatencyHistogram histoGetTopicMetadata;
    private final LatencyHistogram histoGetSchema;
    private final LatencyHistogram histoListTopics;
    private static final Logger log = LoggerFactory.getLogger(HttpLookupService.class);

    public HttpLookupService(InstrumentProvider instrumentProvider, ClientConfigurationData conf, EventLoopGroup eventLoopGroup) throws PulsarClientException {
        this.httpClient = new HttpClient(conf, eventLoopGroup);
        this.useTls = conf.isUseTls();
        this.listenerName = conf.getListenerName();
        LatencyHistogram histo = instrumentProvider.newLatencyHistogram("pulsar.client.lookup.duration", "Duration of lookup operations", null, Attributes.builder().put("pulsar.lookup.transport-type", "http").build());
        this.histoGetBroker = histo.withAttributes(Attributes.builder().put("pulsar.lookup.type", "topic").build());
        this.histoGetTopicMetadata = histo.withAttributes(Attributes.builder().put("pulsar.lookup.type", "metadata").build());
        this.histoGetSchema = histo.withAttributes(Attributes.builder().put("pulsar.lookup.type", "schema").build());
        this.histoListTopics = histo.withAttributes(Attributes.builder().put("pulsar.lookup.type", "list-topics").build());
    }

    @Override
    public void updateServiceUrl(String serviceUrl) throws PulsarClientException {
        this.httpClient.setServiceUrl(serviceUrl);
    }

    @Override
    public CompletableFuture<LookupTopicResult> getBroker(TopicName topicName) {
        String basePath = topicName.isV2() ? BasePathV2 : BasePathV1;
        String path = basePath + topicName.getLookupName();
        path = StringUtils.isBlank((CharSequence)this.listenerName) ? path : path + "?listenerName=" + Codec.encode((String)this.listenerName);
        long startTime = System.nanoTime();
        CompletableFuture<LookupData> httpFuture = this.httpClient.get(path, LookupData.class);
        ((CompletableFuture)httpFuture.thenRun(() -> this.histoGetBroker.recordSuccess(System.nanoTime() - startTime))).exceptionally(x -> {
            this.histoGetBroker.recordFailure(System.nanoTime() - startTime);
            return null;
        });
        return httpFuture.thenCompose(lookupData -> {
            URI uri = null;
            try {
                if (this.useTls) {
                    uri = new URI(lookupData.getBrokerUrlTls());
                } else {
                    String serviceUrl = lookupData.getBrokerUrl();
                    if (serviceUrl == null) {
                        serviceUrl = lookupData.getNativeUrl();
                    }
                    uri = new URI(serviceUrl);
                }
                InetSocketAddress brokerAddress = InetSocketAddress.createUnresolved(uri.getHost(), uri.getPort());
                return CompletableFuture.completedFuture(new LookupTopicResult(brokerAddress, brokerAddress, false));
            }
            catch (Exception e) {
                log.warn("[{}] Lookup Failed due to invalid url {}, {}", new Object[]{topicName, uri, e.getMessage()});
                return FutureUtil.failedFuture((Throwable)e);
            }
        });
    }

    @Override
    public CompletableFuture<PartitionedTopicMetadata> getPartitionedTopicMetadata(TopicName topicName) {
        long startTime = System.nanoTime();
        String format = topicName.isV2() ? "admin/v2/%s/partitions" : "admin/%s/partitions";
        CompletableFuture<PartitionedTopicMetadata> httpFuture = this.httpClient.get(String.format(format, topicName.getLookupName()) + "?checkAllowAutoCreation=true", PartitionedTopicMetadata.class);
        ((CompletableFuture)httpFuture.thenRun(() -> this.histoGetTopicMetadata.recordSuccess(System.nanoTime() - startTime))).exceptionally(x -> {
            this.histoGetTopicMetadata.recordFailure(System.nanoTime() - startTime);
            return null;
        });
        return httpFuture;
    }

    @Override
    public String getServiceUrl() {
        return this.httpClient.getServiceUrl();
    }

    @Override
    public InetSocketAddress resolveHost() {
        return this.httpClient.resolveHost();
    }

    @Override
    public CompletableFuture<GetTopicsResult> getTopicsUnderNamespace(NamespaceName namespace, CommandGetTopicsOfNamespace.Mode mode, String topicsPattern, String topicsHash) {
        long startTime = System.nanoTime();
        CompletableFuture<GetTopicsResult> future = new CompletableFuture<GetTopicsResult>();
        String format = namespace.isV2() ? "admin/v2/namespaces/%s/topics?mode=%s" : "admin/namespaces/%s/destinations?mode=%s";
        ((CompletableFuture)this.httpClient.get(String.format(format, namespace, mode.toString()), String[].class).thenAccept(topics -> future.complete(new GetTopicsResult(topics)))).exceptionally(ex -> {
            Throwable cause = FutureUtil.unwrapCompletionException((Throwable)ex);
            log.warn("Failed to getTopicsUnderNamespace namespace {} {}.", (Object)namespace, (Object)cause.getMessage());
            future.completeExceptionally(cause);
            return null;
        });
        ((CompletableFuture)future.thenRun(() -> this.histoListTopics.recordSuccess(System.nanoTime() - startTime))).exceptionally(x -> {
            this.histoListTopics.recordFailure(System.nanoTime() - startTime);
            return null;
        });
        return future;
    }

    @Override
    public CompletableFuture<Optional<SchemaInfo>> getSchema(TopicName topicName) {
        return this.getSchema(topicName, null);
    }

    @Override
    public CompletableFuture<Optional<SchemaInfo>> getSchema(TopicName topicName, byte[] version) {
        long startTime = System.nanoTime();
        CompletableFuture<Optional<SchemaInfo>> future = new CompletableFuture<Optional<SchemaInfo>>();
        String schemaName = topicName.getSchemaName();
        String path = String.format("admin/v2/schemas/%s/schema", schemaName);
        if (version != null) {
            if (version.length == 0) {
                future.completeExceptionally((Throwable)new SchemaSerializationException("Empty schema version"));
                return future;
            }
            path = String.format("admin/v2/schemas/%s/schema/%s", schemaName, ByteBuffer.wrap(version).getLong());
        }
        ((CompletableFuture)this.httpClient.get(path, GetSchemaResponse.class).thenAccept(response -> {
            if (response.getType() == SchemaType.KEY_VALUE) {
                SchemaData data = SchemaData.builder().data(SchemaUtils.convertKeyValueDataStringToSchemaInfoSchema((byte[])response.getData().getBytes(StandardCharsets.UTF_8))).type(response.getType()).props(response.getProperties()).build();
                future.complete(Optional.of(SchemaInfoUtil.newSchemaInfo(schemaName, data)));
            } else {
                future.complete(Optional.of(SchemaInfoUtil.newSchemaInfo(schemaName, response)));
            }
        })).exceptionally(ex -> {
            Throwable cause = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (cause instanceof PulsarClientException.NotFoundException) {
                future.complete(Optional.empty());
            } else {
                log.warn("Failed to get schema for topic {} version {}", new Object[]{topicName, version != null ? Base64.getEncoder().encodeToString(version) : null, cause});
                future.completeExceptionally(cause);
            }
            return null;
        });
        ((CompletableFuture)future.thenRun(() -> this.histoGetSchema.recordSuccess(System.nanoTime() - startTime))).exceptionally(x -> {
            this.histoGetSchema.recordFailure(System.nanoTime() - startTime);
            return null;
        });
        return future;
    }

    @Override
    public void close() throws Exception {
        this.httpClient.close();
    }
}

