/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZookeeperBkClientFactoryImpl;
import org.apache.pulsar.zookeeper.ZookeeperServerTest;
import org.apache.zookeeper.ZooKeeper;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ZookeeperBkClientFactoryImplTest {
    private ZookeeperServerTest localZkS;
    private ZooKeeper localZkc;
    private final long ZOOKEEPER_SESSION_TIMEOUT_MILLIS = 1000L;
    private OrderedScheduler executor;

    @BeforeMethod
    void setup() throws Exception {
        this.executor = OrderedScheduler.newSchedulerBuilder().build();
        this.localZkS = new ZookeeperServerTest(0);
        this.localZkS.start();
    }

    @AfterMethod
    void teardown() throws Exception {
        this.localZkS.close();
        this.executor.shutdown();
    }

    @Test
    public void testZKCreationRW() throws Exception {
        ZookeeperBkClientFactoryImpl zkf = new ZookeeperBkClientFactoryImpl((OrderedExecutor)this.executor);
        CompletableFuture zkFuture = zkf.create("127.0.0.1:" + this.localZkS.getZookeeperPort(), ZooKeeperClientFactory.SessionType.ReadWrite, 1000);
        this.localZkc = (ZooKeeper)zkFuture.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)this.localZkc.getState().isConnected());
        Assert.assertNotEquals((Object)this.localZkc.getState(), (Object)ZooKeeper.States.CONNECTEDREADONLY);
        this.localZkc.close();
    }

    @Test
    public void testZKCreationRO() throws Exception {
        ZookeeperBkClientFactoryImpl zkf = new ZookeeperBkClientFactoryImpl((OrderedExecutor)this.executor);
        CompletableFuture zkFuture = zkf.create("127.0.0.1:" + this.localZkS.getZookeeperPort(), ZooKeeperClientFactory.SessionType.AllowReadOnly, 1000);
        this.localZkc = (ZooKeeper)zkFuture.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)this.localZkc.getState().isConnected());
        this.localZkc.close();
    }

    @Test
    public void testZKCreationFailure() throws Exception {
        ZookeeperBkClientFactoryImpl zkf = new ZookeeperBkClientFactoryImpl((OrderedExecutor)this.executor);
        CompletableFuture zkFuture = zkf.create("invalid", ZooKeeperClientFactory.SessionType.ReadWrite, 1000);
        try {
            zkFuture.get();
            Assert.fail((String)"Creation should have failed");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }
}

