/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import org.apache.pulsar.zookeeper.LocalZooKeeperConnectionService;
import org.apache.pulsar.zookeeper.MockedZooKeeperClientFactoryImpl;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZooKeeperSessionWatcher;
import org.apache.pulsar.zookeeper.ZookeeperClientFactoryImpl;
import org.apache.pulsar.zookeeper.ZookeeperSessionExpiredHandler;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.ZooKeeper;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LocalZooKeeperConnectionServiceTest {
    @Test
    public void testSimpleZooKeeperConnection() throws Exception {
        MockedZooKeeperClientFactoryImpl mockZkClientFactory = new MockedZooKeeperClientFactoryImpl();
        LocalZooKeeperConnectionService localZkConnectionService = new LocalZooKeeperConnectionService((ZooKeeperClientFactory)mockZkClientFactory, "dummy", 1000L);
        localZkConnectionService.start(new ZookeeperSessionExpiredHandler(){

            public void onSessionExpired() {
            }

            public void setWatcher(ZooKeeperSessionWatcher watcher) {
            }
        });
        MockZooKeeper zk = (MockZooKeeper)localZkConnectionService.getLocalZooKeeper();
        Assert.assertTrue((boolean)zk.getState().isConnected());
        LocalZooKeeperConnectionService.checkAndCreatePersistNode((ZooKeeper)zk, (String)"/path1");
        Assert.assertNotNull((Object)zk.exists("/path1", false));
        zk.setSessionId(-1L);
        LocalZooKeeperConnectionService.createIfAbsent((ZooKeeper)zk, (String)"/path1", (String)"data1", (CreateMode)CreateMode.EPHEMERAL, (boolean)true);
        Assert.assertEquals((byte[])zk.getData("/path1", null, null), (byte[])"data1".getBytes());
        LocalZooKeeperConnectionService.checkAndCreatePersistNode((ZooKeeper)zk, (String)"/path1");
        Assert.assertNotNull((Object)zk.exists("/path1", false));
        LocalZooKeeperConnectionService.createIfAbsent((ZooKeeper)zk, (String)"/path2", (String)"data2", (CreateMode)CreateMode.EPHEMERAL);
        Assert.assertNotNull((Object)zk.exists("/path2", false));
        Assert.assertEquals((byte[])zk.getData("/path2", null, null), (byte[])"data2".getBytes());
        LocalZooKeeperConnectionService.createIfAbsent((ZooKeeper)zk, (String)"/path3", (byte[])"data3".getBytes(), (CreateMode)CreateMode.EPHEMERAL);
        Assert.assertNotNull((Object)zk.exists("/path3", false));
        Assert.assertEquals((byte[])zk.getData("/path3", null, null), (byte[])"data3".getBytes());
        LocalZooKeeperConnectionService.deleteIfExists((ZooKeeper)zk, (String)"/path1", (int)-1);
        Assert.assertNull((Object)zk.exists("/path1", false));
        LocalZooKeeperConnectionService.deleteIfExists((ZooKeeper)zk, (String)"/path2", (int)-1);
        Assert.assertNull((Object)zk.exists("/path2", false));
        LocalZooKeeperConnectionService.deleteIfExists((ZooKeeper)zk, (String)"/path3", (int)-1);
        Assert.assertNull((Object)zk.exists("/path3", false));
        LocalZooKeeperConnectionService.deleteIfExists((ZooKeeper)zk, (String)"/not_exist", (int)-1);
        LocalZooKeeperConnectionService.checkAndCreatePersistNode((ZooKeeper)zk, (String)"/////");
        Assert.assertNull((Object)zk.exists("//////", false));
        localZkConnectionService.close();
        mockZkClientFactory.close();
    }

    @Test
    public void testSimpleZooKeeperConnectionFail() throws Exception {
        LocalZooKeeperConnectionService localZkConnectionService = new LocalZooKeeperConnectionService((ZooKeeperClientFactory)new ZookeeperClientFactoryImpl(), "dummy", 1000L);
        try {
            localZkConnectionService.start(new ZookeeperSessionExpiredHandler(){

                public void onSessionExpired() {
                }

                public void setWatcher(ZooKeeperSessionWatcher watcher) {
                }
            });
            Assert.fail((String)"should fail");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Failed to establish session with local ZK"));
        }
        localZkConnectionService.close();
    }
}

