/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZookeeperClientFactoryImpl;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.ZooKeeper;

public class MockedZooKeeperClientFactoryImpl
implements ZooKeeperClientFactory {
    Queue<MockZooKeeper> createdInstances = new ConcurrentLinkedQueue<MockZooKeeper>();

    public CompletableFuture<ZooKeeper> create(String serverList, ZooKeeperClientFactory.SessionType sessionType, int zkSessionTimeoutMillis) {
        MockZooKeeper mockZooKeeper = MockZooKeeper.newInstance();
        this.createdInstances.add(mockZooKeeper);
        ArrayList dummyAclList = new ArrayList(0);
        try {
            ZkUtils.createFullPathOptimistic((ZooKeeper)mockZooKeeper, (String)"/ledgers/available/192.168.1.1:5000", (byte[])"".getBytes(ZookeeperClientFactoryImpl.ENCODING_SCHEME), dummyAclList, (CreateMode)CreateMode.PERSISTENT);
            mockZooKeeper.create("/ledgers/LAYOUT", "1\nflat:1".getBytes(ZookeeperClientFactoryImpl.ENCODING_SCHEME), dummyAclList, CreateMode.PERSISTENT);
            return CompletableFuture.completedFuture(mockZooKeeper);
        }
        catch (InterruptedException | KeeperException e) {
            CompletableFuture<ZooKeeper> future = new CompletableFuture<ZooKeeper>();
            future.completeExceptionally(e);
            return future;
        }
    }

    public void close() {
        this.createdInstances.forEach(zk -> {
            try {
                zk.shutdown();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
    }
}

