/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.commons.configuration.Configuration;
import org.apache.pulsar.common.policies.data.BookieInfo;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.zookeeper.ZkBookieRackAffinityMapping;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZookeeperServerTest;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ZkBookieRackAffinityMappingTest {
    private BookieSocketAddress BOOKIE1 = null;
    private BookieSocketAddress BOOKIE2 = null;
    private BookieSocketAddress BOOKIE3 = null;
    private ZookeeperServerTest localZkS;
    private ZooKeeper localZkc;
    private final ObjectMapper jsonMapper = ObjectMapperFactory.create();

    @BeforeMethod
    public void setUp() throws Exception {
        this.localZkS = new ZookeeperServerTest(0);
        this.localZkS.start();
        this.localZkc = ZooKeeperClient.newBuilder().connectString("127.0.0.1:" + this.localZkS.getZookeeperPort()).build();
        this.BOOKIE1 = new BookieSocketAddress("127.0.0.1:3181");
        this.BOOKIE2 = new BookieSocketAddress("127.0.0.2:3181");
        this.BOOKIE3 = new BookieSocketAddress("127.0.0.3:3181");
    }

    @AfterMethod
    void teardown() throws Exception {
        this.localZkS.close();
    }

    @Test
    public void testBasic() throws Exception {
        String data = "{\"group1\": {\"" + this.BOOKIE1 + "\": {\"rack\": \"/rack0\", \"hostname\": \"bookie1.example.com\"}, \"" + this.BOOKIE2 + "\": {\"rack\": \"/rack1\", \"hostname\": \"bookie2.example.com\"}}}";
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.localZkc, (String)"/bookies", (byte[])data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        ZkBookieRackAffinityMapping mapping1 = new ZkBookieRackAffinityMapping();
        ClientConfiguration bkClientConf1 = new ClientConfiguration();
        bkClientConf1.setProperty("zk_cache_instance", (Object)new ZooKeeperCache("test", this.localZkc, 30){});
        mapping1.setConf((Configuration)bkClientConf1);
        List racks1 = mapping1.resolve((List)Lists.newArrayList((Object[])new String[]{this.BOOKIE1.getHostName(), this.BOOKIE2.getHostName(), this.BOOKIE3.getHostName()}));
        Assert.assertEquals((String)((String)racks1.get(0)), (String)"/rack0");
        Assert.assertEquals((String)((String)racks1.get(1)), (String)"/rack1");
        Assert.assertEquals((String)((String)racks1.get(2)), null);
        ZkBookieRackAffinityMapping mapping2 = new ZkBookieRackAffinityMapping();
        ClientConfiguration bkClientConf2 = new ClientConfiguration();
        bkClientConf2.setZkServers("127.0.0.1:" + this.localZkS.getZookeeperPort());
        bkClientConf2.setZkTimeout(1000);
        mapping2.setConf((Configuration)bkClientConf2);
        List racks2 = mapping2.resolve((List)Lists.newArrayList((Object[])new String[]{this.BOOKIE1.getHostName(), this.BOOKIE2.getHostName(), this.BOOKIE3.getHostName()}));
        Assert.assertEquals((String)((String)racks2.get(0)), (String)"/rack0");
        Assert.assertEquals((String)((String)racks2.get(1)), (String)"/rack1");
        Assert.assertEquals((String)((String)racks2.get(2)), null);
        this.localZkc.delete("/bookies", -1);
    }

    @Test
    public void testInvalidRackName() throws Exception {
        String data = "{\"group1\": {\"" + this.BOOKIE1 + "\": {\"rack\": \"/\", \"hostname\": \"bookie1.example.com\"}, \"" + this.BOOKIE2 + "\": {\"rack\": \"\", \"hostname\": \"bookie2.example.com\"}}}";
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.localZkc, (String)"/bookies", (byte[])data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        ZkBookieRackAffinityMapping mapping1 = new ZkBookieRackAffinityMapping();
        ClientConfiguration bkClientConf1 = new ClientConfiguration();
        bkClientConf1.setProperty("zk_cache_instance", (Object)new ZooKeeperCache("test", this.localZkc, 30){});
        mapping1.setConf((Configuration)bkClientConf1);
        List racks1 = mapping1.resolve((List)Lists.newArrayList((Object[])new String[]{this.BOOKIE1.getHostName(), this.BOOKIE2.getHostName(), this.BOOKIE3.getHostName()}));
        AssertJUnit.assertNull(racks1.get(0));
        AssertJUnit.assertNull(racks1.get(1));
        AssertJUnit.assertNull(racks1.get(2));
    }

    @Test
    public void testNoBookieInfo() throws Exception {
        ZkBookieRackAffinityMapping mapping = new ZkBookieRackAffinityMapping();
        ClientConfiguration bkClientConf = new ClientConfiguration();
        bkClientConf.setProperty("zk_cache_instance", (Object)new ZooKeeperCache("test", this.localZkc, 30){});
        mapping.setConf((Configuration)bkClientConf);
        List racks = mapping.resolve((List)Lists.newArrayList((Object[])new String[]{"127.0.0.1", "127.0.0.2", "127.0.0.3"}));
        Assert.assertEquals((String)((String)racks.get(0)), null);
        Assert.assertEquals((String)((String)racks.get(1)), null);
        Assert.assertEquals((String)((String)racks.get(2)), null);
        HashMap bookieMapping = new HashMap();
        HashMap<BookieSocketAddress, BookieInfo> mainBookieGroup = new HashMap<BookieSocketAddress, BookieInfo>();
        mainBookieGroup.put(this.BOOKIE1, new BookieInfo("/rack0", null));
        mainBookieGroup.put(this.BOOKIE2, new BookieInfo("/rack1", null));
        bookieMapping.put("group1", mainBookieGroup);
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.localZkc, (String)"/bookies", (byte[])this.jsonMapper.writeValueAsBytes(bookieMapping), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        Thread.sleep(100L);
        racks = mapping.resolve((List)Lists.newArrayList((Object[])new String[]{"127.0.0.1", "127.0.0.2", "127.0.0.3"}));
        Assert.assertEquals((String)((String)racks.get(0)), (String)"/rack0");
        Assert.assertEquals((String)((String)racks.get(1)), (String)"/rack1");
        Assert.assertEquals((String)((String)racks.get(2)), null);
        this.localZkc.delete("/bookies", -1);
    }

    @Test
    public void testBookieInfoChange() throws Exception {
        HashMap bookieMapping = new HashMap();
        HashMap<BookieSocketAddress, BookieInfo> mainBookieGroup = new HashMap<BookieSocketAddress, BookieInfo>();
        mainBookieGroup.put(this.BOOKIE1, new BookieInfo("rack0", null));
        mainBookieGroup.put(this.BOOKIE2, new BookieInfo("rack1", null));
        bookieMapping.put("group1", mainBookieGroup);
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.localZkc, (String)"/bookies", (byte[])this.jsonMapper.writeValueAsBytes(bookieMapping), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        ZkBookieRackAffinityMapping mapping = new ZkBookieRackAffinityMapping();
        ClientConfiguration bkClientConf = new ClientConfiguration();
        bkClientConf.setProperty("zk_cache_instance", (Object)new ZooKeeperCache("test", this.localZkc, 30){});
        mapping.setConf((Configuration)bkClientConf);
        List racks = mapping.resolve((List)Lists.newArrayList((Object[])new String[]{this.BOOKIE1.getHostName(), this.BOOKIE2.getHostName(), this.BOOKIE3.getHostName()}));
        Assert.assertEquals((String)((String)racks.get(0)), (String)"/rack0");
        Assert.assertEquals((String)((String)racks.get(1)), (String)"/rack1");
        Assert.assertEquals((String)((String)racks.get(2)), null);
        HashMap<BookieSocketAddress, BookieInfo> secondaryBookieGroup = new HashMap<BookieSocketAddress, BookieInfo>();
        secondaryBookieGroup.put(this.BOOKIE3, new BookieInfo("rack0", null));
        bookieMapping.put("group2", secondaryBookieGroup);
        this.localZkc.setData("/bookies", this.jsonMapper.writeValueAsBytes(bookieMapping), -1);
        Thread.sleep(100L);
        racks = mapping.resolve((List)Lists.newArrayList((Object[])new String[]{"127.0.0.1", "127.0.0.2", "127.0.0.3"}));
        Assert.assertEquals((String)((String)racks.get(0)), (String)"/rack0");
        Assert.assertEquals((String)((String)racks.get(1)), (String)"/rack1");
        Assert.assertEquals((String)((String)racks.get(2)), (String)"/rack0");
        this.localZkc.setData("/bookies", "{}".getBytes(), -1);
        Thread.sleep(100L);
        racks = mapping.resolve((List)Lists.newArrayList((Object[])new String[]{"127.0.0.1", "127.0.0.2", "127.0.0.3"}));
        Assert.assertEquals((String)((String)racks.get(0)), null);
        Assert.assertEquals((String)((String)racks.get(1)), null);
        Assert.assertEquals((String)((String)racks.get(2)), null);
    }
}

