/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import org.apache.pulsar.zookeeper.ZkUtils;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ZkUtilsParentPathTest {
    @DataProvider(name="pathsAndParents")
    public static Object[][] pathsAndParents() {
        return new Object[][]{{null, null}, {"", null}, {"/", null}, {"//", null}, {"///", null}, {"a", null}, {"a/", null}, {"a//", null}, {"a///", null}, {"/a", "/"}, {"//a", "/"}, {"///a", "/"}, {"/a/", "/"}, {"/a//", "/"}, {"/a///", "/"}, {"//a/", "/"}, {"//a//", "/"}, {"//a///", "/"}, {"///a/", "/"}, {"///a//", "/"}, {"///a///", "/"}, {"/a/b", "/a"}, {"//a/b", "/a"}, {"///a/b", "/a"}, {"/a//b", "/a"}, {"/a///b", "/a"}, {"/a/b/", "/a"}, {"/a/b//", "/a"}, {"/a/b///", "/a"}, {"/a//b/", "/a"}, {"/a///b/", "/a"}, {"a/b", "a"}, {"a//b", "a"}, {"a///b", "a"}, {"a/b/", "a"}, {"a/b//", "a"}, {"a/b///", "a"}, {"a//b/", "a"}, {"a///b/", "a"}, {"/a/b/c", "/a/b"}, {"//a/b/c", "/a/b"}, {"///a/b/c", "/a/b"}, {"/a//b/c", "/a/b"}, {"/a///b/c", "/a/b"}, {"/a/b//c", "/a/b"}, {"/a/b///c", "/a/b"}, {"/a//b//c/", "/a/b"}, {"/a//b///c/", "/a/b"}, {"/a///b//c/", "/a/b"}, {"/a///b///c/", "/a/b"}, {"/a/b/c/", "/a/b"}, {"/a/b//c/", "/a/b"}, {"/a/b///c/", "/a/b"}, {"a/b/c", "a/b"}, {"a//b/c", "a/b"}, {"a///b/c", "a/b"}, {"abc", null}, {"abc/", null}, {"/abc", "/"}, {"/abc/", "/"}, {"/abc/def", "/abc"}, {"/abc/def/", "/abc"}, {"abc/def", "abc"}, {"abc/def/", "abc"}, {"/abc/def/ghi", "/abc/def"}, {"/abc/def/ghi/", "/abc/def"}, {"abc/def/ghi", "abc/def"}, {"abc/def/ghi/", "abc/def"}};
    }

    @Test(dataProvider="pathsAndParents")
    public void testGetParentForPath(String path, String expectedParent) {
        Assert.assertEquals((String)ZkUtils.getParentForPath((String)path), (String)expectedParent, (String)("Parent for " + path));
    }
}

