/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import org.apache.pulsar.zookeeper.ZooKeeperSessionWatcher;
import org.apache.pulsar.zookeeper.ZookeeperSessionExpiredHandler;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ZooKeeperSessionWatcherTest {
    private MockZooKeeper zkClient;
    private MockShutdownService shutdownService;
    private ZooKeeperSessionWatcher sessionWatcher;

    @BeforeMethod
    void setup() {
        this.zkClient = MockZooKeeper.newInstance();
        this.shutdownService = new MockShutdownService();
        this.sessionWatcher = new ZooKeeperSessionWatcher((ZooKeeper)this.zkClient, 1000L, new ZookeeperSessionExpiredHandler(){
            private ZooKeeperSessionWatcher watcher;

            public void onSessionExpired() {
                this.watcher.close();
                ZooKeeperSessionWatcherTest.this.shutdownService.shutdown(-1);
            }

            public void setWatcher(ZooKeeperSessionWatcher watcher) {
                this.watcher = watcher;
            }
        });
    }

    @AfterMethod
    void teardown() throws Exception {
        this.sessionWatcher.close();
        this.zkClient.shutdown();
    }

    @Test
    public void testProcess1() {
        WatchedEvent event = new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null);
        this.sessionWatcher.process(event);
        Assert.assertTrue((boolean)this.sessionWatcher.isShutdownStarted());
        Assert.assertEquals((int)this.shutdownService.getExitCode(), (int)-1);
    }

    @Test
    public void testProcess2() {
        WatchedEvent event = new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null);
        this.sessionWatcher.process(event);
        Assert.assertFalse((boolean)this.sessionWatcher.isShutdownStarted());
        Assert.assertEquals((int)this.shutdownService.getExitCode(), (int)0);
    }

    @Test
    public void testProcess3() {
        WatchedEvent event = new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.Expired, null);
        this.sessionWatcher.process(event);
        Assert.assertFalse((boolean)this.sessionWatcher.isShutdownStarted());
        Assert.assertEquals((int)this.shutdownService.getExitCode(), (int)0);
    }

    @Test
    public void testProcessResultConnectionLoss() {
        this.sessionWatcher.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), null, null, null);
        Assert.assertEquals((Object)this.sessionWatcher.getKeeperState(), (Object)Watcher.Event.KeeperState.Disconnected);
    }

    @Test
    public void testProcessResultSessionExpired() {
        this.sessionWatcher.processResult(KeeperException.Code.SESSIONEXPIRED.intValue(), null, null, null);
        Assert.assertEquals((Object)this.sessionWatcher.getKeeperState(), (Object)Watcher.Event.KeeperState.Expired);
    }

    @Test
    public void testProcessResultOk() {
        this.sessionWatcher.processResult(KeeperException.Code.OK.intValue(), null, null, null);
        Assert.assertEquals((Object)this.sessionWatcher.getKeeperState(), (Object)Watcher.Event.KeeperState.SyncConnected);
    }

    @Test
    public void testProcessResultNoNode() {
        this.sessionWatcher.processResult(KeeperException.Code.NONODE.intValue(), null, null, null);
        Assert.assertEquals((Object)this.sessionWatcher.getKeeperState(), (Object)Watcher.Event.KeeperState.SyncConnected);
    }

    @Test
    void testRun1() throws Exception {
        ZooKeeperSessionWatcher sessionWatcherZkNull = new ZooKeeperSessionWatcher(null, 1000L, new ZookeeperSessionExpiredHandler(){
            private ZooKeeperSessionWatcher watcher;

            public void onSessionExpired() {
                this.watcher.close();
                ZooKeeperSessionWatcherTest.this.shutdownService.shutdown(-1);
            }

            public void setWatcher(ZooKeeperSessionWatcher watcher) {
                this.watcher = watcher;
            }
        });
        sessionWatcherZkNull.run();
        Assert.assertFalse((boolean)sessionWatcherZkNull.isShutdownStarted());
        Assert.assertEquals((Object)sessionWatcherZkNull.getKeeperState(), (Object)Watcher.Event.KeeperState.Disconnected);
        Assert.assertEquals((int)this.shutdownService.getExitCode(), (int)0);
        sessionWatcherZkNull.close();
    }

    @Test
    void testRun2() throws Exception {
        ZooKeeperSessionWatcher sessionWatcherZkNull = new ZooKeeperSessionWatcher(null, 0L, new ZookeeperSessionExpiredHandler(){
            private ZooKeeperSessionWatcher watcher;

            public void onSessionExpired() {
                this.watcher.close();
                ZooKeeperSessionWatcherTest.this.shutdownService.shutdown(-1);
            }

            public void setWatcher(ZooKeeperSessionWatcher watcher) {
                this.watcher = watcher;
            }
        });
        sessionWatcherZkNull.run();
        Assert.assertTrue((boolean)sessionWatcherZkNull.isShutdownStarted());
        Assert.assertEquals((Object)sessionWatcherZkNull.getKeeperState(), (Object)Watcher.Event.KeeperState.Disconnected);
        Assert.assertEquals((int)this.shutdownService.getExitCode(), (int)-1);
        sessionWatcherZkNull.close();
    }

    @Test
    public void testRun3() throws Exception {
        this.zkClient.shutdown();
        this.sessionWatcher.run();
        Assert.assertFalse((boolean)this.sessionWatcher.isShutdownStarted());
        Assert.assertEquals((Object)this.sessionWatcher.getKeeperState(), (Object)Watcher.Event.KeeperState.Disconnected);
        Assert.assertEquals((int)this.shutdownService.getExitCode(), (int)0);
    }

    @Test
    public void testRun4() throws Exception {
        this.sessionWatcher.run();
        Assert.assertFalse((boolean)this.sessionWatcher.isShutdownStarted());
        Assert.assertEquals((Object)this.sessionWatcher.getKeeperState(), (Object)Watcher.Event.KeeperState.SyncConnected);
        Assert.assertEquals((int)this.shutdownService.getExitCode(), (int)0);
    }

    @Test
    public void testRun5() throws Exception {
        this.zkClient.create("/", new byte[0], null, null);
        this.sessionWatcher.run();
        Assert.assertFalse((boolean)this.sessionWatcher.isShutdownStarted());
        Assert.assertEquals((Object)this.sessionWatcher.getKeeperState(), (Object)Watcher.Event.KeeperState.SyncConnected);
        Assert.assertEquals((int)this.shutdownService.getExitCode(), (int)0);
    }

    @Test
    public void testRun6() throws Exception {
        this.sessionWatcher.run();
        Assert.assertFalse((boolean)this.sessionWatcher.isShutdownStarted());
        Assert.assertEquals((Object)this.sessionWatcher.getKeeperState(), (Object)Watcher.Event.KeeperState.SyncConnected);
        Assert.assertEquals((int)this.shutdownService.getExitCode(), (int)0);
    }

    private class MockShutdownService
    implements ZooKeeperSessionWatcher.ShutdownService {
        private int exitCode = 0;

        private MockShutdownService() {
        }

        public void shutdown(int exitCode) {
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

