/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperClientFactoryImpl
implements ZooKeeperClientFactory {
    public static final Charset ENCODING_SCHEME = StandardCharsets.UTF_8;
    private static final Logger log = LoggerFactory.getLogger(ZookeeperClientFactoryImpl.class);

    @Override
    public CompletableFuture<ZooKeeper> create(String serverList, ZooKeeperClientFactory.SessionType sessionType, int zkSessionTimeoutMillis) {
        boolean canBeReadOnly = sessionType == ZooKeeperClientFactory.SessionType.AllowReadOnly;
        CompletableFuture<ZooKeeper> future = new CompletableFuture<ZooKeeper>();
        try {
            CompletableFuture internalFuture = new CompletableFuture();
            ZooKeeper zk = new ZooKeeper(serverList, zkSessionTimeoutMillis, event -> {
                if (event.getType() == Watcher.Event.EventType.None) {
                    switch (event.getState()) {
                        case ConnectedReadOnly: {
                            Preconditions.checkArgument((boolean)canBeReadOnly);
                        }
                        case SyncConnected: {
                            internalFuture.complete(null);
                            break;
                        }
                        case Expired: {
                            internalFuture.completeExceptionally(KeeperException.create((KeeperException.Code)KeeperException.Code.SESSIONEXPIRED));
                            break;
                        }
                        default: {
                            log.warn("Unexpected ZK event received: {}", (Object)event);
                        }
                    }
                }
            }, canBeReadOnly);
            ((CompletableFuture)internalFuture.thenRun(() -> {
                log.info("ZooKeeper session established: {}", (Object)zk);
                future.complete(zk);
            })).exceptionally(exception -> {
                log.error("Failed to establish ZooKeeper session: {}", (Object)exception.getMessage());
                future.completeExceptionally((Throwable)exception);
                return null;
            });
        }
        catch (IOException | IllegalArgumentException e) {
            future.completeExceptionally(e);
        }
        return future;
    }
}

