/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.functions;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.schema.GenericObject;
import org.apache.pulsar.client.api.schema.KeyValueSchema;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.functions.api.Context;
import org.apache.pulsar.functions.api.Function;
import org.apache.pulsar.functions.api.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveAvroFieldFunction
implements Function<GenericObject, Void> {
    private static final Logger log = LoggerFactory.getLogger(RemoveAvroFieldFunction.class);
    private static final String FIELD_TO_REMOVE = "age";

    public Void process(GenericObject genericObject, Context context) throws Exception {
        Schema avroSchema;
        org.apache.pulsar.client.api.Schema schema;
        Record currentRecord = context.getCurrentRecord();
        log.info("apply to {} {}", (Object)genericObject, genericObject.getNativeObject());
        log.info("record with schema {} version {} {}", new Object[]{currentRecord.getSchema(), ((Message)currentRecord.getMessage().get()).getSchemaVersion(), currentRecord});
        Object nativeObject = genericObject.getNativeObject();
        org.apache.pulsar.client.api.Schema outputSchema = schema = currentRecord.getSchema();
        Object outputObject = genericObject.getNativeObject();
        boolean someThingDone = false;
        if (schema instanceof KeyValueSchema && nativeObject instanceof KeyValue) {
            Schema avroSchema2;
            KeyValueSchema kvSchema = (KeyValueSchema)schema;
            org.apache.pulsar.client.api.Schema keySchema = kvSchema.getKeySchema();
            org.apache.pulsar.client.api.Schema valueSchema = kvSchema.getValueSchema();
            if (valueSchema.getSchemaInfo().getType() == SchemaType.AVRO && (avroSchema2 = (Schema)valueSchema.getNativeSchema().get()).getField(FIELD_TO_REMOVE) != null) {
                Schema.Parser parser = new Schema.Parser();
                Schema originalAvroSchema = parser.parse(avroSchema2.toString(false));
                Schema modified = Schema.createRecord((String)originalAvroSchema.getName(), (String)originalAvroSchema.getDoc(), (String)originalAvroSchema.getNamespace(), (boolean)originalAvroSchema.isError(), originalAvroSchema.getFields().stream().filter(f -> !f.name().equals(FIELD_TO_REMOVE)).map(f -> new Schema.Field(f.name(), f.schema(), f.doc(), f.defaultVal(), f.order())).collect(Collectors.toList()));
                KeyValue originalObject = (KeyValue)nativeObject;
                org.apache.pulsar.client.api.schema.GenericRecord value = (org.apache.pulsar.client.api.schema.GenericRecord)originalObject.getValue();
                GenericRecord genericRecord = (GenericRecord)value.getNativeObject();
                GenericData.Record newRecord = new GenericData.Record(modified);
                for (Schema.Field field : modified.getFields()) {
                    newRecord.put(field.name(), genericRecord.get(field.name()));
                }
                GenericDatumWriter writer = new GenericDatumWriter(modified);
                ByteArrayOutputStream oo = new ByteArrayOutputStream();
                BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)oo, null);
                writer.write((Object)newRecord, (Encoder)encoder);
                byte[] newValue = oo.toByteArray();
                org.apache.pulsar.client.api.Schema newValueSchema = org.apache.pulsar.client.api.Schema.NATIVE_AVRO((Object)modified);
                outputSchema = org.apache.pulsar.client.api.Schema.KeyValue((org.apache.pulsar.client.api.Schema)keySchema, (org.apache.pulsar.client.api.Schema)newValueSchema, (KeyValueEncodingType)kvSchema.getKeyValueEncodingType());
                outputObject = new KeyValue(originalObject.getKey(), (Object)newValue);
                someThingDone = true;
            }
        } else if (schema.getSchemaInfo().getType() == SchemaType.AVRO && (avroSchema = (Schema)schema.getNativeSchema().get()).getField(FIELD_TO_REMOVE) != null) {
            org.apache.pulsar.client.api.Schema newValueSchema;
            Schema.Parser parser = new Schema.Parser();
            Schema originalAvroSchema = parser.parse(avroSchema.toString(false));
            Schema modified = Schema.createRecord((String)originalAvroSchema.getName(), (String)originalAvroSchema.getDoc(), (String)originalAvroSchema.getNamespace(), (boolean)originalAvroSchema.isError(), originalAvroSchema.getFields().stream().filter(f -> !f.name().equals(FIELD_TO_REMOVE)).map(f -> new Schema.Field(f.name(), f.schema(), f.doc(), f.defaultVal(), f.order())).collect(Collectors.toList()));
            GenericRecord genericRecord = (GenericRecord)nativeObject;
            GenericData.Record newRecord = new GenericData.Record(modified);
            for (Schema.Field field : modified.getFields()) {
                newRecord.put(field.name(), genericRecord.get(field.name()));
            }
            GenericDatumWriter writer = new GenericDatumWriter(modified);
            ByteArrayOutputStream oo = new ByteArrayOutputStream();
            BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)oo, null);
            writer.write((Object)newRecord, (Encoder)encoder);
            outputSchema = newValueSchema = org.apache.pulsar.client.api.Schema.NATIVE_AVRO((Object)modified);
            outputObject = oo.toByteArray();
            someThingDone = true;
        }
        if (!someThingDone) {
            outputObject = (switch (currentRecord.getSchema().getSchemaInfo().getType()) {
                case SchemaType.AVRO, SchemaType.JSON, SchemaType.PROTOBUF_NATIVE -> true;
                default -> false;
            }) ? currentRecord.getValue() : nativeObject;
        }
        log.info("output {} schema {}", outputObject, (Object)outputSchema);
        context.newOutputMessage(context.getOutputTopic(), outputSchema).value(outputObject).send();
        return null;
    }
}

