/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload.jcloud.provider;

import java.io.Serializable;
import java.util.Map;

public class BlobStoreLocation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String providerName;
    private final String region;
    private final String bucket;
    private final String endpoint;

    public BlobStoreLocation(Map<String, String> metadata) {
        this.providerName = this.getProvider(metadata);
        this.region = this.getRegion(metadata);
        this.bucket = this.getBucket(metadata);
        this.endpoint = this.getEndpoint(metadata);
    }

    public String getProvider(Map<String, String> offloadDriverMetadata) {
        return offloadDriverMetadata.get("managedLedgerOffloadDriver");
    }

    public String getRegion(Map<String, String> offloadDriverMetadata) {
        return offloadDriverMetadata.getOrDefault("region", "");
    }

    public String getBucket(Map<String, String> offloadDriverMetadata) {
        return offloadDriverMetadata.get("bucket");
    }

    public String getEndpoint(Map<String, String> offloadDriverMetadata) {
        return offloadDriverMetadata.getOrDefault("serviceEndpoint", "");
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getRegion() {
        return this.region;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String toString() {
        return "BlobStoreLocation(providerName=" + this.getProviderName() + ", region=" + this.getRegion() + ", bucket=" + this.getBucket() + ", endpoint=" + this.getEndpoint() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlobStoreLocation)) {
            return false;
        }
        BlobStoreLocation other = (BlobStoreLocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$providerName = this.getProviderName();
        String other$providerName = other.getProviderName();
        if (this$providerName == null ? other$providerName != null : !this$providerName.equals(other$providerName)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        return !(this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlobStoreLocation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $providerName = this.getProviderName();
        result = result * 59 + ($providerName == null ? 43 : $providerName.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        return result;
    }
}

