"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const lit_element_1 = require("lit-element");
const mutation_testing_metrics_1 = require("mutation-testing-metrics");
const style_1 = require("../../style");
const router_1 = require("../../lib/router");
let MutationTestReportAppComponent = class MutationTestReportAppComponent extends lit_element_1.LitElement {
    constructor() {
        super(...arguments);
        this.path = [];
        this.subscriptions = [];
    }
    get title() {
        if (this.context) {
            if (this.titlePostfix) {
                return `${this.context.name} - ${this.titlePostfix}`;
            }
            else {
                return this.context.name;
            }
        }
        else {
            return '';
        }
    }
    loadData() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.src) {
                try {
                    const res = yield fetch(this.src);
                    this.report = yield res.json();
                }
                catch (error) {
                    const e = error.toString();
                    this.errorMessage = e;
                }
            }
        });
    }
    updated(changedProperties) {
        if ((changedProperties.has('path') || changedProperties.has('report')) && this.report) {
            this.updateModel(this.report);
            this.updateContext();
            this.updateTitle();
        }
        if (changedProperties.has('src')) {
            this.loadData();
        }
    }
    updateModel(report) {
        this.rootModel = mutation_testing_metrics_1.calculateMetrics(report.files);
    }
    updateContext() {
        if (this.rootModel) {
            // Find the current selected file/directory based on the path
            this.context = this.path.reduce((model, currentPathPart) => model && model.childResults.find(child => child.name === currentPathPart), this.rootModel);
        }
    }
    updateTitle() {
        document.title = this.title;
    }
    connectedCallback() {
        super.connectedCallback();
        this.subscriptions.push(router_1.locationChange$.subscribe(path => this.path = path));
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.subscriptions.forEach(subscription => subscription.unsubscribe());
    }
    renderTitle() {
        const self = this;
        if (this.context) {
            if (this.titlePostfix) {
                return lit_element_1.html `<h1 class="display-4">${this.context.name}${renderPostfix()}</h1>`;
            }
        }
        return undefined;
        function renderPostfix() {
            if (self.titlePostfix) {
                return lit_element_1.html `<small class="text-muted"> - ${self.titlePostfix}</small>`;
            }
            else {
                return undefined;
            }
        }
    }
    render() {
        if (this.context || this.errorMessage) {
            return lit_element_1.html `<div class="container-fluid">
  <div class="row">
    <div class="col-md-12">
      ${this.renderReport()}
      ${this.renderErrorMessage()}
    </div>
  </div>
</div>`;
        }
        else {
            return lit_element_1.html ``;
        }
    }
    renderErrorMessage() {
        if (this.errorMessage) {
            return lit_element_1.html `
      <div class="alert alert-danger" role="alert">
        ${this.errorMessage}
      </div>
        `;
        }
        else {
            return lit_element_1.html ``;
        }
    }
    renderReport() {
        if (this.context) {
            return lit_element_1.html `
      ${this.renderTitle()}
      <mutation-test-report-breadcrumb .path="${this.path}"></mutation-test-report-breadcrumb>
      ${this.renderTotals()}
      ${this.renderFileReport()}`;
        }
        else {
            return undefined;
        }
    }
    renderFileReport() {
        if (this.context && this.report && this.context.file) {
            return lit_element_1.html `<mutation-test-report-file .model="${this.context.file}"></mutation-test-report-file>`;
        }
        else {
            return undefined;
        }
    }
    renderTotals() {
        if (this.report && this.context) {
            return lit_element_1.html `
    <div class='row'>
      <div class='totals col-sm-11'>
        <mutation-test-report-totals .currentPath="${this.path}" .thresholds="${this.report.thresholds}" .model="${this.context}">
        </mutation-test-report-totals>
      </div>
    </div>
    `;
        }
        else {
            return undefined;
        }
    }
};
MutationTestReportAppComponent.styles = [
    style_1.bootstrap,
    lit_element_1.unsafeCSS(require('./index.scss'))
];
__decorate([
    lit_element_1.property({ attribute: false })
], MutationTestReportAppComponent.prototype, "report", void 0);
__decorate([
    lit_element_1.property({ attribute: false })
], MutationTestReportAppComponent.prototype, "rootModel", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportAppComponent.prototype, "src", void 0);
__decorate([
    lit_element_1.property({ attribute: false })
], MutationTestReportAppComponent.prototype, "errorMessage", void 0);
__decorate([
    lit_element_1.property({ attribute: false })
], MutationTestReportAppComponent.prototype, "context", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportAppComponent.prototype, "path", void 0);
__decorate([
    lit_element_1.property({ attribute: 'title-postfix' })
], MutationTestReportAppComponent.prototype, "titlePostfix", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportAppComponent.prototype, "title", null);
MutationTestReportAppComponent = __decorate([
    lit_element_1.customElement('mutation-test-report-app')
], MutationTestReportAppComponent);
exports.MutationTestReportAppComponent = MutationTestReportAppComponent;
//# sourceMappingURL=index.js.map