"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const lit_element_1 = require("lit-element");
const unsafe_html_1 = require("lit-html/directives/unsafe-html");
const highlight_1 = __importDefault(require("highlight.js/lib/highlight"));
const javascript_1 = __importDefault(require("highlight.js/lib/languages/javascript"));
const scala_1 = __importDefault(require("highlight.js/lib/languages/scala"));
const java_1 = __importDefault(require("highlight.js/lib/languages/java"));
const cs_1 = __importDefault(require("highlight.js/lib/languages/cs"));
const typescript_1 = __importDefault(require("highlight.js/lib/languages/typescript"));
const mutation_test_report_mutant_1 = require("../mutation-test-report-mutant");
const style_1 = require("../../style");
const codeHelpers_1 = require("../../lib/codeHelpers");
const htmlHelpers_1 = require("../../lib/htmlHelpers");
highlight_1.default.registerLanguage('javascript', javascript_1.default);
highlight_1.default.registerLanguage('typescript', typescript_1.default);
highlight_1.default.registerLanguage('cs', cs_1.default);
highlight_1.default.registerLanguage('scala', scala_1.default);
highlight_1.default.registerLanguage('java', java_1.default);
let MutationTestReportFileComponent = class MutationTestReportFileComponent extends lit_element_1.LitElement {
    constructor() {
        super(...arguments);
        this.expandAll = () => {
            this.forEachMutantComponent(mutantComponent => mutantComponent.expand = true);
        };
        this.collapseAll = () => {
            this.forEachMutantComponent(mutantComponent => mutantComponent.expand = false);
        };
        this.filtersChanged = (event) => {
            const enabledMutantStates = event.detail
                .filter(mutantFilter => mutantFilter.enabled)
                .map(mutantFilter => mutantFilter.status);
            this.forEachMutantComponent(mutantComponent => {
                mutantComponent.show = enabledMutantStates.some(state => mutantComponent.mutant !== undefined && mutantComponent.mutant.status === state);
            });
        };
    }
    forEachMutantComponent(action, host = this.root) {
        for (const mutantComponent of host.querySelectorAll('mutation-test-report-mutant')) {
            if (mutantComponent instanceof mutation_test_report_mutant_1.MutationTestReportMutantComponent) {
                action(mutantComponent);
            }
        }
    }
    connectedCallback() {
        super.connectedCallback();
        this.addEventListener('click', () => {
            this.forEachMutantComponent(mutant => mutant.showPopup = false);
        });
        this.addEventListener('mutant-selected', (event) => {
            const selectedMutant = event.detail;
            this.forEachMutantComponent(mutant => mutant !== selectedMutant && (mutant.showPopup = false));
        });
        this.addEventListener(mutation_test_report_mutant_1.SHOW_MORE_EVENT, (event) => {
            const selectedMutant = event.detail;
            this.mutantInDialog = selectedMutant;
            event.stopPropagation();
        });
        this.addEventListener('close-dialog', () => {
            this.mutantInDialog = undefined;
        });
    }
    render() {
        if (this.model) {
            return lit_element_1.html `
        <div class="row">
          <div class="col-md-12">
            ${this.renderModalDialog()}
            <mutation-test-report-file-legend @filters-changed="${this.filtersChanged}" @expand-all="${this.expandAll}"
              @collapse-all="${this.collapseAll}" .mutants="${this.model.mutants}"></mutation-test-report-file-legend>
            <pre><code class="lang-${this.model.language} hljs">${unsafe_html_1.unsafeHTML(codeHelpers_1.renderCode(this.model))}</code></pre>
          </div>
        </div>
        `;
        }
        return undefined;
    }
    renderModalDialog() {
        if (this.mutantInDialog) {
            return lit_element_1.html `
          <div .hidden="${!this.mutantInDialog}" class="modal-backdrop show"></div>
          <mutation-test-report-modal-dialog ?show="${this.mutantInDialog}" header="${this.mutantInDialog.id}: ${this.mutantInDialog.mutatorName} - ${htmlHelpers_1.getEmojiForStatus(this.mutantInDialog.status)} ${this.mutantInDialog.status}">
            <p>${this.mutantInDialog.description}</p>
          </mutation-test-report-modal-dialog>
      `;
        }
        else {
            return undefined;
        }
    }
    firstUpdated(_changedProperties) {
        const code = this.root.querySelector('code');
        if (code) {
            highlight_1.default.highlightBlock(code);
            this.forEachMutantComponent(mutantComponent => {
                mutantComponent.mutant = this.model.mutants
                    .find(mutant => mutant.id.toString() === mutantComponent.getAttribute('mutant-id'));
            }, code);
        }
    }
    get root() {
        return this.shadowRoot || this;
    }
};
MutationTestReportFileComponent.styles = [
    style_1.highlightJS,
    style_1.bootstrap,
    lit_element_1.unsafeCSS(require('./index.scss'))
];
__decorate([
    lit_element_1.property()
], MutationTestReportFileComponent.prototype, "model", void 0);
__decorate([
    lit_element_1.property({ attribute: false })
], MutationTestReportFileComponent.prototype, "mutantInDialog", void 0);
MutationTestReportFileComponent = __decorate([
    lit_element_1.customElement('mutation-test-report-file')
], MutationTestReportFileComponent);
exports.MutationTestReportFileComponent = MutationTestReportFileComponent;
//# sourceMappingURL=index.js.map