"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
const lit_element_1 = require("lit-element");
const style_1 = require("../../style");
let MutationTestReportModalDialogComponent = class MutationTestReportModalDialogComponent extends lit_element_1.LitElement {
    constructor() {
        super(...arguments);
        this.show = false;
        this.emitCloseEvent = (event) => {
            this.dispatchEvent(new CustomEvent('close-dialog', { bubbles: true, detail: this, composed: true }));
            event.stopPropagation();
        };
    }
    render() {
        return lit_element_1.html `
    <div .hidden="${!this.show}" class="modal show" style="display: block;" tabindex="-1" role="dialog" @click="${this.emitCloseEvent}">
      <div class="modal-dialog" role="document" @click="${(e) => e.stopPropagation()}">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">${this.header}</h5>
          </div>
          <div class="modal-body">
            <slot></slot>
          </div>
          <div class="modal-footer">
            <button type="button" @click="${this.emitCloseEvent}" class="btn btn-link">Close</button>
          </div>
        </div>
      </div>
    </div>
    <slot></slot>
    `;
    }
};
MutationTestReportModalDialogComponent.styles = [
    style_1.bootstrap,
    lit_element_1.unsafeCSS(require('./index.scss'))
];
__decorate([
    lit_element_1.property({ converter: val => typeof val === 'string' })
], MutationTestReportModalDialogComponent.prototype, "show", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportModalDialogComponent.prototype, "header", void 0);
MutationTestReportModalDialogComponent = __decorate([
    lit_element_1.customElement('mutation-test-report-modal-dialog')
], MutationTestReportModalDialogComponent);
exports.MutationTestReportModalDialogComponent = MutationTestReportModalDialogComponent;
//# sourceMappingURL=index.js.map