"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
const lit_element_1 = require("lit-element");
const style_1 = require("../../style");
const htmlHelpers_1 = require("../../lib/htmlHelpers");
let MutationTestReportMutantComponent = class MutationTestReportMutantComponent extends lit_element_1.LitElement {
    constructor() {
        super(...arguments);
        this.show = true;
        this.expand = false;
        this.showPopup = false;
        this.mutantClicked = (event) => {
            this.expand = !this.expand;
            this.showPopup = this.expand;
            event.stopImmediatePropagation();
            this.dispatchEvent(new CustomEvent('mutant-selected', { bubbles: true, detail: this, composed: true }));
        };
        this.showMoreInfo = (mutant) => {
            this.dispatchEvent(new CustomEvent(exports.SHOW_MORE_EVENT, { bubbles: true, detail: mutant, composed: true }));
        };
    }
    render() {
        // This part is newline significant, as it is rendered in a <code> block.
        // No unnecessary new lines
        return lit_element_1.html `${this.renderButton()}${this.renderCode()}`;
    }
    renderButton() {
        if (this.show && this.mutant) {
            return lit_element_1.html `<mutation-test-report-popup ?show="${this.showPopup}" context="${htmlHelpers_1.getContextClassForStatus(this.mutant.status)}" header="${this.mutant.mutatorName}">${this.renderPopupBody(this.mutant)}<span class="mutant-toggle badge badge-${this.expand ? 'info' : htmlHelpers_1.getContextClassForStatus(this.mutant.status)}"
    @click="${this.mutantClicked}" title="${this.mutant.mutatorName}">${this.mutant.id}</span></mutation-test-report-popup>`;
        }
        return undefined;
    }
    renderPopupBody(mutant) {
        return lit_element_1.html `<div slot="popover-body"><span class="btn">${htmlHelpers_1.getEmojiForStatus(mutant.status)} ${mutant.status}</span>${this.renderDescription(mutant)}</div>`;
    }
    renderDescription(mutant) {
        if (mutant.description) {
            return lit_element_1.html `<button class="show-more btn btn-link" @click="${() => this.showMoreInfo(mutant)}">📖 Show more</button>`;
        }
        return undefined;
    }
    renderCode() {
        return lit_element_1.html `${this.renderReplacement()}${this.renderActual()}`;
    }
    renderActual() {
        const actualCodeSlot = lit_element_1.html `<slot></slot>`;
        return lit_element_1.html `<span class="original-code ${this.expand && this.show ? 'disabled-code' : ''}">${actualCodeSlot}</span>`;
    }
    renderReplacement() {
        if (this.mutant) {
            return lit_element_1.html `<span class="replacement badge badge-info" @click="${this.mutantClicked}" ?hidden="${!this.expand || !this.show}">${this.mutant.replacement || this.mutant.mutatorName}</span>`;
        }
        return undefined;
    }
};
MutationTestReportMutantComponent.styles = [
    style_1.bootstrap,
    lit_element_1.unsafeCSS(require('./index.scss'))
];
__decorate([
    lit_element_1.property()
], MutationTestReportMutantComponent.prototype, "mutant", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportMutantComponent.prototype, "show", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportMutantComponent.prototype, "expand", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportMutantComponent.prototype, "showPopup", void 0);
MutationTestReportMutantComponent = __decorate([
    lit_element_1.customElement('mutation-test-report-mutant')
], MutationTestReportMutantComponent);
exports.MutationTestReportMutantComponent = MutationTestReportMutantComponent;
exports.SHOW_MORE_EVENT = 'show-more-click';
//# sourceMappingURL=index.js.map