"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const lit_element_1 = require("lit-element");
const style_1 = require("../../style");
const svg = __importStar(require("../svg"));
const codeHelpers_1 = require("../../lib/codeHelpers");
const htmlHelpers_1 = require("../../lib/htmlHelpers");
let MutationTestReportTotalsComponent = class MutationTestReportTotalsComponent extends lit_element_1.LitElement {
    constructor() {
        super(...arguments);
        this.currentPath = [];
    }
    render() {
        if (this.model) {
            return lit_element_1.html `
          <table class="table table-sm table-hover table-bordered table-no-top">
            ${this.renderHead()}
            ${this.renderTableBody(this.model)}
          </table>
      `;
        }
        else {
            return undefined;
        }
    }
    renderHead() {
        return lit_element_1.html `<thead>
  <tr>
    <th colspan="2" style="width: 217px">
      <div><span>File / Directory</span></div>
    </th>
    <th colspan="2">
      <div><span>Mutation score</span></div>
    </th>
    <th class="rotate text-center" style="width: 50px">
      <div><span># Killed</span></div>
    </th>
    <th class="rotate text-center" style="width: 50px">
      <div><span># Survived</span></div>
    </th>
    <th class="rotate text-center" style="width: 50px">
      <div><span># Timeout</span></div>
    </th>
    <th class="rotate text-center" style="width: 50px">
      <div><span># No coverage</span></div>
    </th>
    <th class="rotate text-center" style="width: 50px">
      <div><span># Runtime errors</span></div>
    </th>
    <th class="rotate text-center" style="width: 50px">
      <div><span># Compile errors</span></div>
    </th>
    <th class="rotate rotate-width-70 text-center" style="width: 70px">
      <div><span>Total detected</span></div>
    </th>
    <th class="rotate rotate-width-70 text-center" style="width: 70px">
      <div><span>Total undetected</span></div>
    </th>
    <th class="rotate rotate-width-70 text-center" style="width: 70px">
      <div><span>Total mutants</span></div>
    </th>
  </tr>
</thead>`;
    }
    renderTableBody(model) {
        const renderChildren = () => {
            if (model.file) {
                return undefined;
            }
            else {
                return model.childResults.map(childResult => {
                    let fullName = childResult.name;
                    while (!childResult.file && childResult.childResults.length === 1) {
                        childResult = childResult.childResults[0];
                        fullName = codeHelpers_1.pathJoin(fullName, childResult.name);
                    }
                    return this.renderRow(fullName, childResult, codeHelpers_1.pathJoin(...this.currentPath, fullName));
                });
            }
        };
        return lit_element_1.html `
    <tbody>
      ${this.renderRow(model.name, model, undefined)}
      ${renderChildren()}
    </tbody>`;
    }
    renderRow(name, row, path) {
        const mutationScoreRounded = row.metrics.mutationScore.toFixed(2);
        const coloringClass = this.determineColoringClass(row.metrics.mutationScore);
        const progressBarStyle = `width: ${mutationScoreRounded}%`;
        return lit_element_1.html `
    <tr title="${row.name}">
      <td style="width: 17px;" class="icon no-border-right">${row.file ? svg.file : svg.directory}</td>
      <td width="" class="no-border-left">${typeof path === 'string' ? lit_element_1.html `<a href="${htmlHelpers_1.toAbsoluteUrl(path)}">${name}</a>` :
            lit_element_1.html `<span>${row.name}</span>`}</td>
      <td class="no-border-right vertical-middle">
        <div class="progress">
          <div class="progress-bar bg-${coloringClass}" role="progressbar" aria-valuenow="${mutationScoreRounded}"
            aria-valuemin="0" aria-valuemax="100" .style="${progressBarStyle}">
            ${mutationScoreRounded}%
          </div>
        </div>
      </td>
      <th style="width: 50px;" class="no-border-left text-center text-${coloringClass}">${mutationScoreRounded}</th>
      <td class="text-center">${row.metrics.killed}</td>
      <td class="text-center">${row.metrics.survived}</td>
      <td class="text-center">${row.metrics.timeout}</td>
      <td class="text-center">${row.metrics.noCoverage}</td>
      <td class="text-center">${row.metrics.runtimeErrors}</td>
      <td class="text-center">${row.metrics.compileErrors}</td>
      <th class="text-center">${row.metrics.totalDetected}</th>
      <th class="text-center">${row.metrics.totalUndetected}</th>
      <th class="text-center">${row.metrics.totalMutants}</th>
    </tr>`;
    }
    determineColoringClass(score) {
        if (this.thresholds) {
            if (score < this.thresholds.low) {
                return 'danger';
            }
            else if (score < this.thresholds.high) {
                return 'warning';
            }
            else {
                return 'success';
            }
        }
        else {
            return 'default';
        }
    }
};
MutationTestReportTotalsComponent.styles = [
    style_1.bootstrap,
    lit_element_1.unsafeCSS(require('./index.scss'))
];
__decorate([
    lit_element_1.property()
], MutationTestReportTotalsComponent.prototype, "model", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportTotalsComponent.prototype, "thresholds", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportTotalsComponent.prototype, "currentPath", void 0);
MutationTestReportTotalsComponent = __decorate([
    lit_element_1.customElement('mutation-test-report-totals')
], MutationTestReportTotalsComponent);
exports.MutationTestReportTotalsComponent = MutationTestReportTotalsComponent;
//# sourceMappingURL=index.js.map