"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function getContextClassForStatus(status) {
    switch (status) {
        case "Killed" /* Killed */:
            return 'success';
        case "NoCoverage" /* NoCoverage */:
            return 'caution'; // custom class
        case "Survived" /* Survived */:
            return 'danger';
        case "Timeout" /* Timeout */:
            return 'warning';
        case "RuntimeError" /* RuntimeError */:
        case "CompileError" /* CompileError */:
            return 'secondary';
    }
}
exports.getContextClassForStatus = getContextClassForStatus;
function getEmojiForStatus(status) {
    switch (status) {
        case "Killed" /* Killed */:
            return '✅';
        case "NoCoverage" /* NoCoverage */:
            return '🙈';
        case "Survived" /* Survived */:
            return '👽';
        case "Timeout" /* Timeout */:
            return '⌛';
        case "RuntimeError" /* RuntimeError */:
        case "CompileError" /* CompileError */:
            return '💥';
    }
}
exports.getEmojiForStatus = getEmojiForStatus;
function escapeHtml(unsafe) {
    return unsafe
        .replace(/&/g, '&amp;')
        .replace(/</g, '&lt;')
        .replace(/>/g, '&gt;')
        .replace(/"/g, '&quot;')
        .replace(/'/g, '&#039;');
}
exports.escapeHtml = escapeHtml;
function toAbsoluteUrl(fragment) {
    // Use absolute url because of https://github.com/stryker-mutator/mutation-testing-elements/issues/53
    const url = new URL(window.location.href);
    return new URL(`#${fragment}`, url).href;
}
exports.toAbsoluteUrl = toAbsoluteUrl;
//# sourceMappingURL=htmlHelpers.js.map