"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
/**
 * Observable for location changes on the hash part of the url
 * As soon as you subscribe you'll get a first event for the current location
 * @example
 * window.location.url === 'http://localhost:8080#foo/bar/baz.js' => ['foo', 'bar', 'baz.js ']
 */
exports.locationChange$ = rxjs_1.merge(rxjs_1.of(1), rxjs_1.fromEvent(window, 'hashchange').pipe(operators_1.tap(event => event.preventDefault()))).pipe(operators_1.map(_ => window.location.hash.substr(1)
    .split('/')
    .filter(Boolean)
    .map(decodeURIComponent)));
//# sourceMappingURL=router.js.map