var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { LitElement, html, property, customElement, unsafeCSS } from 'lit-element';
import { calculateMetrics } from 'mutation-testing-metrics';
import { bootstrap } from '../../style';
import { locationChange$ } from '../../lib/router';
import style from './index.scss';
import theme from './theme.scss';
let MutationTestReportAppComponent = class MutationTestReportAppComponent extends LitElement {
    constructor() {
        super(...arguments);
        this.path = [];
        this.themeSwitch = (event) => {
            this.theme = event.detail;
            localStorage.setItem('mutation-testing-elements-theme', this.theme);
        };
        this.subscriptions = [];
    }
    get title() {
        if (this.context) {
            if (this.titlePostfix) {
                return `${this.context.name} - ${this.titlePostfix}`;
            }
            else {
                return this.context.name;
            }
        }
        else {
            return '';
        }
    }
    firstUpdated() {
        var _a;
        if (!this.theme) {
            // 1. check local storage
            const theme = localStorage.getItem('mutation-testing-elements-theme');
            if (theme) {
                this.theme = theme;
                // 2. check for user's OS preference
            }
            else if (window.matchMedia && ((_a = window.matchMedia('(prefers-color-scheme: dark)')) === null || _a === void 0 ? void 0 : _a.matches)) {
                this.theme = 'dark';
                // 3. default is light
            }
            else {
                this.theme = 'light';
            }
        }
    }
    loadData() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.src) {
                try {
                    const res = yield fetch(this.src);
                    this.report = yield res.json();
                }
                catch (error) {
                    const e = String(error);
                    this.errorMessage = e;
                }
            }
        });
    }
    updated(changedProperties) {
        return __awaiter(this, void 0, void 0, function* () {
            if ((changedProperties.has('path') || changedProperties.has('report')) && this.report) {
                this.updateModel(this.report);
                this.updateContext();
                this.updateTitle();
            }
            if (changedProperties.has('src')) {
                yield this.loadData();
            }
            if (changedProperties.has('theme')) {
                this.dispatchEvent(new CustomEvent('theme-changed', { detail: { theme: this.theme } }));
            }
        });
    }
    updateModel(report) {
        this.rootModel = calculateMetrics(report.files);
    }
    updateContext() {
        if (this.rootModel) {
            // Find the current selected file/directory based on the path
            this.context = this.path.reduce((model, currentPathPart) => model && model.childResults.find((child) => child.name === currentPathPart), this.rootModel);
        }
    }
    updateTitle() {
        document.title = this.title;
    }
    connectedCallback() {
        super.connectedCallback();
        this.subscriptions.push(locationChange$.subscribe((path) => (this.path = path)));
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.subscriptions.forEach((subscription) => subscription.unsubscribe());
    }
    renderTitle() {
        const renderPostfix = () => {
            if (this.titlePostfix) {
                return html `<small class="text-muted"> - ${this.titlePostfix}</small>`;
            }
            else {
                return undefined;
            }
        };
        if (this.context) {
            if (this.titlePostfix) {
                return html `<h1 class="display-4">${this.context.name}${renderPostfix()}</h1>`;
            }
        }
        return undefined;
    }
    render() {
        if (this.context || this.errorMessage) {
            return html `
        <div class="container-fluid">
          <div class="row">
            <div class="col-md-12">${this.renderReport()} ${this.renderErrorMessage()}</div>
          </div>
        </div>
      `;
        }
        else {
            return html ``;
        }
    }
    renderErrorMessage() {
        if (this.errorMessage) {
            return html `<div class="alert alert-danger" role="alert">${this.errorMessage}</div>`;
        }
        else {
            return html ``;
        }
    }
    renderReport() {
        if (this.context) {
            return html `
        <mutation-test-report-theme-switch @theme-switch="${this.themeSwitch}" class="theme-switch" .theme="${this.theme}">
        </mutation-test-report-theme-switch>
        ${this.renderTitle()}
        <mutation-test-report-breadcrumb .path="${this.path}"></mutation-test-report-breadcrumb>
        ${this.renderTotals()} ${this.renderFileReport()}
      `;
        }
        else {
            return undefined;
        }
    }
    renderFileReport() {
        if (this.context && this.report && this.context.file) {
            return html `<mutation-test-report-file .model="${this.context.file}"></mutation-test-report-file>`;
        }
        else {
            return undefined;
        }
    }
    renderTotals() {
        if (this.report && this.context) {
            return html `
        <div class="row">
          <div class="totals col-sm-11">
            <mutation-test-report-totals .currentPath="${this.path}" .thresholds="${this.report.thresholds}" .model="${this.context}">
            </mutation-test-report-totals>
          </div>
        </div>
      `;
        }
        else {
            return undefined;
        }
    }
};
MutationTestReportAppComponent.styles = [unsafeCSS(theme), bootstrap, unsafeCSS(style)];
__decorate([
    property({ attribute: false })
], MutationTestReportAppComponent.prototype, "report", void 0);
__decorate([
    property({ attribute: false })
], MutationTestReportAppComponent.prototype, "rootModel", void 0);
__decorate([
    property()
], MutationTestReportAppComponent.prototype, "src", void 0);
__decorate([
    property({ attribute: false })
], MutationTestReportAppComponent.prototype, "errorMessage", void 0);
__decorate([
    property({ attribute: false })
], MutationTestReportAppComponent.prototype, "context", void 0);
__decorate([
    property()
], MutationTestReportAppComponent.prototype, "path", void 0);
__decorate([
    property({ attribute: 'title-postfix' })
], MutationTestReportAppComponent.prototype, "titlePostfix", void 0);
__decorate([
    property({ reflect: true })
], MutationTestReportAppComponent.prototype, "theme", void 0);
__decorate([
    property()
], MutationTestReportAppComponent.prototype, "title", null);
MutationTestReportAppComponent = __decorate([
    customElement('mutation-test-report-app')
], MutationTestReportAppComponent);
export { MutationTestReportAppComponent };
//# sourceMappingURL=index.js.map