var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { LitElement, html, property, customElement } from 'lit-element';
import { bootstrap } from '../style';
import { toAbsoluteUrl } from '../lib/htmlHelpers';
const ROOT_NAME = 'All files';
let MutationTestReportBreadcrumbComponent = class MutationTestReportBreadcrumbComponent extends LitElement {
    render() {
        return html `
      <ol class="breadcrumb">
        ${this.renderRootItem()} ${this.renderBreadcrumbItems()}
      </ol>
    `;
    }
    renderRootItem() {
        if (this.path && this.path.length) {
            return this.renderLink(ROOT_NAME, '');
        }
        else {
            return this.renderActiveItem(ROOT_NAME);
        }
    }
    renderBreadcrumbItems() {
        if (this.path) {
            const path = this.path;
            return path.map((item, index) => {
                if (index === path.length - 1) {
                    return this.renderActiveItem(item);
                }
                else {
                    return this.renderLink(item, `${path.filter((_, i) => i <= index).join('/')}`);
                }
            });
        }
        return undefined;
    }
    renderActiveItem(title) {
        return html ` <li class="breadcrumb-item active" aria-current="page">${title}</li> `;
    }
    renderLink(title, url) {
        return html ` <li class="breadcrumb-item"><a href="${toAbsoluteUrl(url)}">${title}</a></li> `;
    }
};
MutationTestReportBreadcrumbComponent.styles = [bootstrap];
__decorate([
    property()
], MutationTestReportBreadcrumbComponent.prototype, "path", void 0);
MutationTestReportBreadcrumbComponent = __decorate([
    customElement('mutation-test-report-breadcrumb')
], MutationTestReportBreadcrumbComponent);
export { MutationTestReportBreadcrumbComponent };
//# sourceMappingURL=mutation-test-report-breadcrumb.js.map