var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { customElement, LitElement, property, html, unsafeCSS } from 'lit-element';
import { MutantStatus } from 'mutation-testing-report-schema';
import { bootstrap } from '../../style';
import { getContextClassForStatus, getEmojiForStatus } from '../../lib/htmlHelpers';
import style from './index.scss';
let MutationTestReportFileLegendComponent = class MutationTestReportFileLegendComponent extends LitElement {
    constructor() {
        super(...arguments);
        this.mutants = [];
        this.collapsed = true;
        this.filters = [];
        this.toggleOpenAll = () => {
            this.collapsed = !this.collapsed;
            if (this.collapsed) {
                this.dispatchEvent(new CustomEvent('collapse-all'));
            }
            else {
                this.dispatchEvent(new CustomEvent('expand-all'));
            }
        };
    }
    get collapseButtonText() {
        if (this.collapsed) {
            return 'Expand all';
        }
        else {
            return 'Collapse all';
        }
    }
    updated(changedProperties) {
        if (changedProperties.has('mutants')) {
            this.updateModel();
        }
    }
    updateModel() {
        this.filters = [
            MutantStatus.Killed,
            MutantStatus.Survived,
            MutantStatus.NoCoverage,
            MutantStatus.Ignored,
            MutantStatus.Timeout,
            MutantStatus.CompileError,
            MutantStatus.RuntimeError,
        ]
            .filter((status) => this.mutants.some((mutant) => mutant.status === status))
            .map((status) => ({
            enabled: [MutantStatus.Survived, MutantStatus.NoCoverage, MutantStatus.Timeout].some((s) => s === status),
            numberOfMutants: this.mutants.filter((m) => m.status === status).length,
            status,
        }));
        this.dispatchFiltersChangedEvent();
    }
    checkboxClicked(filter) {
        filter.enabled = !filter.enabled;
        this.dispatchFiltersChangedEvent();
    }
    dispatchFiltersChangedEvent() {
        this.dispatchEvent(new CustomEvent('filters-changed', { detail: this.filters }));
    }
    render() {
        return html `
      <div class="legend col-md-12">
        ${this.filters.map((filter) => html `
            <div data-status="${filter.status}" class="form-check form-check-inline">
              <label class="form-check-label">
                <input
                  class="form-check-input"
                  type="checkbox"
                  ?checked="${filter.enabled}"
                  value="${filter.status}"
                  @input="${() => this.checkboxClicked(filter)}"
                />
                <span class="badge badge-${getContextClassForStatus(filter.status)}"
                  >${getEmojiForStatus(filter.status)} ${filter.status} (${filter.numberOfMutants})</span
                >
              </label>
            </div>
          `)}
        <button @click="${this.toggleOpenAll}" class="btn btn-sm btn-secondary" type="button">${this.collapseButtonText}</button>
      </div>
    `;
    }
};
MutationTestReportFileLegendComponent.styles = [bootstrap, unsafeCSS(style)];
__decorate([
    property()
], MutationTestReportFileLegendComponent.prototype, "mutants", void 0);
__decorate([
    property()
], MutationTestReportFileLegendComponent.prototype, "collapseButtonText", null);
__decorate([
    property()
], MutationTestReportFileLegendComponent.prototype, "collapsed", void 0);
__decorate([
    property()
], MutationTestReportFileLegendComponent.prototype, "filters", void 0);
MutationTestReportFileLegendComponent = __decorate([
    customElement('mutation-test-report-file-legend')
], MutationTestReportFileLegendComponent);
export { MutationTestReportFileLegendComponent };
//# sourceMappingURL=index.js.map