var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { customElement, LitElement, html, property, unsafeCSS } from 'lit-element';
import { bootstrap } from '../../style';
import style from './index.scss';
let MutationTestReportModalDialogComponent = class MutationTestReportModalDialogComponent extends LitElement {
    constructor() {
        super(...arguments);
        this.show = false;
        this.emitCloseEvent = (event) => {
            this.dispatchEvent(new CustomEvent('close-dialog', { bubbles: true, detail: this, composed: true }));
            event.stopPropagation();
        };
    }
    render() {
        return html `
      <div .hidden="${!this.show}" class="modal show" style="display: block;" tabindex="-1" role="dialog" @click="${this.emitCloseEvent}">
        <div class="modal-dialog" role="document" @click="${(e) => e.stopPropagation()}">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title">${this.header}</h5>
            </div>
            <div class="modal-body">
              <slot></slot>
            </div>
            <div class="modal-footer">
              <button type="button" @click="${this.emitCloseEvent}" class="btn btn-link">Close</button>
            </div>
          </div>
        </div>
      </div>
      <slot></slot>
    `;
    }
};
MutationTestReportModalDialogComponent.styles = [bootstrap, unsafeCSS(style)];
__decorate([
    property({ converter: (val) => typeof val === 'string' })
], MutationTestReportModalDialogComponent.prototype, "show", void 0);
__decorate([
    property()
], MutationTestReportModalDialogComponent.prototype, "header", void 0);
MutationTestReportModalDialogComponent = __decorate([
    customElement('mutation-test-report-modal-dialog')
], MutationTestReportModalDialogComponent);
export { MutationTestReportModalDialogComponent };
//# sourceMappingURL=index.js.map