var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { customElement, LitElement, property, html, unsafeCSS } from 'lit-element';
import { bootstrap } from '../../style';
import style from './index.scss';
// Variable should be kept in sync with 'popup-width' in './mutation-test-report-popup.scss'
const popupWidth = 200;
let MutationTestReportPopupComponent = class MutationTestReportPopupComponent extends LitElement {
    constructor() {
        super(...arguments);
        this.show = false;
    }
    firstUpdated() {
        if (this.getBoundingClientRect().left < popupWidth / 2) {
            const popover = this.shadowRoot.querySelector('.popover');
            popover.style.marginLeft = '0px';
        }
    }
    getBackgroundClasses() {
        return this.context ? `bg-${this.context} text-white` : '';
    }
    render() {
        return html `<div class="popover popover-${this.context} ${this.show ? 'show' : 'hide'}">
        <h3 class="popover-header ${this.getBackgroundClasses()}">${this.header}</h3>
        <div class="popover-body">
          <slot name="popover-body"></slot>
        </div> </div
      >${slot()}`;
        function slot() {
            return html `<slot></slot>`;
        }
    }
};
MutationTestReportPopupComponent.styles = [bootstrap, unsafeCSS(style)];
__decorate([
    property()
], MutationTestReportPopupComponent.prototype, "header", void 0);
__decorate([
    property({ converter: (val) => typeof val === 'string' })
], MutationTestReportPopupComponent.prototype, "show", void 0);
__decorate([
    property()
], MutationTestReportPopupComponent.prototype, "context", void 0);
MutationTestReportPopupComponent = __decorate([
    customElement('mutation-test-report-popup')
], MutationTestReportPopupComponent);
export { MutationTestReportPopupComponent };
//# sourceMappingURL=index.js.map