import { MutantStatus } from 'mutation-testing-report-schema';
import { getContextClassForStatus } from './htmlHelpers';
/**
 * Class to keep track of the states of the
 * mutants that are active at the cursor while walking the code.
 */
export class BackgroundColorCalculator {
    constructor() {
        this.killed = 0;
        this.noCoverage = 0;
        this.survived = 0;
        this.timeout = 0;
        this.ignored = 0;
        this.markMutantStart = (mutant) => {
            this.countMutant(1, mutant.status);
        };
        this.markMutantEnd = (mutant) => {
            this.countMutant(-1, mutant.status);
        };
        this.determineBackground = () => {
            if (this.survived > 0) {
                return getContextClassForStatus(MutantStatus.Survived) + '-light';
            }
            else if (this.noCoverage > 0) {
                return getContextClassForStatus(MutantStatus.NoCoverage) + '-light';
            }
            else if (this.timeout > 0) {
                return getContextClassForStatus(MutantStatus.Timeout) + '-light';
            }
            else if (this.killed > 0) {
                return getContextClassForStatus(MutantStatus.Killed) + '-light';
            }
            else if (this.ignored > 0) {
                return getContextClassForStatus(MutantStatus.Ignored) + '-light';
            }
            return null;
        };
    }
    countMutant(valueToAdd, status) {
        switch (status) {
            case MutantStatus.Killed:
                this.killed += valueToAdd;
                break;
            case MutantStatus.Survived:
                this.survived += valueToAdd;
                break;
            case MutantStatus.Timeout:
                this.timeout += valueToAdd;
                break;
            case MutantStatus.NoCoverage:
                this.noCoverage += valueToAdd;
                break;
            case MutantStatus.Ignored:
                this.ignored += valueToAdd;
                break;
        }
    }
}
//# sourceMappingURL=BackgroundColorCalculator.js.map