var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { html, nothing } from 'lit';
import { customElement, property } from 'lit/decorators.js';
import { MutantStatus } from 'mutation-testing-report-schema/api';
import { describeLocation, getEmojiForStatus, plural, renderIf, renderIfPresent } from '../../lib/html-helpers';
import { tailwind } from '../../style';
import { renderDrawer } from '../drawer/util';
import { renderDetailLine, renderEmoji, renderSummaryContainer, renderSummaryLine } from './util';
import { RealTimeElement } from '../real-time-element';
const describeTest = (test) => `${test.name}${test.sourceFile && test.location ? ` (${describeLocation(test)})` : ''}`;
export let MutationTestReportDrawerMutant = class MutationTestReportDrawerMutant extends RealTimeElement {
    constructor() {
        super(...arguments);
        this.mode = 'closed';
    }
    render() {
        return renderDrawer(
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing -- we want to coalesce on length 0
        { hasDetail: Boolean(this.mutant?.killedByTests?.length || this.mutant?.coveredByTests?.length), mode: this.mode }, renderIfPresent(this.mutant, (mutant) => html `
          <span class="align-middle text-lg" slot="header"
            >${getEmojiForStatus(mutant.status)} ${mutant.mutatorName} ${mutant.status}
            (${mutant.location.start.line}:${mutant.location.start.column})</span
          >
          <span slot="summary">${this.renderSummary()}</span>
          <span slot="detail" class="block">${this.renderDetail()}</span>
        `));
    }
    renderSummary() {
        return renderSummaryContainer(html `${this.mutant?.killedByTests?.[0]
            ? renderSummaryLine(html `${renderEmoji('🎯', 'killed')} Killed by:
            ${this.mutant.killedByTests?.[0].name}${this.mutant.killedByTests.length > 1 ? `(and ${this.mutant.killedByTests.length - 1} more)` : ''}`)
            : nothing}
      ${renderIf(this.mutant?.static, renderSummaryLine(html `${renderEmoji('🗿', 'static')} Static mutant`))}
      ${renderIfPresent(this.mutant?.coveredByTests, (coveredTests) => renderSummaryLine(html `${renderEmoji('☂️', 'umbrella')} Covered by ${coveredTests.length}
          test${plural(coveredTests)}${this.mutant?.status === MutantStatus.Survived ? ' (yet still survived)' : ''}`))}
      ${renderIf(this.mutant?.statusReason?.trim(), renderSummaryLine(html `${renderEmoji('🕵️', 'spy')} ${this.mutant.statusReason}`, `Reason for the ${this.mutant.status} status`))}
      ${renderIfPresent(this.mutant?.description, (description) => renderSummaryLine(html `${renderEmoji('📖', 'book')} ${description}`))}`);
    }
    renderDetail() {
        return html `<ul class="mb-6 mr-12">
      ${this.mutant?.killedByTests?.map((test) => renderDetailLine('This mutant was killed by this test', html `${renderEmoji('🎯', 'killed')} ${describeTest(test)}`))}
      ${this.mutant?.coveredByTests
            ?.filter((test) => !this.mutant?.killedByTests?.includes(test))
            .map((test) => renderDetailLine('This mutant was covered by this test', html `${renderEmoji('☂️', 'umbrella')} ${describeTest(test)}`))}
    </ul>`;
    }
};
MutationTestReportDrawerMutant.styles = [tailwind];
__decorate([
    property()
], MutationTestReportDrawerMutant.prototype, "mutant", void 0);
__decorate([
    property({ reflect: true })
], MutationTestReportDrawerMutant.prototype, "mode", void 0);
MutationTestReportDrawerMutant = __decorate([
    customElement('mte-drawer-mutant')
], MutationTestReportDrawerMutant);
//# sourceMappingURL=drawer-mutant.component.js.map