var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { html, nothing } from 'lit';
import { customElement, property } from 'lit/decorators.js';
import { TestStatus } from 'mutation-testing-metrics';
import { describeLocation, getEmojiForTestStatus, plural, renderIfPresent } from '../../lib/html-helpers';
import { tailwind } from '../../style';
import { renderDetailLine, renderEmoji, renderSummaryContainer, renderSummaryLine } from '../drawer-mutant/util';
import { renderDrawer } from '../drawer/util';
import { RealTimeElement } from '../real-time-element';
const describeMutant = (mutant) => html `<code>${mutant.getMutatedLines()}</code> (${describeLocation(mutant)})`;
export let MutationTestReportDrawerTestComponent = class MutationTestReportDrawerTestComponent extends RealTimeElement {
    constructor() {
        super(...arguments);
        this.mode = 'closed';
    }
    render() {
        return renderDrawer(
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing -- we want to coalesce on length 0
        { hasDetail: Boolean(this.test?.killedMutants?.length || this.test?.coveredMutants?.length), mode: this.mode }, renderIfPresent(this.test, (test) => html `
          <span class="align-middle text-lg" slot="header"
            >${getEmojiForTestStatus(test.status)} ${test.name} [${test.status}]
            ${test.location ? html `(${test.location.start.line}:${test.location.start.column})` : nothing}</span
          >
          <span slot="summary">${this.renderSummary()}</span>
          <span class="block" slot="detail">${this.renderDetail()}</span>
        `));
    }
    renderSummary() {
        return renderSummaryContainer(html `${this.test?.killedMutants?.[0]
            ? renderSummaryLine(html `${renderEmoji('🎯', 'killed')} Killed:
            ${describeMutant(this.test.killedMutants?.[0])}${this.test.killedMutants.length > 1
                ? html ` (and ${this.test.killedMutants.length - 1} more)`
                : ''}`)
            : nothing}
      ${renderIfPresent(this.test?.coveredMutants, (coveredMutants) => renderSummaryLine(html `${renderEmoji('☂️', 'umbrella')} Covered ${coveredMutants.length}
          mutant${plural(coveredMutants)}${this.test?.status === TestStatus.Covering ? " (yet didn't kill any of them)" : ''}`))}`);
    }
    renderDetail() {
        return html `<ul class="mb-6 mr-12">
      ${this.test?.killedMutants?.map((mutant) => renderDetailLine('This test killed this mutant', html `${renderEmoji('🎯', 'killed')} ${describeMutant(mutant)}`))}
      ${this.test?.coveredMutants
            ?.filter((mutant) => !this.test?.killedMutants?.includes(mutant))
            .map((mutant) => renderDetailLine('This test covered this mutant', html `${renderEmoji('☂️', 'umbrella')} ${describeMutant(mutant)}`))}
    </ul>`;
    }
};
MutationTestReportDrawerTestComponent.styles = [tailwind];
__decorate([
    property()
], MutationTestReportDrawerTestComponent.prototype, "test", void 0);
__decorate([
    property({ reflect: true })
], MutationTestReportDrawerTestComponent.prototype, "mode", void 0);
MutationTestReportDrawerTestComponent = __decorate([
    customElement('mte-drawer-test')
], MutationTestReportDrawerTestComponent);
//# sourceMappingURL=drawer-test.component.js.map