var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { html, nothing } from 'lit';
import { customElement, property } from 'lit/decorators.js';
import { classMap } from 'lit/directives/class-map.js';
import { repeat } from 'lit/directives/repeat.js';
import { toAbsoluteUrl } from '../../lib/html-helpers';
import { tailwind } from '../../style';
import { renderEmoji } from '../drawer-mutant/util';
import { RealTimeElement } from '../real-time-element';
export let MutationTestReportTestMetricsTable = class MutationTestReportTestMetricsTable extends RealTimeElement {
    constructor() {
        super(...arguments);
        this.currentPath = [];
        this.thresholds = {
            high: 80,
            low: 60,
        };
        this.hasMultipleColspan = false;
    }
    willUpdate(changedProperties) {
        if (changedProperties.has('columns')) {
            this.hasMultipleColspan = this.columns.some((column) => column.category === 'percentage');
        }
    }
    render() {
        return html `${this.model
            ? html `<div class="overflow-x-auto rounded-md border border-gray-200">
          <table class="w-full table-auto text-left text-sm">${this.renderTableHeadRow()}${this.renderTableBody(this.model)} </table>
        </div>`
            : nothing}`;
    }
    renderTableHeadRow() {
        return html `<thead class="border-b border-gray-200 text-center text-sm">
      <tr>
        <th scope="col" class="px-4 py-4">
          <div class="flex items-center justify-around">
            <span>File / Directory</span
            ><a
              href="https://stryker-mutator.io/docs/mutation-testing-elements/mutant-states-and-metrics"
              target="_blank"
              class="info-icon float-right"
              title="What does this all mean?"
              >${renderEmoji('ℹ', 'info icon')}</a
            >
          </div>
        </th>
        ${repeat(this.columns, (column) => column.key, (column) => this.renderTableHead(column))}
      </tr>
    </thead>`;
    }
    renderTableHead(column) {
        const id = `tooltip-${column.key.toString()}`;
        const header = column.tooltip
            ? html `<mte-tooltip title="${column.tooltip}" id="${id}">${column.label}</mte-tooltip>`
            : html `<span id="${id}">${column.label}</span>`;
        if (column.category === 'percentage') {
            return html ` <th colspan="2" class="px-2 even:bg-gray-100"> ${header} </th>`;
        }
        return html `<th class="w-24 px-2 even:bg-gray-100 2xl:w-28">
      <div class="inline-block">${header}</div>
    </th>`;
    }
    renderTableBody(model) {
        const renderChildren = () => {
            if (model.file) {
                return nothing;
            }
            else {
                return model.childResults.map((childResult) => {
                    const nameParts = [childResult.name];
                    while (!childResult.file && childResult.childResults.length === 1) {
                        childResult = childResult.childResults[0];
                        nameParts.push(childResult.name);
                    }
                    return this.renderRow(nameParts.join('/'), childResult, ...this.currentPath, ...nameParts);
                });
            }
        };
        return html `<tbody class="divide-y divide-gray-200">${this.renderRow(model.name, model)} ${renderChildren()}</tbody>`;
    }
    renderRow(name, row, ...path) {
        return html `<tr title="${row.name}" class="group hover:bg-gray-200">
      <td class="font-semibold">
        <div class="flex items-center justify-start">
          <mte-file-icon file-name="${row.name}" ?file="${row.file}" class="mx-1"></mte-file-icon> ${path.length > 0
            ? html `<a class="mr-auto inline-block w-full py-4 pr-2 hover:text-primary-on hover:underline" href="${toAbsoluteUrl(...path)}"
                >${name}</a
              >`
            : html `<span class="py-4">${row.name}</span>`}
        </div>
      </td>
      ${this.columns.map((column) => this.renderCell(column, row.metrics))}
    </tr>`;
    }
    renderCell(column, metrics) {
        const value = metrics[column.key];
        const backgroundColoringClass = this.hasMultipleColspan ? 'odd:bg-gray-100' : 'even:bg-gray-100';
        if (column.category === 'percentage') {
            const valueIsPresent = !isNaN(value);
            const bgColoringClass = this.determineBgColoringClass(value);
            const textColoringClass = this.determineTextColoringClass(value);
            const mutationScoreRounded = value.toFixed(2);
            const progressBarStyle = `width: ${value}%`;
            return html `<td class="bg-gray-100 px-4 py-4 group-hover:bg-gray-200">
          ${valueIsPresent
                ? html `<div class="h-3 w-full min-w-[24px] rounded-full bg-gray-300">
                <div
                  class="${bgColoringClass} h-3 rounded-full pl-1 transition-all"
                  role="progressbar"
                  aria-valuenow="${mutationScoreRounded}"
                  aria-valuemin="0"
                  aria-valuemax="100"
                  aria-describedby="tooltip-mutationScore"
                  title="${column.label}"
                  style="${progressBarStyle}"
                ></div>
              </div>`
                : html ` <span class="text-light-muted font-bold">N/A</span> `}
        </td>
        <td class="${textColoringClass} ${backgroundColoringClass} w-12 pr-2 text-center font-bold group-hover:bg-gray-200"
          >${valueIsPresent ? html `<span class="transition-colors">${mutationScoreRounded}</span>` : nothing}</td
        >`;
        }
        return html `<td
      class="${classMap({ 'font-bold': column.isBold ?? false, [backgroundColoringClass]: true })} py-4 text-center group-hover:bg-gray-200"
      aria-describedby="${`tooltip-${column.key.toString()}`}"
      >${value}</td
    >`;
    }
    determineBgColoringClass(mutationScore) {
        if (!isNaN(mutationScore) && this.thresholds) {
            if (mutationScore < this.thresholds.low) {
                return 'bg-red-600 text-gray-200';
            }
            else if (mutationScore < this.thresholds.high) {
                return 'bg-yellow-400';
            }
            else {
                return 'bg-green-600 text-gray-200';
            }
        }
        else {
            return 'bg-blue-600';
        }
    }
    determineTextColoringClass(mutationScore) {
        if (!isNaN(mutationScore) && this.thresholds) {
            if (mutationScore < this.thresholds.low) {
                return 'text-red-700';
            }
            else if (mutationScore < this.thresholds.high) {
                return 'text-yellow-600';
            }
            else {
                return 'text-green-700';
            }
        }
        else {
            return '';
        }
    }
};
MutationTestReportTestMetricsTable.styles = [tailwind];
__decorate([
    property()
], MutationTestReportTestMetricsTable.prototype, "model", void 0);
__decorate([
    property()
], MutationTestReportTestMetricsTable.prototype, "currentPath", void 0);
__decorate([
    property({ type: Array })
], MutationTestReportTestMetricsTable.prototype, "columns", void 0);
__decorate([
    property()
], MutationTestReportTestMetricsTable.prototype, "thresholds", void 0);
MutationTestReportTestMetricsTable = __decorate([
    customElement('mte-metrics-table')
], MutationTestReportTestMetricsTable);
//# sourceMappingURL=metrics-table.component.js.map