var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { html, nothing, unsafeCSS } from 'lit';
import { customElement, property } from 'lit/decorators.js';
import { tailwind } from '../../style';
import style from './mutant-view.scss';
import { RealTimeElement } from '../real-time-element';
export let MutationTestReportMutantViewComponent = class MutationTestReportMutantViewComponent extends RealTimeElement {
    constructor() {
        super(...arguments);
        this.drawerMode = 'closed';
        this.handleClick = () => {
            // Close the drawer if the user clicks anywhere in the report (that didn't handle the click already)
            this.drawerMode = 'closed';
        };
        this.handleMutantSelected = (event) => {
            this.selectedMutant = event.detail.mutant;
            this.drawerMode = event.detail.selected ? 'half' : 'closed';
        };
    }
    updated(changes) {
        if (changes.has('result') && !this.result.file) {
            this.drawerMode = 'closed';
        }
    }
    render() {
        return html `
      <main @click="${this.handleClick}">
        <mte-metrics-table .columns="${COLUMNS}" .currentPath="${this.path}" .thresholds="${this.thresholds}" .model="${this.result}">
        </mte-metrics-table>
        ${this.result.file ? html `<mte-file @mutant-selected="${this.handleMutantSelected}" .model="${this.result.file}"></mte-file>` : nothing}
      </main>
      <mte-drawer-mutant .mode="${this.drawerMode}" .mutant="${this.selectedMutant}"></mte-drawer-mutant>
    `;
    }
};
MutationTestReportMutantViewComponent.styles = [unsafeCSS(style), tailwind];
__decorate([
    property()
], MutationTestReportMutantViewComponent.prototype, "drawerMode", void 0);
__decorate([
    property()
], MutationTestReportMutantViewComponent.prototype, "selectedMutant", void 0);
__decorate([
    property()
], MutationTestReportMutantViewComponent.prototype, "result", void 0);
__decorate([
    property({ attribute: false, reflect: false })
], MutationTestReportMutantViewComponent.prototype, "thresholds", void 0);
__decorate([
    property({ attribute: false, reflect: false })
], MutationTestReportMutantViewComponent.prototype, "path", void 0);
MutationTestReportMutantViewComponent = __decorate([
    customElement('mte-mutant-view')
], MutationTestReportMutantViewComponent);
const COLUMNS = [
    {
        key: 'mutationScore',
        label: 'Mutation score',
        tooltip: 'The percentage of mutants that were detected. The higher, the better!',
        category: 'percentage',
    },
    {
        key: 'killed',
        label: 'Killed',
        tooltip: 'At least one test failed while these mutants were active. This is what you want!',
        category: 'number',
    },
    {
        key: 'survived',
        label: 'Survived',
        tooltip: "All tests passed while these mutants were active. You're missing a test for them.",
        category: 'number',
    },
    {
        key: 'timeout',
        label: 'Timeout',
        tooltip: 'Running the tests while these mutants were active resulted in a timeout. For example, an infinite loop.',
        category: 'number',
    },
    {
        key: 'noCoverage',
        label: 'No coverage',
        tooltip: "These mutants aren't covered by one of your tests and survived as a result.",
        category: 'number',
    },
    {
        key: 'ignored',
        label: 'Ignored',
        tooltip: "These mutants weren't tested because they are ignored. Either by user action, or for another reason.",
        category: 'number',
    },
    {
        key: 'runtimeErrors',
        label: 'Runtime errors',
        tooltip: 'Running tests when these mutants are active resulted in an error (rather than a failed test). For example: an out of memory error.',
        category: 'number',
    },
    { key: 'compileErrors', label: 'Compile errors', tooltip: 'Mutants that caused a compile error.', category: 'number' },
    {
        key: 'totalDetected',
        label: 'Detected',
        tooltip: 'The number of mutants detected by your tests (killed + timeout).',
        category: 'number',
        width: 'large',
        isBold: true,
    },
    {
        key: 'totalUndetected',
        label: 'Undetected',
        tooltip: 'The number of mutants that are not detected by your tests (survived + no coverage).',
        category: 'number',
        width: 'large',
        isBold: true,
    },
    {
        key: 'totalMutants',
        label: 'Total',
        tooltip: 'All mutants (except runtimeErrors + compileErrors)',
        category: 'number',
        width: 'large',
        isBold: true,
    },
];
//# sourceMappingURL=mutant-view.js.map