var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _ResultStatusBar_instances, _ResultStatusBar_observer, _ResultStatusBar_renderSmallParts, _ResultStatusBar_renderSmallPart, _ResultStatusBar_renderParts, _ResultStatusBar_renderPart, _ResultStatusBar_getMetrics, _ResultStatusBar_colorFromMetric, _ResultStatusBar_calculatePercentage;
import { LitElement, html } from 'lit';
import { customElement, property, state } from 'lit/decorators.js';
import { tailwind } from '../../style';
export let ResultStatusBar = class ResultStatusBar extends LitElement {
    constructor() {
        super();
        _ResultStatusBar_instances.add(this);
        this.detected = 0;
        this.undetected = 0;
        this.invalid = 0;
        this.ignored = 0;
        this.pending = 0;
        this.total = 0;
        this.shouldBeSmall = false;
        _ResultStatusBar_observer.set(this, void 0);
    }
    connectedCallback() {
        super.connectedCallback();
        // This code is responsible for making the small progress-bar show up.
        // Once this element (the standard progress-bar) is no longer intersecting (visible) the viewable window,
        // the smaller progress-bar will show up at the top if the window.
        // If this element is visible, the smaller progress-bar will fade out and it will no longer be visible.
        __classPrivateFieldSet(this, _ResultStatusBar_observer, new window.IntersectionObserver(([entry]) => {
            if (entry.isIntersecting) {
                this.shouldBeSmall = false;
            }
            else {
                this.shouldBeSmall = true;
            }
            this.requestUpdate();
        }), "f");
        __classPrivateFieldGet(this, _ResultStatusBar_observer, "f").observe(this);
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        __classPrivateFieldGet(this, _ResultStatusBar_observer, "f")?.disconnect();
    }
    render() {
        return html `
      ${__classPrivateFieldGet(this, _ResultStatusBar_instances, "m", _ResultStatusBar_renderSmallParts).call(this)}
      <div class="my-4 rounded-md border border-gray-200 bg-white transition-all">
        <div class="relative">
          <div class="parts flex h-8 w-full overflow-hidden rounded bg-gray-200">${__classPrivateFieldGet(this, _ResultStatusBar_instances, "m", _ResultStatusBar_renderParts).call(this)}</div>
        </div>
      </div>
    `;
    }
};
_ResultStatusBar_observer = new WeakMap();
_ResultStatusBar_instances = new WeakSet();
_ResultStatusBar_renderSmallParts = function _ResultStatusBar_renderSmallParts() {
    return html `<div
      class="${this.shouldBeSmall ? 'opacity-1' : 'opacity-0'} pointer-events-none fixed left-0 top-0 z-20 flex w-full justify-center transition-all"
    >
      <div class="container w-full bg-white py-2">
        <div class="flex h-2 overflow-hidden rounded bg-gray-200">${__classPrivateFieldGet(this, _ResultStatusBar_instances, "m", _ResultStatusBar_getMetrics).call(this).map((metric) => __classPrivateFieldGet(this, _ResultStatusBar_instances, "m", _ResultStatusBar_renderSmallPart).call(this, metric))}</div>
      </div>
    </div>`;
};
_ResultStatusBar_renderSmallPart = function _ResultStatusBar_renderSmallPart(metric) {
    return html `<div
      class="${__classPrivateFieldGet(this, _ResultStatusBar_instances, "m", _ResultStatusBar_colorFromMetric).call(this, metric.type)} z-20 h-2 transition-all"
      style="width: ${__classPrivateFieldGet(this, _ResultStatusBar_instances, "m", _ResultStatusBar_calculatePercentage).call(this, metric.amount)}%"
    ></div>`;
};
_ResultStatusBar_renderParts = function _ResultStatusBar_renderParts() {
    return html `${__classPrivateFieldGet(this, _ResultStatusBar_instances, "m", _ResultStatusBar_getMetrics).call(this).map((metric) => __classPrivateFieldGet(this, _ResultStatusBar_instances, "m", _ResultStatusBar_renderPart).call(this, metric))}`;
};
_ResultStatusBar_renderPart = function _ResultStatusBar_renderPart(metric) {
    return html `<div
      title="${metric.tooltip}"
      style="width: ${__classPrivateFieldGet(this, _ResultStatusBar_instances, "m", _ResultStatusBar_calculatePercentage).call(this, metric.amount)}%"
      class="${__classPrivateFieldGet(this, _ResultStatusBar_instances, "m", _ResultStatusBar_colorFromMetric).call(this, metric.type)} ${metric.amount === 0
        ? 'opacity-0'
        : ''} relative flex h-8 items-center overflow-hidden transition-all"
    >
      <span class="ms-3 font-bold text-gray-800">${metric.amount}</span>
    </div>`;
};
_ResultStatusBar_getMetrics = function _ResultStatusBar_getMetrics() {
    return [
        { type: 'detected', amount: this.detected, tooltip: 'killed + timeout' },
        { type: 'undetected', amount: this.undetected, tooltip: 'survived + no coverage' },
        { type: 'ignored + invalid', amount: this.ignored + this.invalid, tooltip: 'ignored + runtime error + compile error' },
        { type: 'pending', amount: this.pending, tooltip: 'pending' },
    ];
};
_ResultStatusBar_colorFromMetric = function _ResultStatusBar_colorFromMetric(metric) {
    switch (metric) {
        case 'detected':
            return 'bg-green-600';
        case 'undetected':
            return 'bg-red-600';
        case 'ignored + invalid':
            return 'bg-yellow-600';
        default:
            return 'bg-gray-200';
    }
};
_ResultStatusBar_calculatePercentage = function _ResultStatusBar_calculatePercentage(metric) {
    return this.total !== 0 ? (100 * metric) / this.total : 0;
};
ResultStatusBar.styles = [tailwind];
__decorate([
    property({ attribute: false })
], ResultStatusBar.prototype, "detected", void 0);
__decorate([
    property({ attribute: false })
], ResultStatusBar.prototype, "undetected", void 0);
__decorate([
    property({ attribute: false })
], ResultStatusBar.prototype, "invalid", void 0);
__decorate([
    property({ attribute: false })
], ResultStatusBar.prototype, "ignored", void 0);
__decorate([
    property({ attribute: false })
], ResultStatusBar.prototype, "pending", void 0);
__decorate([
    property({ attribute: false })
], ResultStatusBar.prototype, "total", void 0);
__decorate([
    state()
], ResultStatusBar.prototype, "shouldBeSmall", void 0);
ResultStatusBar = __decorate([
    customElement('mte-result-status-bar')
], ResultStatusBar);
//# sourceMappingURL=result-status-bar.js.map