var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { html, nothing, svg, unsafeCSS } from 'lit';
import { customElement, property, state } from 'lit/decorators.js';
import { TestStatus } from 'mutation-testing-metrics';
import style from './test-file.scss';
import { repeat } from 'lit/directives/repeat.js';
import { determineLanguage, gte, highlightCode, transformHighlightedLines } from '../../lib/code-helpers';
import { createCustomEvent } from '../../lib/custom-events';
import { getContextClassForTestStatus, getEmojiForTestStatus, scrollToCodeFragmentIfNeeded } from '../../lib/html-helpers';
import { prismjs, tailwind } from '../../style';
import '../../style/prism-plugins';
import { renderDots, renderLine } from '../file/util';
import { RealTimeElement } from '../real-time-element';
export let TestFileComponent = class TestFileComponent extends RealTimeElement {
    constructor() {
        super(...arguments);
        this.filters = [];
        this.lines = [];
        this.enabledStates = [];
        this.tests = [];
        this.filtersChanged = (event) => {
            this.enabledStates = event.detail;
            if (this.selectedTest && !this.enabledStates.includes(this.selectedTest.status)) {
                this.toggleTest(this.selectedTest);
            }
        };
        this.nextTest = () => {
            const index = this.selectedTest ? (this.tests.findIndex(({ id }) => id === this.selectedTest.id) + 1) % this.tests.length : 0;
            this.selectTest(this.tests[index]);
        };
        this.previousTest = () => {
            const index = this.selectedTest
                ? (this.tests.findIndex(({ id }) => id === this.selectedTest.id) + this.tests.length - 1) % this.tests.length
                : this.tests.length - 1;
            this.selectTest(this.tests[index]);
        };
    }
    toggleTest(test) {
        if (this.selectedTest === test) {
            this.selectedTest = undefined;
            this.dispatchEvent(createCustomEvent('test-selected', { selected: false, test }));
        }
        else {
            this.selectedTest = test;
            this.dispatchEvent(createCustomEvent('test-selected', { selected: true, test }));
            scrollToCodeFragmentIfNeeded(this.shadowRoot.querySelector(`[test-id="${test.id}"]`));
        }
    }
    selectTest(test) {
        if (test) {
            this.toggleTest(test);
        }
    }
    render() {
        return html `
      <mte-state-filter
        @next=${this.nextTest}
        @previous=${this.previousTest}
        .filters="${this.filters}"
        @filters-changed="${this.filtersChanged}"
      ></mte-state-filter>
      ${this.renderTestList()} ${this.renderCode()}
    `;
    }
    renderTestList() {
        const testsToRenderInTheList = this.tests.filter((test) => !test.location);
        if (testsToRenderInTheList.length) {
            return html `<ul class="max-w-6xl">
        ${repeat(testsToRenderInTheList, (test) => test.id, (test) => html `<li class="my-3">
              <button
                class="w-full rounded p-3 text-left hover:bg-gray-100 active:bg-gray-200"
                type="button"
                data-active="${this.selectedTest === test}"
                test-id="${test.id}"
                @click=${(ev) => {
                ev.stopPropagation();
                this.toggleTest(test);
            }}
                >${getEmojiForTestStatus(test.status)} ${test.name} [${test.status}]
              </button>
            </li>`)}
      </ul>`;
        }
        return nothing;
    }
    renderCode() {
        if (this.model?.source) {
            const testsByLine = new Map();
            for (const test of this.tests) {
                if (test.location) {
                    let tests = testsByLine.get(test.location.start.line);
                    if (!tests) {
                        tests = [];
                        testsByLine.set(test.location.start.line, tests);
                    }
                    tests.push(test);
                }
            }
            const renderFinalTests = (lastLine) => {
                return this.renderTestDots([...testsByLine.entries()].filter(([line]) => line > lastLine).flatMap(([, tests]) => tests));
            };
            return html `<pre id="report-code-block" class="line-numbers flex rounded-md p-1"><code class="flex language-${determineLanguage(this.model.name)}">
      <table>
        ${this.lines.map((line, lineIndex) => {
                const lineNr = lineIndex + 1;
                const testDots = this.renderTestDots(testsByLine.get(lineNr));
                const finalTests = this.lines.length === lineNr ? renderFinalTests(lineNr) : nothing;
                return renderLine(line, renderDots(testDots, finalTests));
            })}</table></code></pre>`;
        }
        return nothing;
    }
    renderTestDots(tests) {
        return tests?.length
            ? tests.map((test) => svg `<svg test-id="${test.id}" class="cursor-pointer test-dot ${this.selectedTest === test ? 'selected' : test.status}" @click=${(ev) => {
                ev.stopPropagation();
                this.toggleTest(test);
            }} height="10" width="12">
          <title>${title(test)}</title>
          <circle cx="5" cy="5" r="5" />
          </svg>`)
            : nothing;
    }
    reactivate() {
        super.reactivate();
        this.updateFileRepresentation();
    }
    willUpdate(changes) {
        if (changes.has('model')) {
            this.updateFileRepresentation();
        }
        if ((changes.has('model') || changes.has('enabledStates')) && this.model) {
            this.tests = this.model.tests
                .filter((tests) => this.enabledStates.includes(tests.status))
                .sort((t1, t2) => {
                if (t1.location && t2.location) {
                    return gte(t1.location.start, t2.location.start) ? 1 : -1;
                }
                else {
                    // Keep original sorting
                    return this.model.tests.indexOf(t1) - this.model.tests.indexOf(t2);
                }
            });
        }
        super.update(changes);
    }
    updateFileRepresentation() {
        if (!this.model) {
            return;
        }
        const model = this.model;
        this.filters = [TestStatus.Killing, TestStatus.Covering, TestStatus.NotCovering]
            .filter((status) => model.tests.some((test) => test.status === status))
            .map((status) => ({
            enabled: true,
            count: model.tests.filter((m) => m.status === status).length,
            status,
            label: html `${getEmojiForTestStatus(status)} ${status}`,
            context: getContextClassForTestStatus(status),
        }));
        if (this.model.source) {
            this.lines = transformHighlightedLines(highlightCode(this.model.source, this.model.name));
        }
    }
};
TestFileComponent.styles = [prismjs, tailwind, unsafeCSS(style)];
__decorate([
    property()
], TestFileComponent.prototype, "model", void 0);
__decorate([
    state()
], TestFileComponent.prototype, "filters", void 0);
__decorate([
    state()
], TestFileComponent.prototype, "lines", void 0);
__decorate([
    state()
], TestFileComponent.prototype, "enabledStates", void 0);
__decorate([
    state()
], TestFileComponent.prototype, "selectedTest", void 0);
__decorate([
    state()
], TestFileComponent.prototype, "tests", void 0);
TestFileComponent = __decorate([
    customElement('mte-test-file')
], TestFileComponent);
function title(test) {
    return `${test.name} (${test.status})`;
}
//# sourceMappingURL=test-file.component.js.map