var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { html, nothing, unsafeCSS } from 'lit';
import { customElement, property } from 'lit/decorators.js';
import { tailwind } from '../../style';
import style from './test-view.scss';
import { RealTimeElement } from '../real-time-element';
export let MutationTestReportTestViewComponent = class MutationTestReportTestViewComponent extends RealTimeElement {
    constructor() {
        super(...arguments);
        this.drawerMode = 'closed';
        this.handleClick = () => {
            // Close the drawer if the user clicks anywhere in the report (that didn't handle the click already)
            this.drawerMode = 'closed';
        };
        this.handleTestSelected = (event) => {
            this.selectedTest = event.detail.test;
            this.drawerMode = event.detail.selected ? 'half' : 'closed';
        };
    }
    updated(changes) {
        if (changes.has('result') && !this.result.file) {
            this.drawerMode = 'closed';
        }
    }
    render() {
        return html `
      <main @click="${this.handleClick}">
        <mte-metrics-table .columns="${COLUMNS}" .currentPath="${this.path}" .model="${this.result}"> </mte-metrics-table>
        ${this.result.file ? html `<mte-test-file @test-selected="${this.handleTestSelected}" .model="${this.result.file}"></mte-test-file>` : nothing}
      </main>
      <mte-drawer-test .mode="${this.drawerMode}" .test="${this.selectedTest}"></mte-drawer-test>
    `;
    }
};
MutationTestReportTestViewComponent.styles = [unsafeCSS(style), tailwind];
__decorate([
    property()
], MutationTestReportTestViewComponent.prototype, "drawerMode", void 0);
__decorate([
    property()
], MutationTestReportTestViewComponent.prototype, "result", void 0);
__decorate([
    property({ attribute: false, reflect: false })
], MutationTestReportTestViewComponent.prototype, "path", void 0);
__decorate([
    property()
], MutationTestReportTestViewComponent.prototype, "selectedTest", void 0);
MutationTestReportTestViewComponent = __decorate([
    customElement('mte-test-view')
], MutationTestReportTestViewComponent);
const COLUMNS = [
    { key: 'killing', label: 'Killing', tooltip: 'These tests killed at least one mutant', width: 'normal', category: 'number' },
    {
        key: 'covering',
        label: 'Covering',
        tooltip: 'These tests are covering at least one mutant, but not killing any of them.',
        width: 'normal',
        category: 'number',
    },
    {
        key: 'notCovering',
        label: 'Not Covering',
        tooltip: 'These tests were not covering a mutant (and thus not killing any of them).',
        width: 'normal',
        category: 'number',
    },
    { key: 'total', label: 'Total tests', width: 'large', category: 'number', isBold: true },
];
//# sourceMappingURL=test-view.js.map