/*
 * Decompiled with CFR 0.152.
 */
package io.suger.api;

import com.google.gson.reflect.TypeToken;
import io.suger.ApiCallback;
import io.suger.ApiClient;
import io.suger.ApiException;
import io.suger.ApiResponse;
import io.suger.Configuration;
import io.suger.Pair;
import io.suger.client.BillingAddon;
import io.suger.client.BillingInvoice;
import io.suger.client.BillingPaymentTransaction;
import io.suger.client.CreateAndUpdateAddonParams;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class BillingApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public BillingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BillingApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createAddonCall(String orgId, CreateAndUpdateAddonParams data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateAndUpdateAddonParams localVarPostBody = data;
        String localVarPath = "/org/{orgId}/addon".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createAddonValidateBeforeCall(String orgId, CreateAndUpdateAddonParams data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling createAddon(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling createAddon(Async)");
        }
        return this.createAddonCall(orgId, data, _callback);
    }

    public BillingAddon createAddon(String orgId, CreateAndUpdateAddonParams data) throws ApiException {
        ApiResponse<BillingAddon> localVarResp = this.createAddonWithHttpInfo(orgId, data);
        return localVarResp.getData();
    }

    public ApiResponse<BillingAddon> createAddonWithHttpInfo(String orgId, CreateAndUpdateAddonParams data) throws ApiException {
        Call localVarCall = this.createAddonValidateBeforeCall(orgId, data, null);
        Type localVarReturnType = new TypeToken<BillingAddon>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createAddonAsync(String orgId, CreateAndUpdateAddonParams data, ApiCallback<BillingAddon> _callback) throws ApiException {
        Call localVarCall = this.createAddonValidateBeforeCall(orgId, data, _callback);
        Type localVarReturnType = new TypeToken<BillingAddon>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createRefundCall(String orgId, String buyerId, String paymentTransactionId, BigDecimal amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/buyer/{buyerId}/paymentTransaction/{paymentTransactionId}/refund".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{buyerId}", this.localVarApiClient.escapeString(buyerId.toString())).replace("{paymentTransactionId}", this.localVarApiClient.escapeString(paymentTransactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createRefundValidateBeforeCall(String orgId, String buyerId, String paymentTransactionId, BigDecimal amount, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling createRefund(Async)");
        }
        if (buyerId == null) {
            throw new ApiException("Missing the required parameter 'buyerId' when calling createRefund(Async)");
        }
        if (paymentTransactionId == null) {
            throw new ApiException("Missing the required parameter 'paymentTransactionId' when calling createRefund(Async)");
        }
        if (amount == null) {
            throw new ApiException("Missing the required parameter 'amount' when calling createRefund(Async)");
        }
        return this.createRefundCall(orgId, buyerId, paymentTransactionId, amount, _callback);
    }

    public BillingPaymentTransaction createRefund(String orgId, String buyerId, String paymentTransactionId, BigDecimal amount) throws ApiException {
        ApiResponse<BillingPaymentTransaction> localVarResp = this.createRefundWithHttpInfo(orgId, buyerId, paymentTransactionId, amount);
        return localVarResp.getData();
    }

    public ApiResponse<BillingPaymentTransaction> createRefundWithHttpInfo(String orgId, String buyerId, String paymentTransactionId, BigDecimal amount) throws ApiException {
        Call localVarCall = this.createRefundValidateBeforeCall(orgId, buyerId, paymentTransactionId, amount, null);
        Type localVarReturnType = new TypeToken<BillingPaymentTransaction>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createRefundAsync(String orgId, String buyerId, String paymentTransactionId, BigDecimal amount, ApiCallback<BillingPaymentTransaction> _callback) throws ApiException {
        Call localVarCall = this.createRefundValidateBeforeCall(orgId, buyerId, paymentTransactionId, amount, _callback);
        Type localVarReturnType = new TypeToken<BillingPaymentTransaction>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAddonCall(String orgId, String addonId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/addon/{addonId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{addonId}", this.localVarApiClient.escapeString(addonId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAddonValidateBeforeCall(String orgId, String addonId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling deleteAddon(Async)");
        }
        if (addonId == null) {
            throw new ApiException("Missing the required parameter 'addonId' when calling deleteAddon(Async)");
        }
        return this.deleteAddonCall(orgId, addonId, _callback);
    }

    public String deleteAddon(String orgId, String addonId) throws ApiException {
        ApiResponse<String> localVarResp = this.deleteAddonWithHttpInfo(orgId, addonId);
        return localVarResp.getData();
    }

    public ApiResponse<String> deleteAddonWithHttpInfo(String orgId, String addonId) throws ApiException {
        Call localVarCall = this.deleteAddonValidateBeforeCall(orgId, addonId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteAddonAsync(String orgId, String addonId, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.deleteAddonValidateBeforeCall(orgId, addonId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAddonCall(String orgId, String addonId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/addon/{addonId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{addonId}", this.localVarApiClient.escapeString(addonId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAddonValidateBeforeCall(String orgId, String addonId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling getAddon(Async)");
        }
        if (addonId == null) {
            throw new ApiException("Missing the required parameter 'addonId' when calling getAddon(Async)");
        }
        return this.getAddonCall(orgId, addonId, _callback);
    }

    public BillingAddon getAddon(String orgId, String addonId) throws ApiException {
        ApiResponse<BillingAddon> localVarResp = this.getAddonWithHttpInfo(orgId, addonId);
        return localVarResp.getData();
    }

    public ApiResponse<BillingAddon> getAddonWithHttpInfo(String orgId, String addonId) throws ApiException {
        Call localVarCall = this.getAddonValidateBeforeCall(orgId, addonId, null);
        Type localVarReturnType = new TypeToken<BillingAddon>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAddonAsync(String orgId, String addonId, ApiCallback<BillingAddon> _callback) throws ApiException {
        Call localVarCall = this.getAddonValidateBeforeCall(orgId, addonId, _callback);
        Type localVarReturnType = new TypeToken<BillingAddon>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getInvoiceCall(String orgId, String entitlementId, String invoiceId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}/invoice/{invoiceId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString())).replace("{invoiceId}", this.localVarApiClient.escapeString(invoiceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInvoiceValidateBeforeCall(String orgId, String entitlementId, String invoiceId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling getInvoice(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling getInvoice(Async)");
        }
        if (invoiceId == null) {
            throw new ApiException("Missing the required parameter 'invoiceId' when calling getInvoice(Async)");
        }
        return this.getInvoiceCall(orgId, entitlementId, invoiceId, _callback);
    }

    public BillingInvoice getInvoice(String orgId, String entitlementId, String invoiceId) throws ApiException {
        ApiResponse<BillingInvoice> localVarResp = this.getInvoiceWithHttpInfo(orgId, entitlementId, invoiceId);
        return localVarResp.getData();
    }

    public ApiResponse<BillingInvoice> getInvoiceWithHttpInfo(String orgId, String entitlementId, String invoiceId) throws ApiException {
        Call localVarCall = this.getInvoiceValidateBeforeCall(orgId, entitlementId, invoiceId, null);
        Type localVarReturnType = new TypeToken<BillingInvoice>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getInvoiceAsync(String orgId, String entitlementId, String invoiceId, ApiCallback<BillingInvoice> _callback) throws ApiException {
        Call localVarCall = this.getInvoiceValidateBeforeCall(orgId, entitlementId, invoiceId, _callback);
        Type localVarReturnType = new TypeToken<BillingInvoice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call issueInvoiceCall(String orgId, String entitlementId, String invoiceId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}/invoice/{invoiceId}/issue".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString())).replace("{invoiceId}", this.localVarApiClient.escapeString(invoiceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call issueInvoiceValidateBeforeCall(String orgId, String entitlementId, String invoiceId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling issueInvoice(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling issueInvoice(Async)");
        }
        if (invoiceId == null) {
            throw new ApiException("Missing the required parameter 'invoiceId' when calling issueInvoice(Async)");
        }
        return this.issueInvoiceCall(orgId, entitlementId, invoiceId, _callback);
    }

    public BillingInvoice issueInvoice(String orgId, String entitlementId, String invoiceId) throws ApiException {
        ApiResponse<BillingInvoice> localVarResp = this.issueInvoiceWithHttpInfo(orgId, entitlementId, invoiceId);
        return localVarResp.getData();
    }

    public ApiResponse<BillingInvoice> issueInvoiceWithHttpInfo(String orgId, String entitlementId, String invoiceId) throws ApiException {
        Call localVarCall = this.issueInvoiceValidateBeforeCall(orgId, entitlementId, invoiceId, null);
        Type localVarReturnType = new TypeToken<BillingInvoice>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call issueInvoiceAsync(String orgId, String entitlementId, String invoiceId, ApiCallback<BillingInvoice> _callback) throws ApiException {
        Call localVarCall = this.issueInvoiceValidateBeforeCall(orgId, entitlementId, invoiceId, _callback);
        Type localVarReturnType = new TypeToken<BillingInvoice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listAddonsCall(String orgId, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/addon".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listAddonsValidateBeforeCall(String orgId, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listAddons(Async)");
        }
        return this.listAddonsCall(orgId, limit, offset, _callback);
    }

    public List<BillingAddon> listAddons(String orgId, Integer limit, Integer offset) throws ApiException {
        ApiResponse<List<BillingAddon>> localVarResp = this.listAddonsWithHttpInfo(orgId, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<List<BillingAddon>> listAddonsWithHttpInfo(String orgId, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listAddonsValidateBeforeCall(orgId, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<BillingAddon>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listAddonsAsync(String orgId, Integer limit, Integer offset, ApiCallback<List<BillingAddon>> _callback) throws ApiException {
        Call localVarCall = this.listAddonsValidateBeforeCall(orgId, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<BillingAddon>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listInvoicesCall(String orgId, String entitlementId, String buyerId, String status, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/invoice".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (entitlementId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("entitlementId", entitlementId));
        }
        if (buyerId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("buyerId", buyerId));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listInvoicesValidateBeforeCall(String orgId, String entitlementId, String buyerId, String status, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listInvoices(Async)");
        }
        return this.listInvoicesCall(orgId, entitlementId, buyerId, status, limit, offset, _callback);
    }

    public List<BillingInvoice> listInvoices(String orgId, String entitlementId, String buyerId, String status, Integer limit, Integer offset) throws ApiException {
        ApiResponse<List<BillingInvoice>> localVarResp = this.listInvoicesWithHttpInfo(orgId, entitlementId, buyerId, status, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<List<BillingInvoice>> listInvoicesWithHttpInfo(String orgId, String entitlementId, String buyerId, String status, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listInvoicesValidateBeforeCall(orgId, entitlementId, buyerId, status, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<BillingInvoice>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listInvoicesAsync(String orgId, String entitlementId, String buyerId, String status, Integer limit, Integer offset, ApiCallback<List<BillingInvoice>> _callback) throws ApiException {
        Call localVarCall = this.listInvoicesValidateBeforeCall(orgId, entitlementId, buyerId, status, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<BillingInvoice>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listPaymentTransactionsCall(String orgId, String buyerId, String entitlementId, String invoiceId, String status, String type, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/paymentTransaction".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (buyerId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("buyerId", buyerId));
        }
        if (entitlementId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("entitlementId", entitlementId));
        }
        if (invoiceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("invoiceId", invoiceId));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listPaymentTransactionsValidateBeforeCall(String orgId, String buyerId, String entitlementId, String invoiceId, String status, String type, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listPaymentTransactions(Async)");
        }
        return this.listPaymentTransactionsCall(orgId, buyerId, entitlementId, invoiceId, status, type, limit, offset, _callback);
    }

    public List<BillingPaymentTransaction> listPaymentTransactions(String orgId, String buyerId, String entitlementId, String invoiceId, String status, String type, Integer limit, Integer offset) throws ApiException {
        ApiResponse<List<BillingPaymentTransaction>> localVarResp = this.listPaymentTransactionsWithHttpInfo(orgId, buyerId, entitlementId, invoiceId, status, type, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<List<BillingPaymentTransaction>> listPaymentTransactionsWithHttpInfo(String orgId, String buyerId, String entitlementId, String invoiceId, String status, String type, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listPaymentTransactionsValidateBeforeCall(orgId, buyerId, entitlementId, invoiceId, status, type, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<BillingPaymentTransaction>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listPaymentTransactionsAsync(String orgId, String buyerId, String entitlementId, String invoiceId, String status, String type, Integer limit, Integer offset, ApiCallback<List<BillingPaymentTransaction>> _callback) throws ApiException {
        Call localVarCall = this.listPaymentTransactionsValidateBeforeCall(orgId, buyerId, entitlementId, invoiceId, status, type, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<BillingPaymentTransaction>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listRefundOfPaymentTransactionCall(String orgId, String buyerId, String paymentTransactionId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/buyer/{buyerId}/paymentTransaction/{paymentTransactionId}/refund".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{buyerId}", this.localVarApiClient.escapeString(buyerId.toString())).replace("{paymentTransactionId}", this.localVarApiClient.escapeString(paymentTransactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listRefundOfPaymentTransactionValidateBeforeCall(String orgId, String buyerId, String paymentTransactionId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listRefundOfPaymentTransaction(Async)");
        }
        if (buyerId == null) {
            throw new ApiException("Missing the required parameter 'buyerId' when calling listRefundOfPaymentTransaction(Async)");
        }
        if (paymentTransactionId == null) {
            throw new ApiException("Missing the required parameter 'paymentTransactionId' when calling listRefundOfPaymentTransaction(Async)");
        }
        return this.listRefundOfPaymentTransactionCall(orgId, buyerId, paymentTransactionId, _callback);
    }

    public List<BillingPaymentTransaction> listRefundOfPaymentTransaction(String orgId, String buyerId, String paymentTransactionId) throws ApiException {
        ApiResponse<List<BillingPaymentTransaction>> localVarResp = this.listRefundOfPaymentTransactionWithHttpInfo(orgId, buyerId, paymentTransactionId);
        return localVarResp.getData();
    }

    public ApiResponse<List<BillingPaymentTransaction>> listRefundOfPaymentTransactionWithHttpInfo(String orgId, String buyerId, String paymentTransactionId) throws ApiException {
        Call localVarCall = this.listRefundOfPaymentTransactionValidateBeforeCall(orgId, buyerId, paymentTransactionId, null);
        Type localVarReturnType = new TypeToken<List<BillingPaymentTransaction>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listRefundOfPaymentTransactionAsync(String orgId, String buyerId, String paymentTransactionId, ApiCallback<List<BillingPaymentTransaction>> _callback) throws ApiException {
        Call localVarCall = this.listRefundOfPaymentTransactionValidateBeforeCall(orgId, buyerId, paymentTransactionId, _callback);
        Type localVarReturnType = new TypeToken<List<BillingPaymentTransaction>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call payInvoiceCall(String orgId, String entitlementId, String invoiceId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}/invoice/{invoiceId}/pay".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString())).replace("{invoiceId}", this.localVarApiClient.escapeString(invoiceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call payInvoiceValidateBeforeCall(String orgId, String entitlementId, String invoiceId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling payInvoice(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling payInvoice(Async)");
        }
        if (invoiceId == null) {
            throw new ApiException("Missing the required parameter 'invoiceId' when calling payInvoice(Async)");
        }
        return this.payInvoiceCall(orgId, entitlementId, invoiceId, _callback);
    }

    public BillingInvoice payInvoice(String orgId, String entitlementId, String invoiceId) throws ApiException {
        ApiResponse<BillingInvoice> localVarResp = this.payInvoiceWithHttpInfo(orgId, entitlementId, invoiceId);
        return localVarResp.getData();
    }

    public ApiResponse<BillingInvoice> payInvoiceWithHttpInfo(String orgId, String entitlementId, String invoiceId) throws ApiException {
        Call localVarCall = this.payInvoiceValidateBeforeCall(orgId, entitlementId, invoiceId, null);
        Type localVarReturnType = new TypeToken<BillingInvoice>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call payInvoiceAsync(String orgId, String entitlementId, String invoiceId, ApiCallback<BillingInvoice> _callback) throws ApiException {
        Call localVarCall = this.payInvoiceValidateBeforeCall(orgId, entitlementId, invoiceId, _callback);
        Type localVarReturnType = new TypeToken<BillingInvoice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateAddonCall(String orgId, String addonId, CreateAndUpdateAddonParams data, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateAndUpdateAddonParams localVarPostBody = data;
        String localVarPath = "/org/{orgId}/addon/{addonId}".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{addonId}", this.localVarApiClient.escapeString(addonId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateAddonValidateBeforeCall(String orgId, String addonId, CreateAndUpdateAddonParams data, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling updateAddon(Async)");
        }
        if (addonId == null) {
            throw new ApiException("Missing the required parameter 'addonId' when calling updateAddon(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling updateAddon(Async)");
        }
        return this.updateAddonCall(orgId, addonId, data, _callback);
    }

    public BillingAddon updateAddon(String orgId, String addonId, CreateAndUpdateAddonParams data) throws ApiException {
        ApiResponse<BillingAddon> localVarResp = this.updateAddonWithHttpInfo(orgId, addonId, data);
        return localVarResp.getData();
    }

    public ApiResponse<BillingAddon> updateAddonWithHttpInfo(String orgId, String addonId, CreateAndUpdateAddonParams data) throws ApiException {
        Call localVarCall = this.updateAddonValidateBeforeCall(orgId, addonId, data, null);
        Type localVarReturnType = new TypeToken<BillingAddon>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateAddonAsync(String orgId, String addonId, CreateAndUpdateAddonParams data, ApiCallback<BillingAddon> _callback) throws ApiException {
        Call localVarCall = this.updateAddonValidateBeforeCall(orgId, addonId, data, _callback);
        Type localVarReturnType = new TypeToken<BillingAddon>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call voidInvoiceCall(String orgId, String entitlementId, String invoiceId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/org/{orgId}/entitlement/{entitlementId}/invoice/{invoiceId}/void".replace("{orgId}", this.localVarApiClient.escapeString(orgId.toString())).replace("{entitlementId}", this.localVarApiClient.escapeString(entitlementId.toString())).replace("{invoiceId}", this.localVarApiClient.escapeString(invoiceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"APIKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call voidInvoiceValidateBeforeCall(String orgId, String entitlementId, String invoiceId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling voidInvoice(Async)");
        }
        if (entitlementId == null) {
            throw new ApiException("Missing the required parameter 'entitlementId' when calling voidInvoice(Async)");
        }
        if (invoiceId == null) {
            throw new ApiException("Missing the required parameter 'invoiceId' when calling voidInvoice(Async)");
        }
        return this.voidInvoiceCall(orgId, entitlementId, invoiceId, _callback);
    }

    public BillingInvoice voidInvoice(String orgId, String entitlementId, String invoiceId) throws ApiException {
        ApiResponse<BillingInvoice> localVarResp = this.voidInvoiceWithHttpInfo(orgId, entitlementId, invoiceId);
        return localVarResp.getData();
    }

    public ApiResponse<BillingInvoice> voidInvoiceWithHttpInfo(String orgId, String entitlementId, String invoiceId) throws ApiException {
        Call localVarCall = this.voidInvoiceValidateBeforeCall(orgId, entitlementId, invoiceId, null);
        Type localVarReturnType = new TypeToken<BillingInvoice>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call voidInvoiceAsync(String orgId, String entitlementId, String invoiceId, ApiCallback<BillingInvoice> _callback) throws ApiException {
        Call localVarCall = this.voidInvoiceValidateBeforeCall(orgId, entitlementId, invoiceId, _callback);
        Type localVarReturnType = new TypeToken<BillingInvoice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

